// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

//
// This file was autogenerated by a tool.
// Do not modify it.
//

namespace Microsoft.Azure.Batch
{
    using Models = Microsoft.Azure.Batch.Protocol.Models;
    using System;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// Contains utilization and resource usage statistics for the lifetime of a pool.
    /// </summary>
    public partial class PoolStatistics : IPropertyMetadata
    {
        #region Constructors

        internal PoolStatistics(Models.PoolStatistics protocolObject)
        {
            this.LastUpdateTime = protocolObject.LastUpdateTime;
            this.ResourceStatistics = UtilitiesInternal.CreateObjectWithNullCheck(protocolObject.ResourceStats, o => new ResourceStatistics(o).Freeze());
            this.StartTime = protocolObject.StartTime;
            this.Url = protocolObject.Url;
            this.UsageStatistics = UtilitiesInternal.CreateObjectWithNullCheck(protocolObject.UsageStats, o => new UsageStatistics(o).Freeze());
        }

        #endregion Constructors

        #region PoolStatistics

        /// <summary>
        /// Gets the time at which the statistics were last updated. All statistics are limited to the range between <see 
        /// cref="StartTime"/> and this value.
        /// </summary>
        public DateTime LastUpdateTime { get; }

        /// <summary>
        /// Gets statistics related to resource consumption by compute nodes in the pool, such as average CPU utilization.
        /// </summary>
        public ResourceStatistics ResourceStatistics { get; }

        /// <summary>
        /// Gets the start time of the time range covered by the statistics.
        /// </summary>
        public DateTime StartTime { get; }

        /// <summary>
        /// Gets the URL for the statistics.
        /// </summary>
        public string Url { get; }

        /// <summary>
        /// Gets statistics related to pool usage, such as the amount of core-time used.
        /// </summary>
        public UsageStatistics UsageStatistics { get; }

        #endregion // PoolStatistics

        #region IPropertyMetadata

        bool IModifiable.HasBeenModified
        {
            //This class is compile time readonly so it cannot have been modified
            get { return false; }
        }

        bool IReadOnly.IsReadOnly
        {
            get { return true; }
            set
            {
                // This class is compile time readonly already
            }
        }

        #endregion // IPropertyMetadata
    }
}