// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

//
// This file was autogenerated by a tool.
// Do not modify it.
//

namespace Microsoft.Azure.Batch
{
    using Models = Microsoft.Azure.Batch.Protocol.Models;
    using System;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// A pool in the Azure Batch service.
    /// </summary>
    public partial class PoolNodeCounts : IPropertyMetadata
    {
        #region Constructors

        internal PoolNodeCounts(Models.PoolNodeCounts protocolObject)
        {
            this.Dedicated = UtilitiesInternal.CreateObjectWithNullCheck(protocolObject.Dedicated, o => new NodeCounts(o).Freeze());
            this.LowPriority = UtilitiesInternal.CreateObjectWithNullCheck(protocolObject.LowPriority, o => new NodeCounts(o).Freeze());
            this.PoolId = protocolObject.PoolId;
        }

        #endregion Constructors

        #region PoolNodeCounts

        /// <summary>
        /// Gets the number of dedicated nodes in each state.
        /// </summary>
        public NodeCounts Dedicated { get; }

        /// <summary>
        /// Gets the number of low-priority nodes in each state.
        /// </summary>
        public NodeCounts LowPriority { get; }

        /// <summary>
        /// Gets the ID of the pool.
        /// </summary>
        public string PoolId { get; }

        #endregion // PoolNodeCounts

        #region IPropertyMetadata

        bool IModifiable.HasBeenModified
        {
            //This class is compile time readonly so it cannot have been modified
            get { return false; }
        }

        bool IReadOnly.IsReadOnly
        {
            get { return true; }
            set
            {
                // This class is compile time readonly already
            }
        }

        #endregion // IPropertyMetadata
    }
}