// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

//
// This file was autogenerated by a tool.
// Do not modify it.
//

namespace Microsoft.Azure.Batch
{
    using Models = Microsoft.Azure.Batch.Protocol.Models;
    using System;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// Details about an output file upload operation, including under what conditions to perform the upload.
    /// </summary>
    public partial class OutputFileUploadOptions : ITransportObjectProvider<Models.OutputFileUploadOptions>, IPropertyMetadata
    {
        #region Constructors
        /// <summary>
        /// Initializes a new instance of the <see cref="OutputFileUploadOptions"/> class.
        /// </summary>
        /// <param name='uploadCondition'>The conditions under which the file(s) should be uploaded.</param>
        public OutputFileUploadOptions(
            Common.OutputFileUploadCondition uploadCondition)
        {
            this.UploadCondition = uploadCondition;
        }

        internal OutputFileUploadOptions(Models.OutputFileUploadOptions protocolObject)
        {
            this.UploadCondition = UtilitiesInternal.MapEnum<Models.OutputFileUploadCondition, Common.OutputFileUploadCondition>(protocolObject.UploadCondition);
        }

        #endregion Constructors

        #region OutputFileUploadOptions

        /// <summary>
        /// Gets the conditions under which the file(s) should be uploaded.
        /// </summary>
        public Common.OutputFileUploadCondition UploadCondition { get; }

        #endregion // OutputFileUploadOptions

        #region IPropertyMetadata

        bool IModifiable.HasBeenModified
        {
            //This class is compile time readonly so it cannot have been modified
            get { return false; }
        }

        bool IReadOnly.IsReadOnly
        {
            get { return true; }
            set
            {
                // This class is compile time readonly already
            }
        }

        #endregion // IPropertyMetadata

        #region Internal/private methods

        /// <summary>
        /// Return a protocol object of the requested type.
        /// </summary>
        /// <returns>The protocol object of the requested type.</returns>
        Models.OutputFileUploadOptions ITransportObjectProvider<Models.OutputFileUploadOptions>.GetTransportObject()
        {
            Models.OutputFileUploadOptions result = new Models.OutputFileUploadOptions()
            {
                UploadCondition = UtilitiesInternal.MapEnum<Common.OutputFileUploadCondition, Models.OutputFileUploadCondition>(this.UploadCondition),
            };

            return result;
        }


        #endregion // Internal/private methods
    }
}