// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

//
// This file was autogenerated by a tool.
// Do not modify it.
//

namespace Microsoft.Azure.Batch
{
    using Models = Microsoft.Azure.Batch.Protocol.Models;
    using System;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// Specifies a file upload destination within an Azure blob storage container.
    /// </summary>
    public partial class OutputFileBlobContainerDestination : ITransportObjectProvider<Models.OutputFileBlobContainerDestination>, IPropertyMetadata
    {
        private class PropertyContainer : PropertyCollection
        {
            public readonly PropertyAccessor<string> ContainerUrlProperty;
            public readonly PropertyAccessor<ComputeNodeIdentityReference> IdentityReferenceProperty;
            public readonly PropertyAccessor<string> PathProperty;
            public readonly PropertyAccessor<IList<HttpHeader>> UploadHeadersProperty;

            public PropertyContainer() : base(BindingState.Unbound)
            {
                this.ContainerUrlProperty = this.CreatePropertyAccessor<string>(nameof(ContainerUrl), BindingAccess.Read | BindingAccess.Write);
                this.IdentityReferenceProperty = this.CreatePropertyAccessor<ComputeNodeIdentityReference>(nameof(IdentityReference), BindingAccess.Read | BindingAccess.Write);
                this.PathProperty = this.CreatePropertyAccessor<string>(nameof(Path), BindingAccess.Read | BindingAccess.Write);
                this.UploadHeadersProperty = this.CreatePropertyAccessor<IList<HttpHeader>>(nameof(UploadHeaders), BindingAccess.Read | BindingAccess.Write);
            }

            public PropertyContainer(Models.OutputFileBlobContainerDestination protocolObject) : base(BindingState.Bound)
            {
                this.ContainerUrlProperty = this.CreatePropertyAccessor(
                    protocolObject.ContainerUrl,
                    nameof(ContainerUrl),
                    BindingAccess.Read);
                this.IdentityReferenceProperty = this.CreatePropertyAccessor(
                    UtilitiesInternal.CreateObjectWithNullCheck(protocolObject.IdentityReference, o => new ComputeNodeIdentityReference(o).Freeze()),
                    nameof(IdentityReference),
                    BindingAccess.Read);
                this.PathProperty = this.CreatePropertyAccessor(
                    protocolObject.Path,
                    nameof(Path),
                    BindingAccess.Read);
                this.UploadHeadersProperty = this.CreatePropertyAccessor(
                    HttpHeader.ConvertFromProtocolCollectionAndFreeze(protocolObject.UploadHeaders),
                    nameof(UploadHeaders),
                    BindingAccess.Read);
            }
        }

        private readonly PropertyContainer propertyContainer;

        #region Constructors

        /// <summary>
        /// Initializes a new instance of the <see cref="OutputFileBlobContainerDestination"/> class.
        /// </summary>
        /// <param name='containerUrl'>The URL of the container within Azure Blob Storage to which to upload the file(s).</param>
        /// <param name='path'>The destination blob or virtual directory within the Azure Storage container to which to upload the file(s).</param>
        public OutputFileBlobContainerDestination(
            string containerUrl,
            string path = default(string))
        {
            this.propertyContainer = new PropertyContainer();
            this.ContainerUrl = containerUrl;
            this.Path = path;
        }

        /// <summary>
        /// Default constructor to support mocking the <see cref="OutputFileBlobContainerDestination"/> class.
        /// </summary>
        protected OutputFileBlobContainerDestination()
        {
            this.propertyContainer = new PropertyContainer();
        }

        internal OutputFileBlobContainerDestination(Models.OutputFileBlobContainerDestination protocolObject)
        {
            this.propertyContainer = new PropertyContainer(protocolObject);
        }

        #endregion Constructors

        #region OutputFileBlobContainerDestination

        /// <summary>
        /// Gets the URL of the container within Azure Blob Storage to which to upload the file(s).
        /// </summary>
        /// <remarks>
        /// The URL must include a Shared Access Signature (SAS) granting write permissions to the container.
        /// </remarks>
        public string ContainerUrl
        {
            get { return this.propertyContainer.ContainerUrlProperty.Value; }
            private set { this.propertyContainer.ContainerUrlProperty.Value = value; }
        }

        /// <summary>
        /// Gets or sets the reference to the user assigned identity to use to access Azure Blob Storage specified by containerUrl
        /// </summary>
        /// <remarks>
        /// The identity must have write access to the Azure Blob Storage container
        /// </remarks>
        public ComputeNodeIdentityReference IdentityReference
        {
            get { return this.propertyContainer.IdentityReferenceProperty.Value; }
            set { this.propertyContainer.IdentityReferenceProperty.Value = value; }
        }

        /// <summary>
        /// Gets the destination blob or virtual directory within the Azure Storage container to which to upload the file(s).
        /// </summary>
        /// <remarks>
        /// <para>If <see cref="OutputFile.FilePattern"/> refers to a specific file (i.e. it contains no wildcards), then 
        /// this is the name of the blob to which to upload that file.</para><para>If <see cref="OutputFile.FilePattern"/> 
        /// contains wildcards (and may therefore match multiple files), then this then this is the name of the blob virtual 
        /// directory (which is prepended to each blob name) to which to upload the file(s).</para><para>If omitted, file(s) 
        /// are uploaded to the root of the container with a blob name matching their file name.</para>
        /// </remarks>
        public string Path
        {
            get { return this.propertyContainer.PathProperty.Value; }
            private set { this.propertyContainer.PathProperty.Value = value; }
        }

        /// <summary>
        /// Gets or sets a list of name-value pairs for headers to be used in uploading output files.
        /// </summary>
        /// <remarks>
        /// These headers will be specified when uploading files to Azure Storage. For more information, see [Request Headers 
        /// (All Blob Types)](https://docs.microsoft.com/rest/api/storageservices/put-blob#request-headers-all-blob-types).
        /// </remarks>
        public IList<HttpHeader> UploadHeaders
        {
            get { return this.propertyContainer.UploadHeadersProperty.Value; }
            set
            {
                this.propertyContainer.UploadHeadersProperty.Value = ConcurrentChangeTrackedModifiableList<HttpHeader>.TransformEnumerableToConcurrentModifiableList(value);
            }
        }

        #endregion // OutputFileBlobContainerDestination

        #region IPropertyMetadata

        bool IModifiable.HasBeenModified
        {
            get { return this.propertyContainer.HasBeenModified; }
        }

        bool IReadOnly.IsReadOnly
        {
            get { return this.propertyContainer.IsReadOnly; }
            set { this.propertyContainer.IsReadOnly = value; }
        }

        #endregion //IPropertyMetadata

        #region Internal/private methods
        /// <summary>
        /// Return a protocol object of the requested type.
        /// </summary>
        /// <returns>The protocol object of the requested type.</returns>
        Models.OutputFileBlobContainerDestination ITransportObjectProvider<Models.OutputFileBlobContainerDestination>.GetTransportObject()
        {
            Models.OutputFileBlobContainerDestination result = new Models.OutputFileBlobContainerDestination()
            {
                ContainerUrl = this.ContainerUrl,
                IdentityReference = UtilitiesInternal.CreateObjectWithNullCheck(this.IdentityReference, (o) => o.GetTransportObject()),
                Path = this.Path,
                UploadHeaders = UtilitiesInternal.ConvertToProtocolCollection(this.UploadHeaders),
            };

            return result;
        }


        #endregion // Internal/private methods
    }
}