// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

//
// This file was autogenerated by a tool.
// Do not modify it.
//

namespace Microsoft.Azure.Batch
{
    using Models = Microsoft.Azure.Batch.Protocol.Models;
    using System;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// Settings for the operating system disk of the compute node (VM).
    /// </summary>
    public partial class OSDisk : ITransportObjectProvider<Models.OSDisk>, IPropertyMetadata
    {
        private class PropertyContainer : PropertyCollection
        {
            public readonly PropertyAccessor<Common.CachingType?> CachingProperty;
            public readonly PropertyAccessor<int?> DiskSizeGBProperty;
            public readonly PropertyAccessor<DiffDiskSettings> EphemeralOSDiskSettingsProperty;
            public readonly PropertyAccessor<ManagedDisk> ManagedDiskProperty;
            public readonly PropertyAccessor<bool?> WriteAcceleratorEnabledProperty;

            public PropertyContainer() : base(BindingState.Unbound)
            {
                this.CachingProperty = this.CreatePropertyAccessor<Common.CachingType?>(nameof(Caching), BindingAccess.Read | BindingAccess.Write);
                this.DiskSizeGBProperty = this.CreatePropertyAccessor<int?>(nameof(DiskSizeGB), BindingAccess.Read | BindingAccess.Write);
                this.EphemeralOSDiskSettingsProperty = this.CreatePropertyAccessor<DiffDiskSettings>(nameof(EphemeralOSDiskSettings), BindingAccess.Read | BindingAccess.Write);
                this.ManagedDiskProperty = this.CreatePropertyAccessor<ManagedDisk>(nameof(ManagedDisk), BindingAccess.Read | BindingAccess.Write);
                this.WriteAcceleratorEnabledProperty = this.CreatePropertyAccessor<bool?>(nameof(WriteAcceleratorEnabled), BindingAccess.Read | BindingAccess.Write);
            }

            public PropertyContainer(Models.OSDisk protocolObject) : base(BindingState.Bound)
            {
                this.CachingProperty = this.CreatePropertyAccessor(
                    UtilitiesInternal.MapNullableEnum<Models.CachingType, Common.CachingType>(protocolObject.Caching),
                    nameof(Caching),
                    BindingAccess.Read | BindingAccess.Write);
                this.DiskSizeGBProperty = this.CreatePropertyAccessor(
                    protocolObject.DiskSizeGB,
                    nameof(DiskSizeGB),
                    BindingAccess.Read | BindingAccess.Write);
                this.EphemeralOSDiskSettingsProperty = this.CreatePropertyAccessor(
                    UtilitiesInternal.CreateObjectWithNullCheck(protocolObject.EphemeralOSDiskSettings, o => new DiffDiskSettings(o)),
                    nameof(EphemeralOSDiskSettings),
                    BindingAccess.Read | BindingAccess.Write);
                this.ManagedDiskProperty = this.CreatePropertyAccessor(
                    UtilitiesInternal.CreateObjectWithNullCheck(protocolObject.ManagedDisk, o => new ManagedDisk(o)),
                    nameof(ManagedDisk),
                    BindingAccess.Read | BindingAccess.Write);
                this.WriteAcceleratorEnabledProperty = this.CreatePropertyAccessor(
                    protocolObject.WriteAcceleratorEnabled,
                    nameof(WriteAcceleratorEnabled),
                    BindingAccess.Read | BindingAccess.Write);
            }
        }

        private readonly PropertyContainer propertyContainer;

        #region Constructors

        /// <summary>
        /// Initializes a new instance of the <see cref="OSDisk"/> class.
        /// </summary>
        public OSDisk()
        {
            this.propertyContainer = new PropertyContainer();
        }

        internal OSDisk(Models.OSDisk protocolObject)
        {
            this.propertyContainer = new PropertyContainer(protocolObject);
        }

        #endregion Constructors

        #region OSDisk

        /// <summary>
        /// Gets or sets specifies the caching requirements. Possible values are: None, ReadOnly, ReadWrite. The default 
        /// values are: None for Standard storage. ReadOnly for Premium storage.
        /// </summary>
        public Common.CachingType? Caching
        {
            get { return this.propertyContainer.CachingProperty.Value; }
            set { this.propertyContainer.CachingProperty.Value = value; }
        }

        /// <summary>
        /// Gets or sets the initial disk size in GB when creating new OS disk.
        /// </summary>
        public int? DiskSizeGB
        {
            get { return this.propertyContainer.DiskSizeGBProperty.Value; }
            set { this.propertyContainer.DiskSizeGBProperty.Value = value; }
        }

        /// <summary>
        /// Gets or sets specifies the ephemeral Disk Settings for the operating system disk used by the compute node (VM).
        /// </summary>
        public DiffDiskSettings EphemeralOSDiskSettings
        {
            get { return this.propertyContainer.EphemeralOSDiskSettingsProperty.Value; }
            set { this.propertyContainer.EphemeralOSDiskSettingsProperty.Value = value; }
        }

        /// <summary>
        /// Gets or sets the managed disk parameters.
        /// </summary>
        public ManagedDisk ManagedDisk
        {
            get { return this.propertyContainer.ManagedDiskProperty.Value; }
            set { this.propertyContainer.ManagedDiskProperty.Value = value; }
        }

        /// <summary>
        /// Gets or sets specifies whether writeAccelerator should be enabled or disabled on the disk.
        /// </summary>
        public bool? WriteAcceleratorEnabled
        {
            get { return this.propertyContainer.WriteAcceleratorEnabledProperty.Value; }
            set { this.propertyContainer.WriteAcceleratorEnabledProperty.Value = value; }
        }

        #endregion // OSDisk

        #region IPropertyMetadata

        bool IModifiable.HasBeenModified
        {
            get { return this.propertyContainer.HasBeenModified; }
        }

        bool IReadOnly.IsReadOnly
        {
            get { return this.propertyContainer.IsReadOnly; }
            set { this.propertyContainer.IsReadOnly = value; }
        }

        #endregion //IPropertyMetadata

        #region Internal/private methods
        /// <summary>
        /// Return a protocol object of the requested type.
        /// </summary>
        /// <returns>The protocol object of the requested type.</returns>
        Models.OSDisk ITransportObjectProvider<Models.OSDisk>.GetTransportObject()
        {
            Models.OSDisk result = new Models.OSDisk()
            {
                Caching = UtilitiesInternal.MapNullableEnum<Common.CachingType, Models.CachingType>(this.Caching),
                DiskSizeGB = this.DiskSizeGB,
                EphemeralOSDiskSettings = UtilitiesInternal.CreateObjectWithNullCheck(this.EphemeralOSDiskSettings, (o) => o.GetTransportObject()),
                ManagedDisk = UtilitiesInternal.CreateObjectWithNullCheck(this.ManagedDisk, (o) => o.GetTransportObject()),
                WriteAcceleratorEnabled = this.WriteAcceleratorEnabled,
            };

            return result;
        }


        #endregion // Internal/private methods
    }
}