// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

//
// This file was autogenerated by a tool.
// Do not modify it.
//

namespace Microsoft.Azure.Batch
{
    using Models = Microsoft.Azure.Batch.Protocol.Models;
    using System;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// The configuration for virtual machine extension instance view.
    /// </summary>
    public partial class NodeVMExtension : ITransportObjectProvider<Models.NodeVMExtension>, IPropertyMetadata
    {
        private class PropertyContainer : PropertyCollection
        {
            public readonly PropertyAccessor<VMExtensionInstanceView> InstanceViewProperty;
            public readonly PropertyAccessor<string> ProvisioningStateProperty;
            public readonly PropertyAccessor<VMExtension> VmExtensionProperty;

            public PropertyContainer() : base(BindingState.Unbound)
            {
                this.InstanceViewProperty = this.CreatePropertyAccessor<VMExtensionInstanceView>(nameof(InstanceView), BindingAccess.Read | BindingAccess.Write);
                this.ProvisioningStateProperty = this.CreatePropertyAccessor<string>(nameof(ProvisioningState), BindingAccess.Read | BindingAccess.Write);
                this.VmExtensionProperty = this.CreatePropertyAccessor<VMExtension>(nameof(VmExtension), BindingAccess.Read | BindingAccess.Write);
            }

            public PropertyContainer(Models.NodeVMExtension protocolObject) : base(BindingState.Bound)
            {
                this.InstanceViewProperty = this.CreatePropertyAccessor(
                    UtilitiesInternal.CreateObjectWithNullCheck(protocolObject.InstanceView, o => new VMExtensionInstanceView(o).Freeze()),
                    nameof(InstanceView),
                    BindingAccess.Read);
                this.ProvisioningStateProperty = this.CreatePropertyAccessor(
                    protocolObject.ProvisioningState,
                    nameof(ProvisioningState),
                    BindingAccess.Read);
                this.VmExtensionProperty = this.CreatePropertyAccessor(
                    UtilitiesInternal.CreateObjectWithNullCheck(protocolObject.VmExtension, o => new VMExtension(o).Freeze()),
                    nameof(VmExtension),
                    BindingAccess.Read);
            }
        }

        private readonly PropertyContainer propertyContainer;

        #region Constructors

        /// <summary>
        /// Initializes a new instance of the <see cref="NodeVMExtension"/> class.
        /// </summary>
        public NodeVMExtension()
        {
            this.propertyContainer = new PropertyContainer();
        }

        internal NodeVMExtension(Models.NodeVMExtension protocolObject)
        {
            this.propertyContainer = new PropertyContainer(protocolObject);
        }

        #endregion Constructors

        #region NodeVMExtension

        /// <summary>
        /// Gets or sets the vm extension instance view.
        /// </summary>
        public VMExtensionInstanceView InstanceView
        {
            get { return this.propertyContainer.InstanceViewProperty.Value; }
            set { this.propertyContainer.InstanceViewProperty.Value = value; }
        }

        /// <summary>
        /// Gets or sets the provisioning state of the virtual machine extension.
        /// </summary>
        public string ProvisioningState
        {
            get { return this.propertyContainer.ProvisioningStateProperty.Value; }
            set { this.propertyContainer.ProvisioningStateProperty.Value = value; }
        }

        /// <summary>
        /// Gets or sets the virtual machine extension
        /// </summary>
        public VMExtension VmExtension
        {
            get { return this.propertyContainer.VmExtensionProperty.Value; }
            set { this.propertyContainer.VmExtensionProperty.Value = value; }
        }

        #endregion // NodeVMExtension

        #region IPropertyMetadata

        bool IModifiable.HasBeenModified
        {
            get { return this.propertyContainer.HasBeenModified; }
        }

        bool IReadOnly.IsReadOnly
        {
            get { return this.propertyContainer.IsReadOnly; }
            set { this.propertyContainer.IsReadOnly = value; }
        }

        #endregion //IPropertyMetadata

        #region Internal/private methods
        /// <summary>
        /// Return a protocol object of the requested type.
        /// </summary>
        /// <returns>The protocol object of the requested type.</returns>
        Models.NodeVMExtension ITransportObjectProvider<Models.NodeVMExtension>.GetTransportObject()
        {
            Models.NodeVMExtension result = new Models.NodeVMExtension()
            {
                InstanceView = UtilitiesInternal.CreateObjectWithNullCheck(this.InstanceView, (o) => o.GetTransportObject()),
                ProvisioningState = this.ProvisioningState,
                VmExtension = UtilitiesInternal.CreateObjectWithNullCheck(this.VmExtension, (o) => o.GetTransportObject()),
            };

            return result;
        }


        #endregion // Internal/private methods
    }
}