// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

//
// This file was autogenerated by a tool.
// Do not modify it.
//

namespace Microsoft.Azure.Batch
{
    using Models = Microsoft.Azure.Batch.Protocol.Models;
    using System;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// Node placement configuration for a pool.
    /// </summary>
    public partial class NodePlacementConfiguration : ITransportObjectProvider<Models.NodePlacementConfiguration>, IPropertyMetadata
    {
        #region Constructors
        /// <summary>
        /// Initializes a new instance of the <see cref="NodePlacementConfiguration"/> class.
        /// </summary>
        /// <param name='policy'>Node placement Policy type on Batch Pools.</param>
        public NodePlacementConfiguration(
            Common.NodePlacementPolicyType? policy)
        {
            this.Policy = policy;
        }

        internal NodePlacementConfiguration(Models.NodePlacementConfiguration protocolObject)
        {
            this.Policy = UtilitiesInternal.MapNullableEnum<Models.NodePlacementPolicyType, Common.NodePlacementPolicyType>(protocolObject.Policy);
        }

        #endregion Constructors

        #region NodePlacementConfiguration

        /// <summary>
        /// Gets node placement Policy type on Batch Pools.
        /// </summary>
        /// <remarks>
        /// Allocation policy used by Batch Service to provision the nodes. If not specified, Batch will use the regional 
        /// policy.
        /// </remarks>
        public Common.NodePlacementPolicyType? Policy { get; }

        #endregion // NodePlacementConfiguration

        #region IPropertyMetadata

        bool IModifiable.HasBeenModified
        {
            //This class is compile time readonly so it cannot have been modified
            get { return false; }
        }

        bool IReadOnly.IsReadOnly
        {
            get { return true; }
            set
            {
                // This class is compile time readonly already
            }
        }

        #endregion // IPropertyMetadata

        #region Internal/private methods

        /// <summary>
        /// Return a protocol object of the requested type.
        /// </summary>
        /// <returns>The protocol object of the requested type.</returns>
        Models.NodePlacementConfiguration ITransportObjectProvider<Models.NodePlacementConfiguration>.GetTransportObject()
        {
            Models.NodePlacementConfiguration result = new Models.NodePlacementConfiguration()
            {
                Policy = UtilitiesInternal.MapNullableEnum<Common.NodePlacementPolicyType, Models.NodePlacementPolicyType>(this.Policy),
            };

            return result;
        }


        #endregion // Internal/private methods
    }
}