// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

//
// This file was autogenerated by a tool.
// Do not modify it.
//

namespace Microsoft.Azure.Batch
{
    using Models = Microsoft.Azure.Batch.Protocol.Models;
    using System;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// The number of nodes in each node state.
    /// </summary>
    public partial class NodeCounts : IPropertyMetadata
    {
        #region Constructors

        internal NodeCounts(Models.NodeCounts protocolObject)
        {
            this.Creating = protocolObject.Creating;
            this.Deallocated = protocolObject.Deallocated;
            this.Deallocating = protocolObject.Deallocating;
            this.Idle = protocolObject.Idle;
            this.LeavingPool = protocolObject.LeavingPool;
            this.Offline = protocolObject.Offline;
            this.Preempted = protocolObject.Preempted;
            this.Rebooting = protocolObject.Rebooting;
            this.Reimaging = protocolObject.Reimaging;
            this.Running = protocolObject.Running;
            this.Starting = protocolObject.Starting;
            this.StartTaskFailed = protocolObject.StartTaskFailed;
            this.Total = protocolObject.Total;
            this.Unknown = protocolObject.Unknown;
            this.Unusable = protocolObject.Unusable;
            this.UpgradingOS = protocolObject.UpgradingOS;
            this.WaitingForStartTask = protocolObject.WaitingForStartTask;
        }

        #endregion Constructors

        #region NodeCounts

        /// <summary>
        /// Gets the number of nodes in <see cref="Common.ComputeNodeState.Creating" />.
        /// </summary>
        public int Creating { get; }

        /// <summary>
        /// Gets the number of Compute Nodes in the deallocated state.
        /// </summary>
        public int Deallocated { get; }

        /// <summary>
        /// Gets the number of Compute Nodes in the deallocating state.
        /// </summary>
        public int Deallocating { get; }

        /// <summary>
        /// Gets the number of nodes in <see cref="Common.ComputeNodeState.Idle" />.
        /// </summary>
        public int Idle { get; }

        /// <summary>
        /// Gets the number of nodes in <see cref="Common.ComputeNodeState.LeavingPool" />.
        /// </summary>
        public int LeavingPool { get; }

        /// <summary>
        /// Gets the number of nodes in <see cref="Common.ComputeNodeState.Offline" />.
        /// </summary>
        public int Offline { get; }

        /// <summary>
        /// Gets the number of nodes in <see cref="Common.ComputeNodeState.Preempted" />.
        /// </summary>
        public int Preempted { get; }

        /// <summary>
        /// Gets the number of nodes in <see cref="Common.ComputeNodeState.Rebooting" />.
        /// </summary>
        public int Rebooting { get; }

        /// <summary>
        /// Gets the number of nodes in <see cref="Common.ComputeNodeState.Reimaging" />.
        /// </summary>
        public int Reimaging { get; }

        /// <summary>
        /// Gets the number of nodes in <see cref="Common.ComputeNodeState.Running" />.
        /// </summary>
        public int Running { get; }

        /// <summary>
        /// Gets the number of nodes in <see cref="Common.ComputeNodeState.Starting" />.
        /// </summary>
        public int Starting { get; }

        /// <summary>
        /// Gets the number of nodes in <see cref="Common.ComputeNodeState.StartTaskFailed" />.
        /// </summary>
        public int StartTaskFailed { get; }

        /// <summary>
        /// Gets the total number of nodes.
        /// </summary>
        public int Total { get; }

        /// <summary>
        /// Gets the number of nodes in <see cref="Common.ComputeNodeState.Unknown" />.
        /// </summary>
        public int Unknown { get; }

        /// <summary>
        /// Gets the number of nodes in <see cref="Common.ComputeNodeState.Unusable" />.
        /// </summary>
        public int Unusable { get; }

        /// <summary>
        /// Gets the number of nodes in <see cref="Common.ComputeNodeState.UpgradingOS" />.
        /// </summary>
        public int UpgradingOS { get; }

        /// <summary>
        /// Gets the number of nodes in <see cref="Common.ComputeNodeState.WaitingForStartTask" />.
        /// </summary>
        public int WaitingForStartTask { get; }

        #endregion // NodeCounts

        #region IPropertyMetadata

        bool IModifiable.HasBeenModified
        {
            //This class is compile time readonly so it cannot have been modified
            get { return false; }
        }

        bool IReadOnly.IsReadOnly
        {
            get { return true; }
            set
            {
                // This class is compile time readonly already
            }
        }

        #endregion // IPropertyMetadata
    }
}