// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

//
// This file was autogenerated by a tool.
// Do not modify it.
//

namespace Microsoft.Azure.Batch
{
    using Models = Microsoft.Azure.Batch.Protocol.Models;
    using System;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// Information about the node agent
    /// </summary>
    /// <remarks>
    /// The Batch node agent is a program that runs on each node in the pool and provides Batch capability on the compute 
    /// node.
    /// </remarks>
    public partial class NodeAgentInformation : IPropertyMetadata
    {
        #region Constructors

        internal NodeAgentInformation(Models.NodeAgentInformation protocolObject)
        {
            this.LastUpdateTime = protocolObject.LastUpdateTime;
            this.Version = protocolObject.Version;
        }

        #endregion Constructors

        #region NodeAgentInformation

        /// <summary>
        /// Gets the time when the node agent was updated on the compute node.
        /// </summary>
        /// <remarks>
        /// This is the most recent time that the node agent was updated to a new version.
        /// </remarks>
        public DateTime LastUpdateTime { get; }

        /// <summary>
        /// Gets the version of the Batch node agent running on the compute node.
        /// </summary>
        /// <remarks>
        /// This version number can be checked against the node agent release notes located at https://github.com/Azure/Batch/blob/master/changelogs/nodeagent/CHANGELOG.md.
        /// </remarks>
        public string Version { get; }

        #endregion // NodeAgentInformation

        #region IPropertyMetadata

        bool IModifiable.HasBeenModified
        {
            //This class is compile time readonly so it cannot have been modified
            get { return false; }
        }

        bool IReadOnly.IsReadOnly
        {
            get { return true; }
            set
            {
                // This class is compile time readonly already
            }
        }

        #endregion // IPropertyMetadata
    }
}