// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

//
// This file was autogenerated by a tool.
// Do not modify it.
//

namespace Microsoft.Azure.Batch
{
    using Models = Microsoft.Azure.Batch.Protocol.Models;
    using System;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// Information used to connect to an NFS file system.
    /// </summary>
    public partial class NfsMountConfiguration : ITransportObjectProvider<Models.NFSMountConfiguration>, IPropertyMetadata
    {
        #region Constructors
        /// <summary>
        /// Initializes a new instance of the <see cref="NfsMountConfiguration"/> class.
        /// </summary>
        /// <param name='source'>The URI of the file system to mount.</param>
        /// <param name='relativeMountPath'>The relative path on the compute node where the file system will be mounted.</param>
        /// <param name='mountOptions'>Additional command line options to pass to the mount command.</param>
        public NfsMountConfiguration(
            string source,
            string relativeMountPath,
            string mountOptions = default(string))
        {
            this.Source = source;
            this.RelativeMountPath = relativeMountPath;
            this.MountOptions = mountOptions;
        }

        internal NfsMountConfiguration(Models.NFSMountConfiguration protocolObject)
        {
            this.MountOptions = protocolObject.MountOptions;
            this.RelativeMountPath = protocolObject.RelativeMountPath;
            this.Source = protocolObject.Source;
        }

        #endregion Constructors

        #region NfsMountConfiguration

        /// <summary>
        /// Gets additional command line options to pass to the mount command.
        /// </summary>
        /// <remarks>
        /// These are 'net use' options in Windows and 'mount' options in Linux.
        /// </remarks>
        public string MountOptions { get; }

        /// <summary>
        /// Gets the relative path on the compute node where the file system will be mounted.
        /// </summary>
        /// <remarks>
        /// All file systems are mounted relative to the Batch mounts directory, accessible via the AZ_BATCH_NODE_MOUNTS_DIR 
        /// environment variable.
        /// </remarks>
        public string RelativeMountPath { get; }

        /// <summary>
        /// Gets the URI of the file system to mount.
        /// </summary>
        public string Source { get; }

        #endregion // NfsMountConfiguration

        #region IPropertyMetadata

        bool IModifiable.HasBeenModified
        {
            //This class is compile time readonly so it cannot have been modified
            get { return false; }
        }

        bool IReadOnly.IsReadOnly
        {
            get { return true; }
            set
            {
                // This class is compile time readonly already
            }
        }

        #endregion // IPropertyMetadata

        #region Internal/private methods

        /// <summary>
        /// Return a protocol object of the requested type.
        /// </summary>
        /// <returns>The protocol object of the requested type.</returns>
        Models.NFSMountConfiguration ITransportObjectProvider<Models.NFSMountConfiguration>.GetTransportObject()
        {
            Models.NFSMountConfiguration result = new Models.NFSMountConfiguration()
            {
                MountOptions = this.MountOptions,
                RelativeMountPath = this.RelativeMountPath,
                Source = this.Source,
            };

            return result;
        }


        #endregion // Internal/private methods
    }
}