// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

//
// This file was autogenerated by a tool.
// Do not modify it.
//

namespace Microsoft.Azure.Batch
{
    using Models = Microsoft.Azure.Batch.Protocol.Models;
    using System;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// A network security group rule to apply to an inbound endpoint.
    /// </summary>
    public partial class NetworkSecurityGroupRule : ITransportObjectProvider<Models.NetworkSecurityGroupRule>, IPropertyMetadata
    {
        #region Constructors
        /// <summary>
        /// Initializes a new instance of the <see cref="NetworkSecurityGroupRule"/> class.
        /// </summary>
        /// <param name='priority'>The priority for this rule.</param>
        /// <param name='access'>The action that should be taken for a specified IP address, subnet range or tag.</param>
        /// <param name='sourceAddressPrefix'>The source address prefix or tag to match for the rule.</param>
        /// <param name='sourcePortRanges'>The source port ranges to match for the rule.</param>
        public NetworkSecurityGroupRule(
            int priority,
            Common.NetworkSecurityGroupRuleAccess access,
            string sourceAddressPrefix,
            IReadOnlyList<string> sourcePortRanges = default(IReadOnlyList<string>))
        {
            this.Priority = priority;
            this.Access = access;
            this.SourceAddressPrefix = sourceAddressPrefix;
            this.SourcePortRanges = sourcePortRanges;
        }

        internal NetworkSecurityGroupRule(Models.NetworkSecurityGroupRule protocolObject)
        {
            this.Access = UtilitiesInternal.MapEnum<Models.NetworkSecurityGroupRuleAccess, Common.NetworkSecurityGroupRuleAccess>(protocolObject.Access);
            this.Priority = protocolObject.Priority;
            this.SourceAddressPrefix = protocolObject.SourceAddressPrefix;
            this.SourcePortRanges = UtilitiesInternal.CreateObjectWithNullCheck(protocolObject.SourcePortRanges, o => o.ToList().AsReadOnly());
        }

        #endregion Constructors

        #region NetworkSecurityGroupRule

        /// <summary>
        /// Gets the action that should be taken for a specified IP address, subnet range or tag.
        /// </summary>
        public Common.NetworkSecurityGroupRuleAccess Access { get; }

        /// <summary>
        /// Gets the priority for this rule.
        /// </summary>
        /// <remarks>
        /// Priorities within a pool must be unique and are evaluated in order of priority. The lower the number the higher 
        /// the priority. For example, rules could be specified with order numbers of 150, 250, and 350. The rule with the 
        /// order number of 150 takes precedence over the rule that has an order of 250. Allowed priorities are 150 to 4096.
        /// </remarks>
        public int Priority { get; }

        /// <summary>
        /// Gets the source address prefix or tag to match for the rule.
        /// </summary>
        /// <remarks>
        /// Valid values are a single IP address (i.e. 10.10.10.10), IP subnet (i.e. 192.168.1.0/24), default tag, or * (for 
        /// all addresses).
        /// </remarks>
        public string SourceAddressPrefix { get; }

        /// <summary>
        /// Gets the source port ranges to match for the rule.
        /// </summary>
        /// <remarks>
        /// Valid values are '*' (for all ports 0 - 65535), a specific port (i.e. 22), or a port range (i.e. 100-200). The 
        /// ports must be in the range of 0 to 65535. Each entry in this collection must not overlap any other entry (either 
        /// a range or an individual port). If any other values are provided the request fails with HTTP status code 400. 
        /// The default value is '*'
        /// </remarks>
        public IReadOnlyList<string> SourcePortRanges { get; }

        #endregion // NetworkSecurityGroupRule

        #region IPropertyMetadata

        bool IModifiable.HasBeenModified
        {
            //This class is compile time readonly so it cannot have been modified
            get { return false; }
        }

        bool IReadOnly.IsReadOnly
        {
            get { return true; }
            set
            {
                // This class is compile time readonly already
            }
        }

        #endregion // IPropertyMetadata

        #region Internal/private methods

        /// <summary>
        /// Return a protocol object of the requested type.
        /// </summary>
        /// <returns>The protocol object of the requested type.</returns>
        Models.NetworkSecurityGroupRule ITransportObjectProvider<Models.NetworkSecurityGroupRule>.GetTransportObject()
        {
            Models.NetworkSecurityGroupRule result = new Models.NetworkSecurityGroupRule()
            {
                Access = UtilitiesInternal.MapEnum<Common.NetworkSecurityGroupRuleAccess, Models.NetworkSecurityGroupRuleAccess>(this.Access),
                Priority = this.Priority,
                SourceAddressPrefix = this.SourceAddressPrefix,
                SourcePortRanges = UtilitiesInternal.CreateObjectWithNullCheck(this.SourcePortRanges, o => o.ToList()),
            };

            return result;
        }

        /// <summary>
        /// Converts a collection of protocol layer objects to object layer collection objects.
        /// </summary>
        internal static IList<NetworkSecurityGroupRule> ConvertFromProtocolCollection(IEnumerable<Models.NetworkSecurityGroupRule> protoCollection)
        {
            ConcurrentChangeTrackedModifiableList<NetworkSecurityGroupRule> converted = UtilitiesInternal.CollectionToThreadSafeCollectionIModifiable(
                items: protoCollection,
                objectCreationFunc: o => new NetworkSecurityGroupRule(o));

            return converted;
        }

        /// <summary>
        /// Converts a collection of protocol layer objects to object layer collection objects, in a frozen state.
        /// </summary>
        internal static IList<NetworkSecurityGroupRule> ConvertFromProtocolCollectionAndFreeze(IEnumerable<Models.NetworkSecurityGroupRule> protoCollection)
        {
            ConcurrentChangeTrackedModifiableList<NetworkSecurityGroupRule> converted = UtilitiesInternal.CollectionToThreadSafeCollectionIModifiable(
                items: protoCollection,
                objectCreationFunc: o => new NetworkSecurityGroupRule(o).Freeze());

            converted = UtilitiesInternal.CreateObjectWithNullCheck(converted, o => o.Freeze());

            return converted;
        }

        /// <summary>
        /// Converts a collection of protocol layer objects to object layer collection objects, with each object marked readonly
        /// and returned as a readonly collection.
        /// </summary>
        internal static IReadOnlyList<NetworkSecurityGroupRule> ConvertFromProtocolCollectionReadOnly(IEnumerable<Models.NetworkSecurityGroupRule> protoCollection)
        {
            IReadOnlyList<NetworkSecurityGroupRule> converted =
                UtilitiesInternal.CreateObjectWithNullCheck(
                    UtilitiesInternal.CollectionToNonThreadSafeCollection(
                        items: protoCollection,
                        objectCreationFunc: o => new NetworkSecurityGroupRule(o).Freeze()), o => o.AsReadOnly());

            return converted;
        }

        #endregion // Internal/private methods
    }
}