// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

//
// This file was autogenerated by a tool.
// Do not modify it.
//

namespace Microsoft.Azure.Batch
{
    using Models = Microsoft.Azure.Batch.Protocol.Models;
    using System;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// The network configuration for a pool.
    /// </summary>
    public partial class NetworkConfiguration : ITransportObjectProvider<Models.NetworkConfiguration>, IPropertyMetadata
    {
        private class PropertyContainer : PropertyCollection
        {
            public readonly PropertyAccessor<Common.DynamicVNetAssignmentScope?> DynamicVNetAssignmentScopeProperty;
            public readonly PropertyAccessor<bool?> EnableAcceleratedNetworkingProperty;
            public readonly PropertyAccessor<PoolEndpointConfiguration> EndpointConfigurationProperty;
            public readonly PropertyAccessor<PublicIPAddressConfiguration> PublicIPAddressConfigurationProperty;
            public readonly PropertyAccessor<string> SubnetIdProperty;

            public PropertyContainer() : base(BindingState.Unbound)
            {
                this.DynamicVNetAssignmentScopeProperty = this.CreatePropertyAccessor<Common.DynamicVNetAssignmentScope?>(nameof(DynamicVNetAssignmentScope), BindingAccess.Read | BindingAccess.Write);
                this.EnableAcceleratedNetworkingProperty = this.CreatePropertyAccessor<bool?>(nameof(EnableAcceleratedNetworking), BindingAccess.Read | BindingAccess.Write);
                this.EndpointConfigurationProperty = this.CreatePropertyAccessor<PoolEndpointConfiguration>(nameof(EndpointConfiguration), BindingAccess.Read | BindingAccess.Write);
                this.PublicIPAddressConfigurationProperty = this.CreatePropertyAccessor<PublicIPAddressConfiguration>(nameof(PublicIPAddressConfiguration), BindingAccess.Read | BindingAccess.Write);
                this.SubnetIdProperty = this.CreatePropertyAccessor<string>(nameof(SubnetId), BindingAccess.Read | BindingAccess.Write);
            }

            public PropertyContainer(Models.NetworkConfiguration protocolObject) : base(BindingState.Bound)
            {
                this.DynamicVNetAssignmentScopeProperty = this.CreatePropertyAccessor(
                    UtilitiesInternal.MapNullableEnum<Models.DynamicVNetAssignmentScope, Common.DynamicVNetAssignmentScope>(protocolObject.DynamicVNetAssignmentScope),
                    nameof(DynamicVNetAssignmentScope),
                    BindingAccess.Read);
                this.EnableAcceleratedNetworkingProperty = this.CreatePropertyAccessor(
                    protocolObject.EnableAcceleratedNetworking,
                    nameof(EnableAcceleratedNetworking),
                    BindingAccess.Read);
                this.EndpointConfigurationProperty = this.CreatePropertyAccessor(
                    UtilitiesInternal.CreateObjectWithNullCheck(protocolObject.EndpointConfiguration, o => new PoolEndpointConfiguration(o).Freeze()),
                    nameof(EndpointConfiguration),
                    BindingAccess.Read);
                this.PublicIPAddressConfigurationProperty = this.CreatePropertyAccessor(
                    UtilitiesInternal.CreateObjectWithNullCheck(protocolObject.PublicIPAddressConfiguration, o => new PublicIPAddressConfiguration(o).Freeze()),
                    nameof(PublicIPAddressConfiguration),
                    BindingAccess.Read);
                this.SubnetIdProperty = this.CreatePropertyAccessor(
                    protocolObject.SubnetId,
                    nameof(SubnetId),
                    BindingAccess.Read);
            }
        }

        private readonly PropertyContainer propertyContainer;

        #region Constructors

        /// <summary>
        /// Initializes a new instance of the <see cref="NetworkConfiguration"/> class.
        /// </summary>
        public NetworkConfiguration()
        {
            this.propertyContainer = new PropertyContainer();
        }

        internal NetworkConfiguration(Models.NetworkConfiguration protocolObject)
        {
            this.propertyContainer = new PropertyContainer(protocolObject);
        }

        #endregion Constructors

        #region NetworkConfiguration

        /// <summary>
        /// Gets or sets the scope of the dynamic VNet assignment.
        /// </summary>
        /// <remarks>
        /// This property can only be specified for pools created with a <see cref="CloudPool.VirtualMachineConfiguration"/>.
        /// </remarks>
        public Common.DynamicVNetAssignmentScope? DynamicVNetAssignmentScope
        {
            get { return this.propertyContainer.DynamicVNetAssignmentScopeProperty.Value; }
            set { this.propertyContainer.DynamicVNetAssignmentScopeProperty.Value = value; }
        }

        /// <summary>
        /// Gets or sets whether this pool should enable accelerated networking.
        /// </summary>
        /// <remarks>
        /// This property can only be specified for pools created with a <see cref="CloudPool.VirtualMachineConfiguration"/>.
        /// </remarks>
        public bool? EnableAcceleratedNetworking
        {
            get { return this.propertyContainer.EnableAcceleratedNetworkingProperty.Value; }
            set { this.propertyContainer.EnableAcceleratedNetworkingProperty.Value = value; }
        }

        /// <summary>
        /// Gets or sets the configuration for endpoints on compute nodes in the Batch pool.
        /// </summary>
        /// <remarks>
        /// This property can only be specified for pools created with a <see cref="CloudPool.VirtualMachineConfiguration"/>.
        /// </remarks>
        public PoolEndpointConfiguration EndpointConfiguration
        {
            get { return this.propertyContainer.EndpointConfigurationProperty.Value; }
            set { this.propertyContainer.EndpointConfigurationProperty.Value = value; }
        }

        /// <summary>
        /// Gets or sets the Public IPAddress configuration for Compute Nodes in the Batch Pool.
        /// </summary>
        /// <remarks>
        /// Public IP configuration property is only supported on Pools created with a <see cref="CloudPool.VirtualMachineConfiguration"/>.
        /// </remarks>
        public PublicIPAddressConfiguration PublicIPAddressConfiguration
        {
            get { return this.propertyContainer.PublicIPAddressConfigurationProperty.Value; }
            set { this.propertyContainer.PublicIPAddressConfigurationProperty.Value = value; }
        }

        /// <summary>
        /// Gets or sets the ARM resource identifier of the virtual network subnet which the compute nodes of the pool will 
        /// join.
        /// </summary>
        /// <remarks>
        /// The virtual network must be in the same region and subscription as the Azure Batch Account. The specified subnet 
        /// should have enough free IP addresses to accommodate the number of Compute Nodes which will run Tasks from the 
        /// Job. This can be up to the number of Compute Nodes in the Pool. The 'MicrosoftAzureBatch' service principal must 
        /// have the 'Classic Virtual Machine Contributor' Role-Based Access Control (RBAC) role for the specified VNet so 
        /// that Azure Batch service can schedule Tasks on the Nodes. This can be verified by checking if the specified VNet 
        /// has any associated Network Security Groups (NSG). If communication to the Nodes in the specified subnet is denied 
        /// by an NSG, then the Batch service will set the state of the Compute Nodes to unusable. This is of the form /subscriptions/{subscription}/resourceGroups/{group}/providers/{provider}/virtualNetworks/{network}/subnets/{subnet}. 
        /// If the specified VNet has any associated Network Security Groups (NSG), then a few reserved system ports must 
        /// be enabled for inbound communication from the Azure Batch service. For Pools created with a Virtual Machine configuration, 
        /// enable ports 29876 and 29877, as well as port 22 for Linux and port 3389 for Windows. Port 443 is also required 
        /// to be open for outbound connections for communications to Azure Storage. For more details see: https://docs.microsoft.com/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration
        /// </remarks>
        public string SubnetId
        {
            get { return this.propertyContainer.SubnetIdProperty.Value; }
            set { this.propertyContainer.SubnetIdProperty.Value = value; }
        }

        #endregion // NetworkConfiguration

        #region IPropertyMetadata

        bool IModifiable.HasBeenModified
        {
            get { return this.propertyContainer.HasBeenModified; }
        }

        bool IReadOnly.IsReadOnly
        {
            get { return this.propertyContainer.IsReadOnly; }
            set { this.propertyContainer.IsReadOnly = value; }
        }

        #endregion //IPropertyMetadata

        #region Internal/private methods
        /// <summary>
        /// Return a protocol object of the requested type.
        /// </summary>
        /// <returns>The protocol object of the requested type.</returns>
        Models.NetworkConfiguration ITransportObjectProvider<Models.NetworkConfiguration>.GetTransportObject()
        {
            Models.NetworkConfiguration result = new Models.NetworkConfiguration()
            {
                DynamicVNetAssignmentScope = UtilitiesInternal.MapNullableEnum<Common.DynamicVNetAssignmentScope, Models.DynamicVNetAssignmentScope>(this.DynamicVNetAssignmentScope),
                EnableAcceleratedNetworking = this.EnableAcceleratedNetworking,
                EndpointConfiguration = UtilitiesInternal.CreateObjectWithNullCheck(this.EndpointConfiguration, (o) => o.GetTransportObject()),
                PublicIPAddressConfiguration = UtilitiesInternal.CreateObjectWithNullCheck(this.PublicIPAddressConfiguration, (o) => o.GetTransportObject()),
                SubnetId = this.SubnetId,
            };

            return result;
        }


        #endregion // Internal/private methods
    }
}