// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

//
// This file was autogenerated by a tool.
// Do not modify it.
//

namespace Microsoft.Azure.Batch
{
    using Models = Microsoft.Azure.Batch.Protocol.Models;
    using System;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// The file system to mount on each node.
    /// </summary>
    public partial class MountConfiguration : ITransportObjectProvider<Models.MountConfiguration>, IPropertyMetadata
    {
        #region Constructors
        /// <summary>
        /// Initializes a new instance of the <see cref="MountConfiguration"/> class.
        /// </summary>
        /// <param name='azureBlobFileSystemConfiguration'>The Azure Storage Container to mount using blob FUSE on each node.</param>
        /// <param name='nfsMountConfiguration'>The NFS file system to mount on each node.</param>
        /// <param name='cifsMountConfiguration'>The CIFS/SMB file system to mount on each node.</param>
        /// <param name='azureFileShareConfiguration'>The Azure File Share to mount on each node.</param>
        internal MountConfiguration(
            AzureBlobFileSystemConfiguration azureBlobFileSystemConfiguration = default(AzureBlobFileSystemConfiguration),
            NfsMountConfiguration nfsMountConfiguration = default(NfsMountConfiguration),
            CifsMountConfiguration cifsMountConfiguration = default(CifsMountConfiguration),
            AzureFileShareConfiguration azureFileShareConfiguration = default(AzureFileShareConfiguration))
        {
            this.AzureBlobFileSystemConfiguration = azureBlobFileSystemConfiguration;
            this.NfsMountConfiguration = nfsMountConfiguration;
            this.CifsMountConfiguration = cifsMountConfiguration;
            this.AzureFileShareConfiguration = azureFileShareConfiguration;
        }

        internal MountConfiguration(Models.MountConfiguration protocolObject)
        {
            this.AzureBlobFileSystemConfiguration = UtilitiesInternal.CreateObjectWithNullCheck(protocolObject.AzureBlobFileSystemConfiguration, o => new AzureBlobFileSystemConfiguration(o).Freeze());
            this.AzureFileShareConfiguration = UtilitiesInternal.CreateObjectWithNullCheck(protocolObject.AzureFileShareConfiguration, o => new AzureFileShareConfiguration(o).Freeze());
            this.CifsMountConfiguration = UtilitiesInternal.CreateObjectWithNullCheck(protocolObject.CifsMountConfiguration, o => new CifsMountConfiguration(o).Freeze());
            this.NfsMountConfiguration = UtilitiesInternal.CreateObjectWithNullCheck(protocolObject.NfsMountConfiguration, o => new NfsMountConfiguration(o).Freeze());
        }

        #endregion Constructors

        #region MountConfiguration

        /// <summary>
        /// Gets the Azure Storage Container to mount using blob FUSE on each node.
        /// </summary>
        public AzureBlobFileSystemConfiguration AzureBlobFileSystemConfiguration { get; }

        /// <summary>
        /// Gets the Azure File Share to mount on each node.
        /// </summary>
        public AzureFileShareConfiguration AzureFileShareConfiguration { get; }

        /// <summary>
        /// Gets the CIFS/SMB file system to mount on each node.
        /// </summary>
        public CifsMountConfiguration CifsMountConfiguration { get; }

        /// <summary>
        /// Gets the NFS file system to mount on each node.
        /// </summary>
        public NfsMountConfiguration NfsMountConfiguration { get; }

        #endregion // MountConfiguration

        #region IPropertyMetadata

        bool IModifiable.HasBeenModified
        {
            //This class is compile time readonly so it cannot have been modified
            get { return false; }
        }

        bool IReadOnly.IsReadOnly
        {
            get { return true; }
            set
            {
                // This class is compile time readonly already
            }
        }

        #endregion // IPropertyMetadata

        #region Internal/private methods

        /// <summary>
        /// Return a protocol object of the requested type.
        /// </summary>
        /// <returns>The protocol object of the requested type.</returns>
        Models.MountConfiguration ITransportObjectProvider<Models.MountConfiguration>.GetTransportObject()
        {
            Models.MountConfiguration result = new Models.MountConfiguration()
            {
                AzureBlobFileSystemConfiguration = UtilitiesInternal.CreateObjectWithNullCheck(this.AzureBlobFileSystemConfiguration, (o) => o.GetTransportObject()),
                AzureFileShareConfiguration = UtilitiesInternal.CreateObjectWithNullCheck(this.AzureFileShareConfiguration, (o) => o.GetTransportObject()),
                CifsMountConfiguration = UtilitiesInternal.CreateObjectWithNullCheck(this.CifsMountConfiguration, (o) => o.GetTransportObject()),
                NfsMountConfiguration = UtilitiesInternal.CreateObjectWithNullCheck(this.NfsMountConfiguration, (o) => o.GetTransportObject()),
            };

            return result;
        }

        /// <summary>
        /// Converts a collection of protocol layer objects to object layer collection objects.
        /// </summary>
        internal static IList<MountConfiguration> ConvertFromProtocolCollection(IEnumerable<Models.MountConfiguration> protoCollection)
        {
            ConcurrentChangeTrackedModifiableList<MountConfiguration> converted = UtilitiesInternal.CollectionToThreadSafeCollectionIModifiable(
                items: protoCollection,
                objectCreationFunc: o => new MountConfiguration(o));

            return converted;
        }

        /// <summary>
        /// Converts a collection of protocol layer objects to object layer collection objects, in a frozen state.
        /// </summary>
        internal static IList<MountConfiguration> ConvertFromProtocolCollectionAndFreeze(IEnumerable<Models.MountConfiguration> protoCollection)
        {
            ConcurrentChangeTrackedModifiableList<MountConfiguration> converted = UtilitiesInternal.CollectionToThreadSafeCollectionIModifiable(
                items: protoCollection,
                objectCreationFunc: o => new MountConfiguration(o).Freeze());

            converted = UtilitiesInternal.CreateObjectWithNullCheck(converted, o => o.Freeze());

            return converted;
        }

        /// <summary>
        /// Converts a collection of protocol layer objects to object layer collection objects, with each object marked readonly
        /// and returned as a readonly collection.
        /// </summary>
        internal static IReadOnlyList<MountConfiguration> ConvertFromProtocolCollectionReadOnly(IEnumerable<Models.MountConfiguration> protoCollection)
        {
            IReadOnlyList<MountConfiguration> converted =
                UtilitiesInternal.CreateObjectWithNullCheck(
                    UtilitiesInternal.CollectionToNonThreadSafeCollection(
                        items: protoCollection,
                        objectCreationFunc: o => new MountConfiguration(o).Freeze()), o => o.AsReadOnly());

            return converted;
        }

        #endregion // Internal/private methods
    }
}