// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

//
// This file was autogenerated by a tool.
// Do not modify it.
//

namespace Microsoft.Azure.Batch
{
    using Models = Microsoft.Azure.Batch.Protocol.Models;
    using System;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// The managed disk object.
    /// </summary>
    public partial class ManagedDisk : ITransportObjectProvider<Models.ManagedDisk>, IPropertyMetadata
    {
        private class PropertyContainer : PropertyCollection
        {
            public readonly PropertyAccessor<VMDiskSecurityProfile> SecurityProfileProperty;
            public readonly PropertyAccessor<Common.StorageAccountType?> StorageAccountTypeProperty;

            public PropertyContainer() : base(BindingState.Unbound)
            {
                this.SecurityProfileProperty = this.CreatePropertyAccessor<VMDiskSecurityProfile>(nameof(SecurityProfile), BindingAccess.Read | BindingAccess.Write);
                this.StorageAccountTypeProperty = this.CreatePropertyAccessor<Common.StorageAccountType?>(nameof(StorageAccountType), BindingAccess.Read | BindingAccess.Write);
            }

            public PropertyContainer(Models.ManagedDisk protocolObject) : base(BindingState.Bound)
            {
                this.SecurityProfileProperty = this.CreatePropertyAccessor(
                    UtilitiesInternal.CreateObjectWithNullCheck(protocolObject.SecurityProfile, o => new VMDiskSecurityProfile(o)),
                    nameof(SecurityProfile),
                    BindingAccess.Read | BindingAccess.Write);
                this.StorageAccountTypeProperty = this.CreatePropertyAccessor(
                    UtilitiesInternal.MapNullableEnum<Models.StorageAccountType, Common.StorageAccountType>(protocolObject.StorageAccountType),
                    nameof(StorageAccountType),
                    BindingAccess.Read | BindingAccess.Write);
            }
        }

        private readonly PropertyContainer propertyContainer;

        #region Constructors

        /// <summary>
        /// Initializes a new instance of the <see cref="ManagedDisk"/> class.
        /// </summary>
        /// <param name='storageAccountType'>The Azure Storage account name.</param>
        /// <param name='securityProfile'>Gets or sets specifies the security profile settings for the managed disk.</param>
        public ManagedDisk(
            Common.StorageAccountType? storageAccountType = default(Common.StorageAccountType?),
            VMDiskSecurityProfile securityProfile = default(VMDiskSecurityProfile))
        {
            this.propertyContainer = new PropertyContainer();
            this.StorageAccountType = storageAccountType;
            this.SecurityProfile = securityProfile;
        }

        /// <summary>
        /// Default constructor to support mocking the <see cref="ManagedDisk"/> class.
        /// </summary>
        protected ManagedDisk()
        {
            this.propertyContainer = new PropertyContainer();
        }

        internal ManagedDisk(Models.ManagedDisk protocolObject)
        {
            this.propertyContainer = new PropertyContainer(protocolObject);
        }

        #endregion Constructors

        #region ManagedDisk

        /// <summary>
        /// Gets or sets gets or sets specifies the security profile settings for the managed disk.
        /// </summary>
        public VMDiskSecurityProfile SecurityProfile
        {
            get { return this.propertyContainer.SecurityProfileProperty.Value; }
            set { this.propertyContainer.SecurityProfileProperty.Value = value; }
        }

        /// <summary>
        /// Gets or sets the Azure Storage account name.
        /// </summary>
        public Common.StorageAccountType? StorageAccountType
        {
            get { return this.propertyContainer.StorageAccountTypeProperty.Value; }
            set { this.propertyContainer.StorageAccountTypeProperty.Value = value; }
        }

        #endregion // ManagedDisk

        #region IPropertyMetadata

        bool IModifiable.HasBeenModified
        {
            get { return this.propertyContainer.HasBeenModified; }
        }

        bool IReadOnly.IsReadOnly
        {
            get { return this.propertyContainer.IsReadOnly; }
            set { this.propertyContainer.IsReadOnly = value; }
        }

        #endregion //IPropertyMetadata

        #region Internal/private methods
        /// <summary>
        /// Return a protocol object of the requested type.
        /// </summary>
        /// <returns>The protocol object of the requested type.</returns>
        Models.ManagedDisk ITransportObjectProvider<Models.ManagedDisk>.GetTransportObject()
        {
            Models.ManagedDisk result = new Models.ManagedDisk()
            {
                SecurityProfile = UtilitiesInternal.CreateObjectWithNullCheck(this.SecurityProfile, (o) => o.GetTransportObject()),
                StorageAccountType = UtilitiesInternal.MapNullableEnum<Common.StorageAccountType, Models.StorageAccountType>(this.StorageAccountType),
            };

            return result;
        }


        #endregion // Internal/private methods
    }
}