// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

//
// This file was autogenerated by a tool.
// Do not modify it.
//

namespace Microsoft.Azure.Batch
{
    using Models = Microsoft.Azure.Batch.Protocol.Models;
    using System;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// The <see cref="CloudJobSchedule.JobSpecification"/> of a <see cref="CloudJobSchedule"/>.
    /// </summary>
    public partial class JobSpecification : ITransportObjectProvider<Models.JobSpecification>, IPropertyMetadata
    {
        private class PropertyContainer : PropertyCollection
        {
            public readonly PropertyAccessor<bool?> AllowTaskPreemptionProperty;
            public readonly PropertyAccessor<IList<EnvironmentSetting>> CommonEnvironmentSettingsProperty;
            public readonly PropertyAccessor<JobConstraints> ConstraintsProperty;
            public readonly PropertyAccessor<string> DisplayNameProperty;
            public readonly PropertyAccessor<JobManagerTask> JobManagerTaskProperty;
            public readonly PropertyAccessor<JobPreparationTask> JobPreparationTaskProperty;
            public readonly PropertyAccessor<JobReleaseTask> JobReleaseTaskProperty;
            public readonly PropertyAccessor<int?> MaxParallelTasksProperty;
            public readonly PropertyAccessor<IList<MetadataItem>> MetadataProperty;
            public readonly PropertyAccessor<JobNetworkConfiguration> NetworkConfigurationProperty;
            public readonly PropertyAccessor<Common.OnAllTasksComplete?> OnAllTasksCompleteProperty;
            public readonly PropertyAccessor<Common.OnTaskFailure?> OnTaskFailureProperty;
            public readonly PropertyAccessor<PoolInformation> PoolInformationProperty;
            public readonly PropertyAccessor<int?> PriorityProperty;
            public readonly PropertyAccessor<bool?> UsesTaskDependenciesProperty;

            public PropertyContainer() : base(BindingState.Unbound)
            {
                this.AllowTaskPreemptionProperty = this.CreatePropertyAccessor<bool?>(nameof(AllowTaskPreemption), BindingAccess.Read | BindingAccess.Write);
                this.CommonEnvironmentSettingsProperty = this.CreatePropertyAccessor<IList<EnvironmentSetting>>(nameof(CommonEnvironmentSettings), BindingAccess.Read | BindingAccess.Write);
                this.ConstraintsProperty = this.CreatePropertyAccessor<JobConstraints>(nameof(Constraints), BindingAccess.Read | BindingAccess.Write);
                this.DisplayNameProperty = this.CreatePropertyAccessor<string>(nameof(DisplayName), BindingAccess.Read | BindingAccess.Write);
                this.JobManagerTaskProperty = this.CreatePropertyAccessor<JobManagerTask>(nameof(JobManagerTask), BindingAccess.Read | BindingAccess.Write);
                this.JobPreparationTaskProperty = this.CreatePropertyAccessor<JobPreparationTask>(nameof(JobPreparationTask), BindingAccess.Read | BindingAccess.Write);
                this.JobReleaseTaskProperty = this.CreatePropertyAccessor<JobReleaseTask>(nameof(JobReleaseTask), BindingAccess.Read | BindingAccess.Write);
                this.MaxParallelTasksProperty = this.CreatePropertyAccessor<int?>(nameof(MaxParallelTasks), BindingAccess.Read | BindingAccess.Write);
                this.MetadataProperty = this.CreatePropertyAccessor<IList<MetadataItem>>(nameof(Metadata), BindingAccess.Read | BindingAccess.Write);
                this.NetworkConfigurationProperty = this.CreatePropertyAccessor<JobNetworkConfiguration>(nameof(NetworkConfiguration), BindingAccess.Read | BindingAccess.Write);
                this.OnAllTasksCompleteProperty = this.CreatePropertyAccessor<Common.OnAllTasksComplete?>(nameof(OnAllTasksComplete), BindingAccess.Read | BindingAccess.Write);
                this.OnTaskFailureProperty = this.CreatePropertyAccessor<Common.OnTaskFailure?>(nameof(OnTaskFailure), BindingAccess.Read | BindingAccess.Write);
                this.PoolInformationProperty = this.CreatePropertyAccessor<PoolInformation>(nameof(PoolInformation), BindingAccess.Read | BindingAccess.Write);
                this.PriorityProperty = this.CreatePropertyAccessor<int?>(nameof(Priority), BindingAccess.Read | BindingAccess.Write);
                this.UsesTaskDependenciesProperty = this.CreatePropertyAccessor<bool?>(nameof(UsesTaskDependencies), BindingAccess.Read | BindingAccess.Write);
            }

            public PropertyContainer(Models.JobSpecification protocolObject) : base(BindingState.Bound)
            {
                this.AllowTaskPreemptionProperty = this.CreatePropertyAccessor(
                    protocolObject.AllowTaskPreemption,
                    nameof(AllowTaskPreemption),
                    BindingAccess.Read | BindingAccess.Write);
                this.CommonEnvironmentSettingsProperty = this.CreatePropertyAccessor(
                    EnvironmentSetting.ConvertFromProtocolCollection(protocolObject.CommonEnvironmentSettings),
                    nameof(CommonEnvironmentSettings),
                    BindingAccess.Read | BindingAccess.Write);
                this.ConstraintsProperty = this.CreatePropertyAccessor(
                    UtilitiesInternal.CreateObjectWithNullCheck(protocolObject.Constraints, o => new JobConstraints(o)),
                    nameof(Constraints),
                    BindingAccess.Read | BindingAccess.Write);
                this.DisplayNameProperty = this.CreatePropertyAccessor(
                    protocolObject.DisplayName,
                    nameof(DisplayName),
                    BindingAccess.Read | BindingAccess.Write);
                this.JobManagerTaskProperty = this.CreatePropertyAccessor(
                    UtilitiesInternal.CreateObjectWithNullCheck(protocolObject.JobManagerTask, o => new JobManagerTask(o)),
                    nameof(JobManagerTask),
                    BindingAccess.Read | BindingAccess.Write);
                this.JobPreparationTaskProperty = this.CreatePropertyAccessor(
                    UtilitiesInternal.CreateObjectWithNullCheck(protocolObject.JobPreparationTask, o => new JobPreparationTask(o)),
                    nameof(JobPreparationTask),
                    BindingAccess.Read | BindingAccess.Write);
                this.JobReleaseTaskProperty = this.CreatePropertyAccessor(
                    UtilitiesInternal.CreateObjectWithNullCheck(protocolObject.JobReleaseTask, o => new JobReleaseTask(o)),
                    nameof(JobReleaseTask),
                    BindingAccess.Read | BindingAccess.Write);
                this.MaxParallelTasksProperty = this.CreatePropertyAccessor(
                    protocolObject.MaxParallelTasks,
                    nameof(MaxParallelTasks),
                    BindingAccess.Read | BindingAccess.Write);
                this.MetadataProperty = this.CreatePropertyAccessor(
                    MetadataItem.ConvertFromProtocolCollection(protocolObject.Metadata),
                    nameof(Metadata),
                    BindingAccess.Read | BindingAccess.Write);
                this.NetworkConfigurationProperty = this.CreatePropertyAccessor(
                    UtilitiesInternal.CreateObjectWithNullCheck(protocolObject.NetworkConfiguration, o => new JobNetworkConfiguration(o).Freeze()),
                    nameof(NetworkConfiguration),
                    BindingAccess.Read);
                this.OnAllTasksCompleteProperty = this.CreatePropertyAccessor(
                    UtilitiesInternal.MapNullableEnum<Models.OnAllTasksComplete, Common.OnAllTasksComplete>(protocolObject.OnAllTasksComplete),
                    nameof(OnAllTasksComplete),
                    BindingAccess.Read | BindingAccess.Write);
                this.OnTaskFailureProperty = this.CreatePropertyAccessor(
                    UtilitiesInternal.MapNullableEnum<Models.OnTaskFailure, Common.OnTaskFailure>(protocolObject.OnTaskFailure),
                    nameof(OnTaskFailure),
                    BindingAccess.Read | BindingAccess.Write);
                this.PoolInformationProperty = this.CreatePropertyAccessor(
                    UtilitiesInternal.CreateObjectWithNullCheck(protocolObject.PoolInfo, o => new PoolInformation(o)),
                    nameof(PoolInformation),
                    BindingAccess.Read | BindingAccess.Write);
                this.PriorityProperty = this.CreatePropertyAccessor(
                    protocolObject.Priority,
                    nameof(Priority),
                    BindingAccess.Read | BindingAccess.Write);
                this.UsesTaskDependenciesProperty = this.CreatePropertyAccessor(
                    protocolObject.UsesTaskDependencies,
                    nameof(UsesTaskDependencies),
                    BindingAccess.Read | BindingAccess.Write);
            }
        }

        private readonly PropertyContainer propertyContainer;

        #region Constructors

        /// <summary>
        /// Initializes a new instance of the <see cref="JobSpecification"/> class.
        /// </summary>
        /// <param name='poolInformation'>The pool on which the Batch service runs the tasks of jobs created via this <see cref="JobSpecification"/>.</param>
        public JobSpecification(
            PoolInformation poolInformation)
        {
            this.propertyContainer = new PropertyContainer();
            this.PoolInformation = poolInformation;
        }

        internal JobSpecification(Models.JobSpecification protocolObject)
        {
            this.propertyContainer = new PropertyContainer(protocolObject);
        }

        #endregion Constructors

        #region JobSpecification

        /// <summary>
        /// Gets or sets whether Tasks in this job can be preempted by other high priority jobs.
        /// </summary>
        /// <remarks>
        /// If the value is set to True, other high priority jobs submitted to the system will take precedence and will be 
        /// able requeue tasks from this job. You can update a job's allowTaskPreemption after it has been created using 
        /// the update job API.
        /// </remarks>
        public bool? AllowTaskPreemption
        {
            get { return this.propertyContainer.AllowTaskPreemptionProperty.Value; }
            set { this.propertyContainer.AllowTaskPreemptionProperty.Value = value; }
        }

        /// <summary>
        /// Gets or sets a list of common environment variable settings.
        /// </summary>
        /// <remarks>
        /// These environment variables are set for all tasks in jobs created under this <see cref="CloudJobSchedule"/> (including 
        /// the Job Manager, Job Preparation and Job Release tasks).
        /// </remarks>
        public IList<EnvironmentSetting> CommonEnvironmentSettings
        {
            get { return this.propertyContainer.CommonEnvironmentSettingsProperty.Value; }
            set
            {
                this.propertyContainer.CommonEnvironmentSettingsProperty.Value = ConcurrentChangeTrackedModifiableList<EnvironmentSetting>.TransformEnumerableToConcurrentModifiableList(value);
            }
        }

        /// <summary>
        /// Gets or sets the execution constraints for jobs created via this <see cref="JobSpecification"/>.
        /// </summary>
        public JobConstraints Constraints
        {
            get { return this.propertyContainer.ConstraintsProperty.Value; }
            set { this.propertyContainer.ConstraintsProperty.Value = value; }
        }

        /// <summary>
        /// Gets or sets a display name for all jobs created via this <see cref="JobSpecification"/>.
        /// </summary>
        public string DisplayName
        {
            get { return this.propertyContainer.DisplayNameProperty.Value; }
            set { this.propertyContainer.DisplayNameProperty.Value = value; }
        }

        /// <summary>
        /// Gets or sets details of a Job Manager task to be launched when a job is created via this <see cref="JobSpecification"/>.
        /// </summary>
        public JobManagerTask JobManagerTask
        {
            get { return this.propertyContainer.JobManagerTaskProperty.Value; }
            set { this.propertyContainer.JobManagerTaskProperty.Value = value; }
        }

        /// <summary>
        /// Gets or sets the Job Preparation task for jobs created via this <see cref="JobSpecification"/>.
        /// </summary>
        /// <remarks>
        /// The Batch service will run the Job Preparation task on a compute node before starting any tasks of that job on 
        /// that compute node.
        /// </remarks>
        public JobPreparationTask JobPreparationTask
        {
            get { return this.propertyContainer.JobPreparationTaskProperty.Value; }
            set { this.propertyContainer.JobPreparationTaskProperty.Value = value; }
        }

        /// <summary>
        /// Gets or sets the Job Release task for jobs created via this <see cref="JobSpecification"/>. 
        /// </summary>
        /// <remarks>
        /// The Batch service runs the Job Release task when the job ends, on each compute node where any task of the job 
        /// has run.
        /// </remarks>
        public JobReleaseTask JobReleaseTask
        {
            get { return this.propertyContainer.JobReleaseTaskProperty.Value; }
            set { this.propertyContainer.JobReleaseTaskProperty.Value = value; }
        }

        /// <summary>
        /// Gets or sets the maximum number of tasks that can be executed in parallel for the job.
        /// </summary>
        /// <remarks>
        /// The value of maxParallelTasks must be -1 or greater than 0 if specified. If not specified, the default value 
        /// is -1, which means there's no limit to the number of tasks that can be run at once. You can update a job's maxParallelTasks 
        /// after it has been created using the update job API.
        /// </remarks>
        public int? MaxParallelTasks
        {
            get { return this.propertyContainer.MaxParallelTasksProperty.Value; }
            set { this.propertyContainer.MaxParallelTasksProperty.Value = value; }
        }

        /// <summary>
        /// Gets or sets a list of name-value pairs associated with jobs created via this <see cref="JobSpecification"/> 
        /// as metadata.
        /// </summary>
        public IList<MetadataItem> Metadata
        {
            get { return this.propertyContainer.MetadataProperty.Value; }
            set
            {
                this.propertyContainer.MetadataProperty.Value = ConcurrentChangeTrackedModifiableList<MetadataItem>.TransformEnumerableToConcurrentModifiableList(value);
            }
        }

        /// <summary>
        /// Gets or sets the network configuration for the job.
        /// </summary>
        public JobNetworkConfiguration NetworkConfiguration
        {
            get { return this.propertyContainer.NetworkConfigurationProperty.Value; }
            set { this.propertyContainer.NetworkConfigurationProperty.Value = value; }
        }

        /// <summary>
        /// Gets or sets the action the Batch service should take when all tasks in the job are in the <see cref="Common.JobState.Completed"/> 
        /// state.
        /// </summary>
        public Common.OnAllTasksComplete? OnAllTasksComplete
        {
            get { return this.propertyContainer.OnAllTasksCompleteProperty.Value; }
            set { this.propertyContainer.OnAllTasksCompleteProperty.Value = value; }
        }

        /// <summary>
        /// Gets or sets the action the Batch service should take when any task in the job fails.
        /// </summary>
        /// <remarks>
        /// A task is considered to have failed if it completes with a non-zero exit code and has exhausted its retry count, 
        /// or if it had a scheduling error.
        /// </remarks>
        public Common.OnTaskFailure? OnTaskFailure
        {
            get { return this.propertyContainer.OnTaskFailureProperty.Value; }
            set { this.propertyContainer.OnTaskFailureProperty.Value = value; }
        }

        /// <summary>
        /// Gets or sets the pool on which the Batch service runs the tasks of jobs created via this <see cref="JobSpecification"/>.
        /// </summary>
        public PoolInformation PoolInformation
        {
            get { return this.propertyContainer.PoolInformationProperty.Value; }
            set { this.propertyContainer.PoolInformationProperty.Value = value; }
        }

        /// <summary>
        /// Gets or sets the priority of jobs created via this <see cref="JobSpecification"/>.
        /// </summary>
        /// <remarks>
        ///  Priority values can range from -1000 to 1000, with -1000 being the lowest priority and 1000 being the highest 
        /// priority.
        /// </remarks>
        public int? Priority
        {
            get { return this.propertyContainer.PriorityProperty.Value; }
            set { this.propertyContainer.PriorityProperty.Value = value; }
        }

        /// <summary>
        /// Gets or sets whether tasks in jobs created under this <see cref="CloudJobSchedule"/> can define dependencies 
        /// on each other.
        /// </summary>
        /// <remarks>
        /// The default value is false.
        /// </remarks>
        public bool? UsesTaskDependencies
        {
            get { return this.propertyContainer.UsesTaskDependenciesProperty.Value; }
            set { this.propertyContainer.UsesTaskDependenciesProperty.Value = value; }
        }

        #endregion // JobSpecification

        #region IPropertyMetadata

        bool IModifiable.HasBeenModified
        {
            get { return this.propertyContainer.HasBeenModified; }
        }

        bool IReadOnly.IsReadOnly
        {
            get { return this.propertyContainer.IsReadOnly; }
            set { this.propertyContainer.IsReadOnly = value; }
        }

        #endregion //IPropertyMetadata

        #region Internal/private methods
        /// <summary>
        /// Return a protocol object of the requested type.
        /// </summary>
        /// <returns>The protocol object of the requested type.</returns>
        Models.JobSpecification ITransportObjectProvider<Models.JobSpecification>.GetTransportObject()
        {
            Models.JobSpecification result = new Models.JobSpecification()
            {
                AllowTaskPreemption = this.AllowTaskPreemption,
                CommonEnvironmentSettings = UtilitiesInternal.ConvertToProtocolCollection(this.CommonEnvironmentSettings),
                Constraints = UtilitiesInternal.CreateObjectWithNullCheck(this.Constraints, (o) => o.GetTransportObject()),
                DisplayName = this.DisplayName,
                JobManagerTask = UtilitiesInternal.CreateObjectWithNullCheck(this.JobManagerTask, (o) => o.GetTransportObject()),
                JobPreparationTask = UtilitiesInternal.CreateObjectWithNullCheck(this.JobPreparationTask, (o) => o.GetTransportObject()),
                JobReleaseTask = UtilitiesInternal.CreateObjectWithNullCheck(this.JobReleaseTask, (o) => o.GetTransportObject()),
                MaxParallelTasks = this.MaxParallelTasks,
                Metadata = UtilitiesInternal.ConvertToProtocolCollection(this.Metadata),
                NetworkConfiguration = UtilitiesInternal.CreateObjectWithNullCheck(this.NetworkConfiguration, (o) => o.GetTransportObject()),
                OnAllTasksComplete = UtilitiesInternal.MapNullableEnum<Common.OnAllTasksComplete, Models.OnAllTasksComplete>(this.OnAllTasksComplete),
                OnTaskFailure = UtilitiesInternal.MapNullableEnum<Common.OnTaskFailure, Models.OnTaskFailure>(this.OnTaskFailure),
                PoolInfo = UtilitiesInternal.CreateObjectWithNullCheck(this.PoolInformation, (o) => o.GetTransportObject()),
                Priority = this.Priority,
                UsesTaskDependencies = this.UsesTaskDependencies,
            };

            return result;
        }


        #endregion // Internal/private methods
    }
}