// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

//
// This file was autogenerated by a tool.
// Do not modify it.
//

namespace Microsoft.Azure.Batch
{
    using Models = Microsoft.Azure.Batch.Protocol.Models;
    using System;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// The Job Release Task runs when the Job ends, because of one of the following: The user calls the Terminate Job API, 
    /// or the Delete Job API while the Job is still active, the Job's maximum wall clock time constraint is reached, and 
    /// the Job is still active, or the Job's Job Manager Task completed, and the Job is configured to terminate when the 
    /// Job Manager completes. The Job Release Task runs on each Node where Tasks of the Job have run and the Job Preparation 
    /// Task ran and completed. If you reimage a Node after it has run the Job Preparation Task, and the Job ends without 
    /// any further Tasks of the Job running on that Node (and hence the Job Preparation Task does not re-run), then the 
    /// Job Release Task does not run on that Compute Node. If a Node reboots while the Job Release Task is still running, 
    /// the Job Release Task runs again when the Compute Node starts up. The Job is not marked as complete until all Job 
    /// Release Tasks have completed. The Job Release Task runs in the background. It does not occupy a scheduling slot; 
    /// that is, it does not count towards the taskSlotsPerNode limit specified on the Pool.
    /// </summary>
    public partial class JobReleaseTask : ITransportObjectProvider<Models.JobReleaseTask>, IPropertyMetadata
    {
        private class PropertyContainer : PropertyCollection
        {
            public readonly PropertyAccessor<string> CommandLineProperty;
            public readonly PropertyAccessor<TaskContainerSettings> ContainerSettingsProperty;
            public readonly PropertyAccessor<IList<EnvironmentSetting>> EnvironmentSettingsProperty;
            public readonly PropertyAccessor<string> IdProperty;
            public readonly PropertyAccessor<TimeSpan?> MaxWallClockTimeProperty;
            public readonly PropertyAccessor<IList<ResourceFile>> ResourceFilesProperty;
            public readonly PropertyAccessor<TimeSpan?> RetentionTimeProperty;
            public readonly PropertyAccessor<UserIdentity> UserIdentityProperty;

            public PropertyContainer() : base(BindingState.Unbound)
            {
                this.CommandLineProperty = this.CreatePropertyAccessor<string>(nameof(CommandLine), BindingAccess.Read | BindingAccess.Write);
                this.ContainerSettingsProperty = this.CreatePropertyAccessor<TaskContainerSettings>(nameof(ContainerSettings), BindingAccess.Read | BindingAccess.Write);
                this.EnvironmentSettingsProperty = this.CreatePropertyAccessor<IList<EnvironmentSetting>>(nameof(EnvironmentSettings), BindingAccess.Read | BindingAccess.Write);
                this.IdProperty = this.CreatePropertyAccessor<string>(nameof(Id), BindingAccess.Read | BindingAccess.Write);
                this.MaxWallClockTimeProperty = this.CreatePropertyAccessor<TimeSpan?>(nameof(MaxWallClockTime), BindingAccess.Read | BindingAccess.Write);
                this.ResourceFilesProperty = this.CreatePropertyAccessor<IList<ResourceFile>>(nameof(ResourceFiles), BindingAccess.Read | BindingAccess.Write);
                this.RetentionTimeProperty = this.CreatePropertyAccessor<TimeSpan?>(nameof(RetentionTime), BindingAccess.Read | BindingAccess.Write);
                this.UserIdentityProperty = this.CreatePropertyAccessor<UserIdentity>(nameof(UserIdentity), BindingAccess.Read | BindingAccess.Write);
            }

            public PropertyContainer(Models.JobReleaseTask protocolObject) : base(BindingState.Bound)
            {
                this.CommandLineProperty = this.CreatePropertyAccessor(
                    protocolObject.CommandLine,
                    nameof(CommandLine),
                    BindingAccess.Read | BindingAccess.Write);
                this.ContainerSettingsProperty = this.CreatePropertyAccessor(
                    UtilitiesInternal.CreateObjectWithNullCheck(protocolObject.ContainerSettings, o => new TaskContainerSettings(o).Freeze()),
                    nameof(ContainerSettings),
                    BindingAccess.Read);
                this.EnvironmentSettingsProperty = this.CreatePropertyAccessor(
                    EnvironmentSetting.ConvertFromProtocolCollection(protocolObject.EnvironmentSettings),
                    nameof(EnvironmentSettings),
                    BindingAccess.Read | BindingAccess.Write);
                this.IdProperty = this.CreatePropertyAccessor(
                    protocolObject.Id,
                    nameof(Id),
                    BindingAccess.Read | BindingAccess.Write);
                this.MaxWallClockTimeProperty = this.CreatePropertyAccessor(
                    protocolObject.MaxWallClockTime,
                    nameof(MaxWallClockTime),
                    BindingAccess.Read | BindingAccess.Write);
                this.ResourceFilesProperty = this.CreatePropertyAccessor(
                    ResourceFile.ConvertFromProtocolCollection(protocolObject.ResourceFiles),
                    nameof(ResourceFiles),
                    BindingAccess.Read | BindingAccess.Write);
                this.RetentionTimeProperty = this.CreatePropertyAccessor(
                    protocolObject.RetentionTime,
                    nameof(RetentionTime),
                    BindingAccess.Read | BindingAccess.Write);
                this.UserIdentityProperty = this.CreatePropertyAccessor(
                    UtilitiesInternal.CreateObjectWithNullCheck(protocolObject.UserIdentity, o => new UserIdentity(o)),
                    nameof(UserIdentity),
                    BindingAccess.Read | BindingAccess.Write);
            }
        }

        private readonly PropertyContainer propertyContainer;

        #region Constructors

        /// <summary>
        /// Initializes a new instance of the <see cref="JobReleaseTask"/> class.
        /// </summary>
        /// <param name='commandLine'>The command line of the task.</param>
        public JobReleaseTask(
            string commandLine)
        {
            this.propertyContainer = new PropertyContainer();
            this.CommandLine = commandLine;
        }

        internal JobReleaseTask(Models.JobReleaseTask protocolObject)
        {
            this.propertyContainer = new PropertyContainer(protocolObject);
        }

        #endregion Constructors

        #region JobReleaseTask

        /// <summary>
        /// Gets or sets the command line of the task.
        /// </summary>
        /// <remarks>
        /// The command line does not run under a shell, and therefore cannot take advantage of shell features such as environment 
        /// variable expansion. If you want to take advantage of such features, you should invoke the shell in the command 
        /// line, for example using "cmd /c MyCommand" in Windows or "/bin/sh -c MyCommand" in Linux. If the command line 
        /// refers to file paths, it should use a relative path (relative to the task working directory), or use the Batch 
        /// provided environment variables (https://docs.microsoft.com/en-us/azure/batch/batch-compute-node-environment-variables).
        /// </remarks>
        public string CommandLine
        {
            get { return this.propertyContainer.CommandLineProperty.Value; }
            set { this.propertyContainer.CommandLineProperty.Value = value; }
        }

        /// <summary>
        /// Gets or sets the settings for the container under which the task runs.
        /// </summary>
        /// <remarks>
        /// When this is specified, all directories recursively below the AZ_BATCH_NODE_ROOT_DIR (the root of Azure Batch 
        /// directories on the node) are mapped into the container, all task environment variables are mapped into the container, 
        /// and the task command line is executed in the container. Files produced in the container outside of AZ_BATCH_NODE_ROOT_DIR 
        /// might not be reflected to the host disk, meaning that Batch file APIs will not be able to access them.
        /// </remarks>
        public TaskContainerSettings ContainerSettings
        {
            get { return this.propertyContainer.ContainerSettingsProperty.Value; }
            set { this.propertyContainer.ContainerSettingsProperty.Value = value; }
        }

        /// <summary>
        /// Gets or sets the collection of EnvironmentSetting instances.
        /// </summary>
        public IList<EnvironmentSetting> EnvironmentSettings
        {
            get { return this.propertyContainer.EnvironmentSettingsProperty.Value; }
            set
            {
                this.propertyContainer.EnvironmentSettingsProperty.Value = ConcurrentChangeTrackedModifiableList<EnvironmentSetting>.TransformEnumerableToConcurrentModifiableList(value);
            }
        }

        /// <summary>
        /// Gets or sets the id of the task.
        /// </summary>
        public string Id
        {
            get { return this.propertyContainer.IdProperty.Value; }
            set { this.propertyContainer.IdProperty.Value = value; }
        }

        /// <summary>
        /// Gets or sets the maximum duration of time for which a task is allowed to run from the time it is created.
        /// </summary>
        public TimeSpan? MaxWallClockTime
        {
            get { return this.propertyContainer.MaxWallClockTimeProperty.Value; }
            set { this.propertyContainer.MaxWallClockTimeProperty.Value = value; }
        }

        /// <summary>
        /// Gets or sets a list of files that the Batch service will download to the compute node before running the command 
        /// line.
        /// </summary>
        /// <remarks>
        /// There is a maximum size for the list of resource files. When the max size is exceeded, the request will fail 
        /// and the response error code will be RequestEntityTooLarge. If this occurs, the collection of resource files must 
        /// be reduced in size. This can be achieved using .zip files, Application Packages, or Docker Containers.
        /// </remarks>
        public IList<ResourceFile> ResourceFiles
        {
            get { return this.propertyContainer.ResourceFilesProperty.Value; }
            set
            {
                this.propertyContainer.ResourceFilesProperty.Value = ConcurrentChangeTrackedModifiableList<ResourceFile>.TransformEnumerableToConcurrentModifiableList(value);
            }
        }

        /// <summary>
        /// Gets or sets the duration of time for which files in the task's working directory are retained, from the time 
        /// it completes execution. After this duration, the task's working directory is reclaimed.
        /// </summary>
        /// <remarks>
        /// The default is 7 days, i.e. the task directory will be retained for 7 days unless the compute node is removed 
        /// or the job is deleted.
        /// </remarks>
        public TimeSpan? RetentionTime
        {
            get { return this.propertyContainer.RetentionTimeProperty.Value; }
            set { this.propertyContainer.RetentionTimeProperty.Value = value; }
        }

        /// <summary>
        /// Gets or sets the user identity under which the task runs.
        /// </summary>
        /// <remarks>
        /// If omitted, the task runs as a non-administrative user unique to the task.
        /// </remarks>
        public UserIdentity UserIdentity
        {
            get { return this.propertyContainer.UserIdentityProperty.Value; }
            set { this.propertyContainer.UserIdentityProperty.Value = value; }
        }

        #endregion // JobReleaseTask

        #region IPropertyMetadata

        bool IModifiable.HasBeenModified
        {
            get { return this.propertyContainer.HasBeenModified; }
        }

        bool IReadOnly.IsReadOnly
        {
            get { return this.propertyContainer.IsReadOnly; }
            set { this.propertyContainer.IsReadOnly = value; }
        }

        #endregion //IPropertyMetadata

        #region Internal/private methods
        /// <summary>
        /// Return a protocol object of the requested type.
        /// </summary>
        /// <returns>The protocol object of the requested type.</returns>
        Models.JobReleaseTask ITransportObjectProvider<Models.JobReleaseTask>.GetTransportObject()
        {
            Models.JobReleaseTask result = new Models.JobReleaseTask()
            {
                CommandLine = this.CommandLine,
                ContainerSettings = UtilitiesInternal.CreateObjectWithNullCheck(this.ContainerSettings, (o) => o.GetTransportObject()),
                EnvironmentSettings = UtilitiesInternal.ConvertToProtocolCollection(this.EnvironmentSettings),
                Id = this.Id,
                MaxWallClockTime = this.MaxWallClockTime,
                ResourceFiles = UtilitiesInternal.ConvertToProtocolCollection(this.ResourceFiles),
                RetentionTime = this.RetentionTime,
                UserIdentity = UtilitiesInternal.CreateObjectWithNullCheck(this.UserIdentity, (o) => o.GetTransportObject()),
            };

            return result;
        }


        #endregion // Internal/private methods
    }
}