// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

//
// This file was autogenerated by a tool.
// Do not modify it.
//

namespace Microsoft.Azure.Batch
{
    using Models = Microsoft.Azure.Batch.Protocol.Models;
    using System;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// The network configuration for a job.
    /// </summary>
    public partial class JobNetworkConfiguration : ITransportObjectProvider<Models.JobNetworkConfiguration>, IPropertyMetadata
    {
        private class PropertyContainer : PropertyCollection
        {
            public readonly PropertyAccessor<bool?> SkipWithdrawFromVNetProperty;
            public readonly PropertyAccessor<string> SubnetIdProperty;

            public PropertyContainer() : base(BindingState.Unbound)
            {
                this.SkipWithdrawFromVNetProperty = this.CreatePropertyAccessor<bool?>(nameof(SkipWithdrawFromVNet), BindingAccess.Read | BindingAccess.Write);
                this.SubnetIdProperty = this.CreatePropertyAccessor<string>(nameof(SubnetId), BindingAccess.Read | BindingAccess.Write);
            }

            public PropertyContainer(Models.JobNetworkConfiguration protocolObject) : base(BindingState.Bound)
            {
                this.SkipWithdrawFromVNetProperty = this.CreatePropertyAccessor(
                    protocolObject.SkipWithdrawFromVNet,
                    nameof(SkipWithdrawFromVNet),
                    BindingAccess.Read);
                this.SubnetIdProperty = this.CreatePropertyAccessor(
                    protocolObject.SubnetId,
                    nameof(SubnetId),
                    BindingAccess.Read);
            }
        }

        private readonly PropertyContainer propertyContainer;

        #region Constructors

        /// <summary>
        /// Initializes a new instance of the <see cref="JobNetworkConfiguration"/> class.
        /// </summary>
        /// <param name='subnetId'>The ARM resource identifier of the virtual network subnet which nodes running tasks from the job will join for 
        /// the duration of the task.</param>
        /// <param name='skipWithdrawFromVNet'>Gets or sets whether to withdraw Compute Nodes from the virtual network to DNC when the job is terminated or 
        /// deleted.</param>
        public JobNetworkConfiguration(
            string subnetId,
            bool? skipWithdrawFromVNet = default(bool?))
        {
            this.propertyContainer = new PropertyContainer();
            this.SubnetId = subnetId;
            this.SkipWithdrawFromVNet = skipWithdrawFromVNet;
        }

        /// <summary>
        /// Default constructor to support mocking the <see cref="JobNetworkConfiguration"/> class.
        /// </summary>
        protected JobNetworkConfiguration()
        {
            this.propertyContainer = new PropertyContainer();
        }

        internal JobNetworkConfiguration(Models.JobNetworkConfiguration protocolObject)
        {
            this.propertyContainer = new PropertyContainer(protocolObject);
        }

        #endregion Constructors

        #region JobNetworkConfiguration

        /// <summary>
        /// Gets or sets gets or sets whether to withdraw Compute Nodes from the virtual network to DNC when the job is terminated 
        /// or deleted.
        /// </summary>
        /// <remarks>
        /// If true, nodes will remain joined to the virtual network to DNC. If false, nodes will automatically withdraw 
        /// when the job ends. Defaults to false.
        /// </remarks>
        public bool? SkipWithdrawFromVNet
        {
            get { return this.propertyContainer.SkipWithdrawFromVNetProperty.Value; }
            set { this.propertyContainer.SkipWithdrawFromVNetProperty.Value = value; }
        }

        /// <summary>
        /// Gets or sets the ARM resource identifier of the virtual network subnet which nodes running tasks from the job 
        /// will join for the duration of the task.
        /// </summary>
        /// <remarks>
        /// <para>The specified subnet should have enough free IP addresses to accommodate the number of nodes which will 
        /// run tasks from the job. This can be up to the number of nodes in the pool.</para><para>This will only work on 
        /// pools with the <see cref="CloudPool.VirtualMachineConfiguration" /> property.</para><para>This is of the form 
        /// /subscriptions/{subscription}/resourceGroups/{group}/providers/{provider}/virtualNetworks/{network}/subnets/{subnet}.</para><para>The 
        /// virtual network must be in the same region and subscription as the Azure Batch account. The 'MicrosoftAzureBatch' 
        /// service principal must have the 'Classic Virtual Machine Contributor' Role-Based Access Control (RBAC) role for 
        /// the specified VNet. The specified subnet must allow communication from the Azure Batch service to be able to 
        /// schedule tasks on the compute nodes. This can be verified by checking if the specified VNet has any associated 
        /// Network Security Groups (NSG). If communication to the compute nodes in the specified subnet is denied by an 
        /// NSG, then the Batch service will set the state of the compute nodes to unusable. Only ARM virtual networks ('Microsoft.Network/virtualNetworks') 
        /// are supported. If the specified VNet has any associated Network Security Groups (NSG), then a few reserved system 
        /// ports must be enabled for inbound communication - ports 29876 and 29877, as well as port 22 for Linux and port 
        /// 3389 for Windows. Also enable outbound connections to Azure Storage on port 443. For more details see: https://docs.microsoft.com/en-us/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration 
        /// </para>
        /// </remarks>
        public string SubnetId
        {
            get { return this.propertyContainer.SubnetIdProperty.Value; }
            set { this.propertyContainer.SubnetIdProperty.Value = value; }
        }

        #endregion // JobNetworkConfiguration

        #region IPropertyMetadata

        bool IModifiable.HasBeenModified
        {
            get { return this.propertyContainer.HasBeenModified; }
        }

        bool IReadOnly.IsReadOnly
        {
            get { return this.propertyContainer.IsReadOnly; }
            set { this.propertyContainer.IsReadOnly = value; }
        }

        #endregion //IPropertyMetadata

        #region Internal/private methods
        /// <summary>
        /// Return a protocol object of the requested type.
        /// </summary>
        /// <returns>The protocol object of the requested type.</returns>
        Models.JobNetworkConfiguration ITransportObjectProvider<Models.JobNetworkConfiguration>.GetTransportObject()
        {
            Models.JobNetworkConfiguration result = new Models.JobNetworkConfiguration()
            {
                SkipWithdrawFromVNet = this.SkipWithdrawFromVNet,
                SubnetId = this.SubnetId,
            };

            return result;
        }


        #endregion // Internal/private methods
    }
}