// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

//
// This file was autogenerated by a tool.
// Do not modify it.
//

namespace Microsoft.Azure.Batch
{
    using Models = Microsoft.Azure.Batch.Protocol.Models;
    using System;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// Information about the execution of an Azure Batch job.
    /// </summary>
    public partial class JobExecutionInformation : IPropertyMetadata
    {
        #region Constructors

        internal JobExecutionInformation(Models.JobExecutionInformation protocolObject)
        {
            this.EndTime = protocolObject.EndTime;
            this.PoolId = protocolObject.PoolId;
            this.SchedulingError = UtilitiesInternal.CreateObjectWithNullCheck(protocolObject.SchedulingError, o => new JobSchedulingError(o).Freeze());
            this.StartTime = protocolObject.StartTime;
            this.TerminateReason = protocolObject.TerminateReason;
        }

        #endregion Constructors

        #region JobExecutionInformation

        /// <summary>
        /// Gets the completion time of this job.
        /// </summary>
        public DateTime? EndTime { get; }

        /// <summary>
        /// Gets the pool Id of this job.
        /// </summary>
        public string PoolId { get; }

        /// <summary>
        /// Gets the error encountered by the Batch service in scheduling the job.
        /// </summary>
        public JobSchedulingError SchedulingError { get; }

        /// <summary>
        /// Gets the creation time of the job.
        /// </summary>
        public DateTime StartTime { get; }

        /// <summary>
        /// Gets the reason for job moving to completed state.
        /// </summary>
        public string TerminateReason { get; }

        #endregion // JobExecutionInformation

        #region IPropertyMetadata

        bool IModifiable.HasBeenModified
        {
            //This class is compile time readonly so it cannot have been modified
            get { return false; }
        }

        bool IReadOnly.IsReadOnly
        {
            get { return true; }
            set
            {
                // This class is compile time readonly already
            }
        }

        #endregion // IPropertyMetadata
    }
}