// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

//
// This file was autogenerated by a tool.
// Do not modify it.
//

namespace Microsoft.Azure.Batch
{
    using Models = Microsoft.Azure.Batch.Protocol.Models;
    using System;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// A inbound NAT pool that can be used to address specific ports on compute nodes in a Batch pool externally.
    /// </summary>
    public partial class InboundNatPool : ITransportObjectProvider<Models.InboundNATPool>, IPropertyMetadata
    {
        #region Constructors
        /// <summary>
        /// Initializes a new instance of the <see cref="InboundNatPool"/> class.
        /// </summary>
        /// <param name='name'>The name of the endpoint.</param>
        /// <param name='protocol'>The protocol of the endpoint.</param>
        /// <param name='backendPort'>The port number on the compute node.</param>
        /// <param name='frontendPortRangeStart'>The first port number in the range of external ports that will be used to provide inbound access to the backendPort 
        /// on individual compute nodes.</param>
        /// <param name='frontendPortRangeEnd'>The last port number in the range of external ports that will be used to provide inbound access to the backendPort 
        /// on individual compute nodes.</param>
        /// <param name='networkSecurityGroupRules'>A list of network security group rules that will be applied to the endpoint.</param>
        public InboundNatPool(
            string name,
            Common.InboundEndpointProtocol protocol,
            int backendPort,
            int frontendPortRangeStart,
            int frontendPortRangeEnd,
            IReadOnlyList<NetworkSecurityGroupRule> networkSecurityGroupRules = default(IReadOnlyList<NetworkSecurityGroupRule>))
        {
            this.Name = name;
            this.Protocol = protocol;
            this.BackendPort = backendPort;
            this.FrontendPortRangeStart = frontendPortRangeStart;
            this.FrontendPortRangeEnd = frontendPortRangeEnd;
            this.NetworkSecurityGroupRules = networkSecurityGroupRules;
        }

        internal InboundNatPool(Models.InboundNATPool protocolObject)
        {
            this.BackendPort = protocolObject.BackendPort;
            this.FrontendPortRangeEnd = protocolObject.FrontendPortRangeEnd;
            this.FrontendPortRangeStart = protocolObject.FrontendPortRangeStart;
            this.Name = protocolObject.Name;
            this.NetworkSecurityGroupRules = NetworkSecurityGroupRule.ConvertFromProtocolCollectionReadOnly(protocolObject.NetworkSecurityGroupRules);
            this.Protocol = UtilitiesInternal.MapEnum<Models.InboundEndpointProtocol, Common.InboundEndpointProtocol>(protocolObject.Protocol);
        }

        #endregion Constructors

        #region InboundNatPool

        /// <summary>
        /// Gets the port number on the compute node.
        /// </summary>
        /// <remarks>
        /// This must be unique within a Batch pool. Acceptable values are between 1 and 65535 except for 22, 3389, 29876 
        /// and 29877 as these are reserved.
        /// </remarks>
        public int BackendPort { get; }

        /// <summary>
        /// Gets the last port number in the range of external ports that will be used to provide inbound access to the backendPort 
        /// on individual compute nodes.
        /// </summary>
        /// <remarks>
        /// Acceptable values range between 1 and 65534 except ports from 50000 to 55000 which are reserved by the Batch 
        /// service. All ranges within a pool must be distinct and cannot overlap.
        /// </remarks>
        public int FrontendPortRangeEnd { get; }

        /// <summary>
        /// Gets the first port number in the range of external ports that will be used to provide inbound access to the 
        /// backendPort on individual compute nodes.
        /// </summary>
        /// <remarks>
        /// Acceptable values range between 1 and 65534 except ports from 50000 to 55000 which are reserved. All ranges within 
        /// a pool must be distinct and cannot overlap.
        /// </remarks>
        public int FrontendPortRangeStart { get; }

        /// <summary>
        /// Gets the name of the endpoint.
        /// </summary>
        /// <remarks>
        /// The name must be unique within a Batch pool, can contain letters, numbers, underscores, periods, and hyphens. 
        /// Names must start with a letter or number, must end with a letter, number, or underscore, and cannot exceed 77 
        /// characters.
        /// </remarks>
        public string Name { get; }

        /// <summary>
        /// Gets a list of network security group rules that will be applied to the endpoint.
        /// </summary>
        /// <remarks>
        /// The maximum number of rules that can be specified across all the endpoints on a pool is 25. If no network security 
        /// group rules are specified, a default rule will be created to allow inbound access to the specified backendPort.
        /// </remarks>
        public IReadOnlyList<NetworkSecurityGroupRule> NetworkSecurityGroupRules { get; }

        /// <summary>
        /// Gets the protocol of the endpoint.
        /// </summary>
        public Common.InboundEndpointProtocol Protocol { get; }

        #endregion // InboundNatPool

        #region IPropertyMetadata

        bool IModifiable.HasBeenModified
        {
            //This class is compile time readonly so it cannot have been modified
            get { return false; }
        }

        bool IReadOnly.IsReadOnly
        {
            get { return true; }
            set
            {
                // This class is compile time readonly already
            }
        }

        #endregion // IPropertyMetadata

        #region Internal/private methods

        /// <summary>
        /// Return a protocol object of the requested type.
        /// </summary>
        /// <returns>The protocol object of the requested type.</returns>
        Models.InboundNATPool ITransportObjectProvider<Models.InboundNATPool>.GetTransportObject()
        {
            Models.InboundNATPool result = new Models.InboundNATPool()
            {
                BackendPort = this.BackendPort,
                FrontendPortRangeEnd = this.FrontendPortRangeEnd,
                FrontendPortRangeStart = this.FrontendPortRangeStart,
                Name = this.Name,
                NetworkSecurityGroupRules = UtilitiesInternal.ConvertToProtocolCollection(this.NetworkSecurityGroupRules),
                Protocol = UtilitiesInternal.MapEnum<Common.InboundEndpointProtocol, Models.InboundEndpointProtocol>(this.Protocol),
            };

            return result;
        }

        /// <summary>
        /// Converts a collection of protocol layer objects to object layer collection objects.
        /// </summary>
        internal static IList<InboundNatPool> ConvertFromProtocolCollection(IEnumerable<Models.InboundNATPool> protoCollection)
        {
            ConcurrentChangeTrackedModifiableList<InboundNatPool> converted = UtilitiesInternal.CollectionToThreadSafeCollectionIModifiable(
                items: protoCollection,
                objectCreationFunc: o => new InboundNatPool(o));

            return converted;
        }

        /// <summary>
        /// Converts a collection of protocol layer objects to object layer collection objects, in a frozen state.
        /// </summary>
        internal static IList<InboundNatPool> ConvertFromProtocolCollectionAndFreeze(IEnumerable<Models.InboundNATPool> protoCollection)
        {
            ConcurrentChangeTrackedModifiableList<InboundNatPool> converted = UtilitiesInternal.CollectionToThreadSafeCollectionIModifiable(
                items: protoCollection,
                objectCreationFunc: o => new InboundNatPool(o).Freeze());

            converted = UtilitiesInternal.CreateObjectWithNullCheck(converted, o => o.Freeze());

            return converted;
        }

        /// <summary>
        /// Converts a collection of protocol layer objects to object layer collection objects, with each object marked readonly
        /// and returned as a readonly collection.
        /// </summary>
        internal static IReadOnlyList<InboundNatPool> ConvertFromProtocolCollectionReadOnly(IEnumerable<Models.InboundNATPool> protoCollection)
        {
            IReadOnlyList<InboundNatPool> converted =
                UtilitiesInternal.CreateObjectWithNullCheck(
                    UtilitiesInternal.CollectionToNonThreadSafeCollection(
                        items: protoCollection,
                        objectCreationFunc: o => new InboundNatPool(o).Freeze()), o => o.AsReadOnly());

            return converted;
        }

        #endregion // Internal/private methods
    }
}