// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

//
// This file was autogenerated by a tool.
// Do not modify it.
//

namespace Microsoft.Azure.Batch
{
    using Models = Microsoft.Azure.Batch.Protocol.Models;
    using System;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// An inbound endpoint on a compute node.
    /// </summary>
    public partial class InboundEndpoint : IPropertyMetadata
    {
        #region Constructors

        internal InboundEndpoint(Models.InboundEndpoint protocolObject)
        {
            this.BackendPort = protocolObject.BackendPort;
            this.FrontendPort = protocolObject.FrontendPort;
            this.Name = protocolObject.Name;
            this.Protocol = UtilitiesInternal.MapEnum<Models.InboundEndpointProtocol, Common.InboundEndpointProtocol>(protocolObject.Protocol);
            this.PublicFqdn = protocolObject.PublicFQDN;
            this.PublicIPAddress = protocolObject.PublicIPAddress;
        }

        #endregion Constructors

        #region InboundEndpoint

        /// <summary>
        /// Gets the backend port number of the endpoint.
        /// </summary>
        public int BackendPort { get; }

        /// <summary>
        /// Gets the public port number of the endpoint.
        /// </summary>
        public int FrontendPort { get; }

        /// <summary>
        /// Gets the name of the endpoint.
        /// </summary>
        public string Name { get; }

        /// <summary>
        /// Gets the protocol of the endpoint.
        /// </summary>
        public Common.InboundEndpointProtocol Protocol { get; }

        /// <summary>
        /// Gets the public fully qualified domain name for the compute node.
        /// </summary>
        public string PublicFqdn { get; }

        /// <summary>
        /// Gets the public IP address of the compute node.
        /// </summary>
        public string PublicIPAddress { get; }

        #endregion // InboundEndpoint

        #region IPropertyMetadata

        bool IModifiable.HasBeenModified
        {
            //This class is compile time readonly so it cannot have been modified
            get { return false; }
        }

        bool IReadOnly.IsReadOnly
        {
            get { return true; }
            set
            {
                // This class is compile time readonly already
            }
        }

        #endregion // IPropertyMetadata

        #region Internal/private methods


        /// <summary>
        /// Converts a collection of protocol layer objects to object layer collection objects.
        /// </summary>
        internal static IList<InboundEndpoint> ConvertFromProtocolCollection(IEnumerable<Models.InboundEndpoint> protoCollection)
        {
            ConcurrentChangeTrackedModifiableList<InboundEndpoint> converted = UtilitiesInternal.CollectionToThreadSafeCollectionIModifiable(
                items: protoCollection,
                objectCreationFunc: o => new InboundEndpoint(o));

            return converted;
        }

        /// <summary>
        /// Converts a collection of protocol layer objects to object layer collection objects, in a frozen state.
        /// </summary>
        internal static IList<InboundEndpoint> ConvertFromProtocolCollectionAndFreeze(IEnumerable<Models.InboundEndpoint> protoCollection)
        {
            ConcurrentChangeTrackedModifiableList<InboundEndpoint> converted = UtilitiesInternal.CollectionToThreadSafeCollectionIModifiable(
                items: protoCollection,
                objectCreationFunc: o => new InboundEndpoint(o).Freeze());

            converted = UtilitiesInternal.CreateObjectWithNullCheck(converted, o => o.Freeze());

            return converted;
        }

        /// <summary>
        /// Converts a collection of protocol layer objects to object layer collection objects, with each object marked readonly
        /// and returned as a readonly collection.
        /// </summary>
        internal static IReadOnlyList<InboundEndpoint> ConvertFromProtocolCollectionReadOnly(IEnumerable<Models.InboundEndpoint> protoCollection)
        {
            IReadOnlyList<InboundEndpoint> converted =
                UtilitiesInternal.CreateObjectWithNullCheck(
                    UtilitiesInternal.CollectionToNonThreadSafeCollection(
                        items: protoCollection,
                        objectCreationFunc: o => new InboundEndpoint(o).Freeze()), o => o.AsReadOnly());

            return converted;
        }

        #endregion // Internal/private methods
    }
}