// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

//
// This file was autogenerated by a tool.
// Do not modify it.
//

namespace Microsoft.Azure.Batch
{
    using Models = Microsoft.Azure.Batch.Protocol.Models;
    using System;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// A reference to an Azure Virtual Machines Marketplace Image or a Azure Compute Gallery Image. To get the list of all 
    /// Azure Marketplace Image references verified by Azure Batch, see the 'List Supported Images' operation.
    /// </summary>
    public partial class ImageReference : ITransportObjectProvider<Models.ImageReference>, IPropertyMetadata
    {
        private class PropertyContainer : PropertyCollection
        {
            public readonly PropertyAccessor<string> CommunityGalleryImageIdProperty;
            public readonly PropertyAccessor<string> ExactVersionProperty;
            public readonly PropertyAccessor<string> OfferProperty;
            public readonly PropertyAccessor<string> PublisherProperty;
            public readonly PropertyAccessor<string> SharedGalleryImageIdProperty;
            public readonly PropertyAccessor<string> SkuProperty;
            public readonly PropertyAccessor<string> VersionProperty;
            public readonly PropertyAccessor<string> VirtualMachineImageIdProperty;

            public PropertyContainer() : base(BindingState.Unbound)
            {
                this.CommunityGalleryImageIdProperty = this.CreatePropertyAccessor<string>(nameof(CommunityGalleryImageId), BindingAccess.Read | BindingAccess.Write);
                this.ExactVersionProperty = this.CreatePropertyAccessor<string>(nameof(ExactVersion), BindingAccess.Read);
                this.OfferProperty = this.CreatePropertyAccessor<string>(nameof(Offer), BindingAccess.Read | BindingAccess.Write);
                this.PublisherProperty = this.CreatePropertyAccessor<string>(nameof(Publisher), BindingAccess.Read | BindingAccess.Write);
                this.SharedGalleryImageIdProperty = this.CreatePropertyAccessor<string>(nameof(SharedGalleryImageId), BindingAccess.Read | BindingAccess.Write);
                this.SkuProperty = this.CreatePropertyAccessor<string>(nameof(Sku), BindingAccess.Read | BindingAccess.Write);
                this.VersionProperty = this.CreatePropertyAccessor<string>(nameof(Version), BindingAccess.Read | BindingAccess.Write);
                this.VirtualMachineImageIdProperty = this.CreatePropertyAccessor<string>(nameof(VirtualMachineImageId), BindingAccess.Read | BindingAccess.Write);
            }

            public PropertyContainer(Models.ImageReference protocolObject) : base(BindingState.Bound)
            {
                this.CommunityGalleryImageIdProperty = this.CreatePropertyAccessor(
                    protocolObject.CommunityGalleryImageId,
                    nameof(CommunityGalleryImageId),
                    BindingAccess.Read);
                this.ExactVersionProperty = this.CreatePropertyAccessor(
                    protocolObject.ExactVersion,
                    nameof(ExactVersion),
                    BindingAccess.Read);
                this.OfferProperty = this.CreatePropertyAccessor(
                    protocolObject.Offer,
                    nameof(Offer),
                    BindingAccess.Read);
                this.PublisherProperty = this.CreatePropertyAccessor(
                    protocolObject.Publisher,
                    nameof(Publisher),
                    BindingAccess.Read);
                this.SharedGalleryImageIdProperty = this.CreatePropertyAccessor(
                    protocolObject.SharedGalleryImageId,
                    nameof(SharedGalleryImageId),
                    BindingAccess.Read);
                this.SkuProperty = this.CreatePropertyAccessor(
                    protocolObject.Sku,
                    nameof(Sku),
                    BindingAccess.Read);
                this.VersionProperty = this.CreatePropertyAccessor(
                    protocolObject.Version,
                    nameof(Version),
                    BindingAccess.Read);
                this.VirtualMachineImageIdProperty = this.CreatePropertyAccessor(
                    protocolObject.VirtualMachineImageId,
                    nameof(VirtualMachineImageId),
                    BindingAccess.Read);
            }
        }

        private readonly PropertyContainer propertyContainer;

        #region Constructors

        /// <summary>
        /// Initializes a new instance of the <see cref="ImageReference"/> class.
        /// </summary>
        public ImageReference()
        {
            this.propertyContainer = new PropertyContainer();
        }

        internal ImageReference(Models.ImageReference protocolObject)
        {
            this.propertyContainer = new PropertyContainer(protocolObject);
        }

        #endregion Constructors

        #region ImageReference

        /// <summary>
        /// Gets or sets gets or sets the community gallery image unique identifier
        /// </summary>
        /// <remarks>
        /// This property is mutually exclusive with other properties and can be fetched from community gallery image GET 
        /// call.
        /// </remarks>
        public string CommunityGalleryImageId
        {
            get { return this.propertyContainer.CommunityGalleryImageIdProperty.Value; }
            set { this.propertyContainer.CommunityGalleryImageIdProperty.Value = value; }
        }

        /// <summary>
        /// Gets the specific version of the platform image or marketplace image used to create the node. This read-only 
        /// field differs from 'version' only if the value specified for 'version' when the pool was created was 'latest'.
        /// </summary>
        public string ExactVersion
        {
            get { return this.propertyContainer.ExactVersionProperty.Value; }
        }

        /// <summary>
        /// Gets or sets the offer type of the Azure Virtual Machines Marketplace Image.
        /// </summary>
        /// <remarks>
        /// For example, UbuntuServer or WindowsServer.
        /// </remarks>
        public string Offer
        {
            get { return this.propertyContainer.OfferProperty.Value; }
            set { this.propertyContainer.OfferProperty.Value = value; }
        }

        /// <summary>
        /// Gets or sets the publisher of the Azure Virtual Machines Marketplace Image.
        /// </summary>
        /// <remarks>
        /// For example, Canonical or MicrosoftWindowsServer.
        /// </remarks>
        public string Publisher
        {
            get { return this.propertyContainer.PublisherProperty.Value; }
            set { this.propertyContainer.PublisherProperty.Value = value; }
        }

        /// <summary>
        /// Gets or sets gets or sets the shared gallery image unique identifier
        /// </summary>
        /// <remarks>
        /// This property is mutually exclusive with other properties and can be fetched from shared gallery image GET call.
        /// </remarks>
        public string SharedGalleryImageId
        {
            get { return this.propertyContainer.SharedGalleryImageIdProperty.Value; }
            set { this.propertyContainer.SharedGalleryImageIdProperty.Value = value; }
        }

        /// <summary>
        /// Gets or sets the SKU of the Azure Virtual Machines Marketplace Image.
        /// </summary>
        /// <remarks>
        /// For example, 18.04-LTS or 2019-Datacenter.
        /// </remarks>
        public string Sku
        {
            get { return this.propertyContainer.SkuProperty.Value; }
            set { this.propertyContainer.SkuProperty.Value = value; }
        }

        /// <summary>
        /// Gets or sets the version of the Azure Virtual Machines Marketplace Image.
        /// </summary>
        /// <remarks>
        /// If this property is not specified, it defaults to 'latest', which is the latest version of the image.
        /// </remarks>
        public string Version
        {
            get { return this.propertyContainer.VersionProperty.Value; }
            set { this.propertyContainer.VersionProperty.Value = value; }
        }

        /// <summary>
        /// Gets or sets the ARM resource identifier of the Azure Compute Gallery Image. Compute Nodes in the Pool will be 
        /// created using this Image Id. This is of the form /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/galleries/{galleryName}/images/{imageDefinitionName}/versions/{VersionId} 
        /// or /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/galleries/{galleryName}/images/{imageDefinitionName} 
        /// for always defaulting to the latest image version.
        /// </summary>
        /// <remarks>
        /// This property is mutually exclusive with other ImageReference properties. The Azure Compute Gallery Image must 
        /// have replicas in the same region and must be in the same subscription as the Azure Batch account. If the image 
        /// version is not specified in the imageId, the latest version will be used. For information about the firewall 
        /// settings for the Batch Compute Node agent to communicate with the Batch service see https://docs.microsoft.com/en-us/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration.
        /// </remarks>
        public string VirtualMachineImageId
        {
            get { return this.propertyContainer.VirtualMachineImageIdProperty.Value; }
            set { this.propertyContainer.VirtualMachineImageIdProperty.Value = value; }
        }

        #endregion // ImageReference

        #region IPropertyMetadata

        bool IModifiable.HasBeenModified
        {
            get { return this.propertyContainer.HasBeenModified; }
        }

        bool IReadOnly.IsReadOnly
        {
            get { return this.propertyContainer.IsReadOnly; }
            set { this.propertyContainer.IsReadOnly = value; }
        }

        #endregion //IPropertyMetadata

        #region Internal/private methods
        /// <summary>
        /// Return a protocol object of the requested type.
        /// </summary>
        /// <returns>The protocol object of the requested type.</returns>
        Models.ImageReference ITransportObjectProvider<Models.ImageReference>.GetTransportObject()
        {
            Models.ImageReference result = new Models.ImageReference()
            {
                CommunityGalleryImageId = this.CommunityGalleryImageId,
                Offer = this.Offer,
                Publisher = this.Publisher,
                SharedGalleryImageId = this.SharedGalleryImageId,
                Sku = this.Sku,
                Version = this.Version,
                VirtualMachineImageId = this.VirtualMachineImageId,
            };

            return result;
        }


        #endregion // Internal/private methods
    }
}