// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

//
// This file was autogenerated by a tool.
// Do not modify it.
//

namespace Microsoft.Azure.Batch
{
    using Models = Microsoft.Azure.Batch.Protocol.Models;
    using System;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// A reference to an Azure Virtual Machines Marketplace Image and additional information about the Image.
    /// </summary>
    public partial class ImageInformation : IPropertyMetadata
    {
        #region Constructors

        internal ImageInformation(Models.ImageInformation protocolObject)
        {
            this.BatchSupportEndOfLife = protocolObject.BatchSupportEndOfLife;
            this.Capabilities = UtilitiesInternal.CreateObjectWithNullCheck(protocolObject.Capabilities, o => o.ToList().AsReadOnly());
            this.ImageReference = UtilitiesInternal.CreateObjectWithNullCheck(protocolObject.ImageReference, o => new ImageReference(o).Freeze());
            this.NodeAgentSkuId = protocolObject.NodeAgentSKUId;
            this.OSType = UtilitiesInternal.MapNullableEnum<Models.OSType, Common.OSType>(protocolObject.OsType);
            this.VerificationType = UtilitiesInternal.MapNullableEnum<Models.VerificationType, Common.VerificationType>(protocolObject.VerificationType);
        }

        #endregion Constructors

        #region ImageInformation

        /// <summary>
        /// Gets the time when the Azure Batch service will stop accepting create pool requests for the Image.
        /// </summary>
        public DateTime? BatchSupportEndOfLife { get; }

        /// <summary>
        /// Gets the capabilities or features which the Image supports.
        /// </summary>
        /// <remarks>
        /// Not every capability of the Image is listed. Capabilities in this list are considered of special interest and 
        /// are generally related to integration with other features in the Azure Batch service.
        /// </remarks>
        public IReadOnlyList<string> Capabilities { get; }

        /// <summary>
        /// Gets the reference to the Azure Virtual Machine's Marketplace Image.
        /// </summary>
        public ImageReference ImageReference { get; }

        /// <summary>
        /// Gets the ID of the node agent SKU which the Image supports
        /// </summary>
        public string NodeAgentSkuId { get; }

        /// <summary>
        /// Gets the type of operating system (e.g. Windows or Linux) of the Image.
        /// </summary>
        public Common.OSType? OSType { get; }

        /// <summary>
        /// Gets whether the Azure Batch service actively verifies that the Image is compatible with the associated Node 
        /// Agent SKU.
        /// </summary>
        public Common.VerificationType? VerificationType { get; }

        #endregion // ImageInformation

        #region IPropertyMetadata

        bool IModifiable.HasBeenModified
        {
            //This class is compile time readonly so it cannot have been modified
            get { return false; }
        }

        bool IReadOnly.IsReadOnly
        {
            get { return true; }
            set
            {
                // This class is compile time readonly already
            }
        }

        #endregion // IPropertyMetadata
    }
}