// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

//
// This file was autogenerated by a tool.
// Do not modify it.
//

namespace Microsoft.Azure.Batch
{
    using Models = Microsoft.Azure.Batch.Protocol.Models;
    using System;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// An HTTP header name-value pair
    /// </summary>
    public partial class HttpHeader : ITransportObjectProvider<Models.HttpHeader>, IPropertyMetadata
    {
        private class PropertyContainer : PropertyCollection
        {
            public readonly PropertyAccessor<string> NameProperty;
            public readonly PropertyAccessor<string> ValueProperty;

            public PropertyContainer() : base(BindingState.Unbound)
            {
                this.NameProperty = this.CreatePropertyAccessor<string>(nameof(Name), BindingAccess.Read | BindingAccess.Write);
                this.ValueProperty = this.CreatePropertyAccessor<string>(nameof(Value), BindingAccess.Read | BindingAccess.Write);
            }

            public PropertyContainer(Models.HttpHeader protocolObject) : base(BindingState.Bound)
            {
                this.NameProperty = this.CreatePropertyAccessor(
                    protocolObject.Name,
                    nameof(Name),
                    BindingAccess.Read | BindingAccess.Write);
                this.ValueProperty = this.CreatePropertyAccessor(
                    protocolObject.Value,
                    nameof(Value),
                    BindingAccess.Read | BindingAccess.Write);
            }
        }

        private readonly PropertyContainer propertyContainer;

        #region Constructors

        /// <summary>
        /// Initializes a new instance of the <see cref="HttpHeader"/> class.
        /// </summary>
        /// <param name='name'>The case-insensitive name of the header to be used while uploading output files.</param>
        /// <param name='value'>The value of the header to be used while uploading output files.</param>
        public HttpHeader(
            string name,
            string value)
        {
            this.propertyContainer = new PropertyContainer();
            this.Name = name;
            this.Value = value;
        }

        /// <summary>
        /// Default constructor to support mocking the <see cref="HttpHeader"/> class.
        /// </summary>
        protected HttpHeader()
        {
            this.propertyContainer = new PropertyContainer();
        }

        internal HttpHeader(Models.HttpHeader protocolObject)
        {
            this.propertyContainer = new PropertyContainer(protocolObject);
        }

        #endregion Constructors

        #region HttpHeader

        /// <summary>
        /// Gets or sets the case-insensitive name of the header to be used while uploading output files.
        /// </summary>
        public string Name
        {
            get { return this.propertyContainer.NameProperty.Value; }
            set { this.propertyContainer.NameProperty.Value = value; }
        }

        /// <summary>
        /// Gets or sets the value of the header to be used while uploading output files.
        /// </summary>
        public string Value
        {
            get { return this.propertyContainer.ValueProperty.Value; }
            set { this.propertyContainer.ValueProperty.Value = value; }
        }

        #endregion // HttpHeader

        #region IPropertyMetadata

        bool IModifiable.HasBeenModified
        {
            get { return this.propertyContainer.HasBeenModified; }
        }

        bool IReadOnly.IsReadOnly
        {
            get { return this.propertyContainer.IsReadOnly; }
            set { this.propertyContainer.IsReadOnly = value; }
        }

        #endregion //IPropertyMetadata

        #region Internal/private methods
        /// <summary>
        /// Return a protocol object of the requested type.
        /// </summary>
        /// <returns>The protocol object of the requested type.</returns>
        Models.HttpHeader ITransportObjectProvider<Models.HttpHeader>.GetTransportObject()
        {
            Models.HttpHeader result = new Models.HttpHeader()
            {
                Name = this.Name,
                Value = this.Value,
            };

            return result;
        }

        /// <summary>
        /// Converts a collection of protocol layer objects to object layer collection objects.
        /// </summary>
        internal static IList<HttpHeader> ConvertFromProtocolCollection(IEnumerable<Models.HttpHeader> protoCollection)
        {
            ConcurrentChangeTrackedModifiableList<HttpHeader> converted = UtilitiesInternal.CollectionToThreadSafeCollectionIModifiable(
                items: protoCollection,
                objectCreationFunc: o => new HttpHeader(o));

            return converted;
        }

        /// <summary>
        /// Converts a collection of protocol layer objects to object layer collection objects, in a frozen state.
        /// </summary>
        internal static IList<HttpHeader> ConvertFromProtocolCollectionAndFreeze(IEnumerable<Models.HttpHeader> protoCollection)
        {
            ConcurrentChangeTrackedModifiableList<HttpHeader> converted = UtilitiesInternal.CollectionToThreadSafeCollectionIModifiable(
                items: protoCollection,
                objectCreationFunc: o => new HttpHeader(o).Freeze());

            converted = UtilitiesInternal.CreateObjectWithNullCheck(converted, o => o.Freeze());

            return converted;
        }

        /// <summary>
        /// Converts a collection of protocol layer objects to object layer collection objects, with each object marked readonly
        /// and returned as a readonly collection.
        /// </summary>
        internal static IReadOnlyList<HttpHeader> ConvertFromProtocolCollectionReadOnly(IEnumerable<Models.HttpHeader> protoCollection)
        {
            IReadOnlyList<HttpHeader> converted =
                UtilitiesInternal.CreateObjectWithNullCheck(
                    UtilitiesInternal.CollectionToNonThreadSafeCollection(
                        items: protoCollection,
                        objectCreationFunc: o => new HttpHeader(o).Freeze()), o => o.AsReadOnly());

            return converted;
        }

        #endregion // Internal/private methods
    }
}