// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

//
// This file was autogenerated by a tool.
// Do not modify it.
//

namespace Microsoft.Azure.Batch
{
    using Models = Microsoft.Azure.Batch.Protocol.Models;
    using System;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// The properties of a file on a compute node.
    /// </summary>
    public partial class FileProperties : IPropertyMetadata
    {
        #region Constructors

        internal FileProperties(Models.FileProperties protocolObject)
        {
            this.ContentLength = protocolObject.ContentLength;
            this.ContentType = protocolObject.ContentType;
            this.CreationTime = protocolObject.CreationTime;
            this.FileMode = protocolObject.FileMode;
            this.LastModified = protocolObject.LastModified;
        }

        #endregion Constructors

        #region FileProperties

        /// <summary>
        /// Gets the length of the file.
        /// </summary>
        public long ContentLength { get; }

        /// <summary>
        /// Gets the content type of the file.
        /// </summary>
        public string ContentType { get; }

        /// <summary>
        /// Gets the file creation time.
        /// </summary>
        public DateTime? CreationTime { get; }

        /// <summary>
        /// Gets the permission attribute for the file.
        /// </summary>
        /// <remarks>
        /// This property will be returned only for Linux nodes.
        /// </remarks>
        public string FileMode { get; }

        /// <summary>
        /// Gets the time at which the file was last modified.
        /// </summary>
        public DateTime LastModified { get; }

        #endregion // FileProperties

        #region IPropertyMetadata

        bool IModifiable.HasBeenModified
        {
            //This class is compile time readonly so it cannot have been modified
            get { return false; }
        }

        bool IReadOnly.IsReadOnly
        {
            get { return true; }
            set
            {
                // This class is compile time readonly already
            }
        }

        #endregion // IPropertyMetadata
    }
}