// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

//
// This file was autogenerated by a tool.
// Do not modify it.
//

namespace Microsoft.Azure.Batch
{
    using Models = Microsoft.Azure.Batch.Protocol.Models;
    using System;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// How the Batch service should respond when a task completes.
    /// </summary>
    public partial class ExitConditions : ITransportObjectProvider<Models.ExitConditions>, IPropertyMetadata
    {
        private class PropertyContainer : PropertyCollection
        {
            public readonly PropertyAccessor<ExitOptions> DefaultProperty;
            public readonly PropertyAccessor<IList<ExitCodeRangeMapping>> ExitCodeRangesProperty;
            public readonly PropertyAccessor<IList<ExitCodeMapping>> ExitCodesProperty;
            public readonly PropertyAccessor<ExitOptions> FileUploadErrorProperty;
            public readonly PropertyAccessor<ExitOptions> PreProcessingErrorProperty;

            public PropertyContainer() : base(BindingState.Unbound)
            {
                this.DefaultProperty = this.CreatePropertyAccessor<ExitOptions>(nameof(Default), BindingAccess.Read | BindingAccess.Write);
                this.ExitCodeRangesProperty = this.CreatePropertyAccessor<IList<ExitCodeRangeMapping>>(nameof(ExitCodeRanges), BindingAccess.Read | BindingAccess.Write);
                this.ExitCodesProperty = this.CreatePropertyAccessor<IList<ExitCodeMapping>>(nameof(ExitCodes), BindingAccess.Read | BindingAccess.Write);
                this.FileUploadErrorProperty = this.CreatePropertyAccessor<ExitOptions>(nameof(FileUploadError), BindingAccess.Read | BindingAccess.Write);
                this.PreProcessingErrorProperty = this.CreatePropertyAccessor<ExitOptions>(nameof(PreProcessingError), BindingAccess.Read | BindingAccess.Write);
            }

            public PropertyContainer(Models.ExitConditions protocolObject) : base(BindingState.Bound)
            {
                this.DefaultProperty = this.CreatePropertyAccessor(
                    UtilitiesInternal.CreateObjectWithNullCheck(protocolObject.DefaultProperty, o => new ExitOptions(o).Freeze()),
                    nameof(Default),
                    BindingAccess.Read);
                this.ExitCodeRangesProperty = this.CreatePropertyAccessor(
                    ExitCodeRangeMapping.ConvertFromProtocolCollectionAndFreeze(protocolObject.ExitCodeRanges),
                    nameof(ExitCodeRanges),
                    BindingAccess.Read);
                this.ExitCodesProperty = this.CreatePropertyAccessor(
                    ExitCodeMapping.ConvertFromProtocolCollectionAndFreeze(protocolObject.ExitCodes),
                    nameof(ExitCodes),
                    BindingAccess.Read);
                this.FileUploadErrorProperty = this.CreatePropertyAccessor(
                    UtilitiesInternal.CreateObjectWithNullCheck(protocolObject.FileUploadError, o => new ExitOptions(o).Freeze()),
                    nameof(FileUploadError),
                    BindingAccess.Read);
                this.PreProcessingErrorProperty = this.CreatePropertyAccessor(
                    UtilitiesInternal.CreateObjectWithNullCheck(protocolObject.PreProcessingError, o => new ExitOptions(o).Freeze()),
                    nameof(PreProcessingError),
                    BindingAccess.Read);
            }
        }

        private readonly PropertyContainer propertyContainer;

        #region Constructors

        /// <summary>
        /// Initializes a new instance of the <see cref="ExitConditions"/> class.
        /// </summary>
        public ExitConditions()
        {
            this.propertyContainer = new PropertyContainer();
        }

        internal ExitConditions(Models.ExitConditions protocolObject)
        {
            this.propertyContainer = new PropertyContainer(protocolObject);
        }

        #endregion Constructors

        #region ExitConditions

        /// <summary>
        /// Gets or sets how the Batch service should respond if the task fails with an exit condition not covered by any 
        /// of the other properties.
        /// </summary>
        /// <remarks>
        /// This value is used if the task exits with any nonzero exit code not listed in the <see cref="ExitCodes"/> or 
        /// <see cref="ExitCodeRanges"/> collection, with a preprocessing error if the <see cref="PreProcessingError"/> property 
        /// is not present, or with a file upload failure if the <see cref="FileUploadError"/> property is not present.
        /// </remarks>
        public ExitOptions Default
        {
            get { return this.propertyContainer.DefaultProperty.Value; }
            set { this.propertyContainer.DefaultProperty.Value = value; }
        }

        /// <summary>
        /// Gets or sets a list of task exit code ranges and how the Batch service should respond to them.
        /// </summary>
        public IList<ExitCodeRangeMapping> ExitCodeRanges
        {
            get { return this.propertyContainer.ExitCodeRangesProperty.Value; }
            set
            {
                this.propertyContainer.ExitCodeRangesProperty.Value = ConcurrentChangeTrackedModifiableList<ExitCodeRangeMapping>.TransformEnumerableToConcurrentModifiableList(value);
            }
        }

        /// <summary>
        /// Gets or sets a list of task exit codes and how the Batch service should respond to them.
        /// </summary>
        public IList<ExitCodeMapping> ExitCodes
        {
            get { return this.propertyContainer.ExitCodesProperty.Value; }
            set
            {
                this.propertyContainer.ExitCodesProperty.Value = ConcurrentChangeTrackedModifiableList<ExitCodeMapping>.TransformEnumerableToConcurrentModifiableList(value);
            }
        }

        /// <summary>
        /// Gets or sets how the Batch service should respond if a file upload error occurs.
        /// </summary>
        /// <remarks>
        /// If the task exited with an exit code that was specified via <see cref="ExitCodes" /> or <see cref="ExitCodeRanges" 
        /// />, and then encountered a file upload error, then the action specified by the exit code takes precedence.
        /// </remarks>
        public ExitOptions FileUploadError
        {
            get { return this.propertyContainer.FileUploadErrorProperty.Value; }
            set { this.propertyContainer.FileUploadErrorProperty.Value = value; }
        }

        /// <summary>
        /// Gets or sets how the Batch service should respond if the task fails to start due to an error.
        /// </summary>
        public ExitOptions PreProcessingError
        {
            get { return this.propertyContainer.PreProcessingErrorProperty.Value; }
            set { this.propertyContainer.PreProcessingErrorProperty.Value = value; }
        }

        #endregion // ExitConditions

        #region IPropertyMetadata

        bool IModifiable.HasBeenModified
        {
            get { return this.propertyContainer.HasBeenModified; }
        }

        bool IReadOnly.IsReadOnly
        {
            get { return this.propertyContainer.IsReadOnly; }
            set { this.propertyContainer.IsReadOnly = value; }
        }

        #endregion //IPropertyMetadata

        #region Internal/private methods
        /// <summary>
        /// Return a protocol object of the requested type.
        /// </summary>
        /// <returns>The protocol object of the requested type.</returns>
        Models.ExitConditions ITransportObjectProvider<Models.ExitConditions>.GetTransportObject()
        {
            Models.ExitConditions result = new Models.ExitConditions()
            {
                DefaultProperty = UtilitiesInternal.CreateObjectWithNullCheck(this.Default, (o) => o.GetTransportObject()),
                ExitCodeRanges = UtilitiesInternal.ConvertToProtocolCollection(this.ExitCodeRanges),
                ExitCodes = UtilitiesInternal.ConvertToProtocolCollection(this.ExitCodes),
                FileUploadError = UtilitiesInternal.CreateObjectWithNullCheck(this.FileUploadError, (o) => o.GetTransportObject()),
                PreProcessingError = UtilitiesInternal.CreateObjectWithNullCheck(this.PreProcessingError, (o) => o.GetTransportObject()),
            };

            return result;
        }

        /// <summary>
        /// Converts a collection of protocol layer objects to object layer collection objects.
        /// </summary>
        internal static IList<ExitConditions> ConvertFromProtocolCollection(IEnumerable<Models.ExitConditions> protoCollection)
        {
            ConcurrentChangeTrackedModifiableList<ExitConditions> converted = UtilitiesInternal.CollectionToThreadSafeCollectionIModifiable(
                items: protoCollection,
                objectCreationFunc: o => new ExitConditions(o));

            return converted;
        }

        /// <summary>
        /// Converts a collection of protocol layer objects to object layer collection objects, in a frozen state.
        /// </summary>
        internal static IList<ExitConditions> ConvertFromProtocolCollectionAndFreeze(IEnumerable<Models.ExitConditions> protoCollection)
        {
            ConcurrentChangeTrackedModifiableList<ExitConditions> converted = UtilitiesInternal.CollectionToThreadSafeCollectionIModifiable(
                items: protoCollection,
                objectCreationFunc: o => new ExitConditions(o).Freeze());

            converted = UtilitiesInternal.CreateObjectWithNullCheck(converted, o => o.Freeze());

            return converted;
        }

        /// <summary>
        /// Converts a collection of protocol layer objects to object layer collection objects, with each object marked readonly
        /// and returned as a readonly collection.
        /// </summary>
        internal static IReadOnlyList<ExitConditions> ConvertFromProtocolCollectionReadOnly(IEnumerable<Models.ExitConditions> protoCollection)
        {
            IReadOnlyList<ExitConditions> converted =
                UtilitiesInternal.CreateObjectWithNullCheck(
                    UtilitiesInternal.CollectionToNonThreadSafeCollection(
                        items: protoCollection,
                        objectCreationFunc: o => new ExitConditions(o).Freeze()), o => o.AsReadOnly());

            return converted;
        }

        #endregion // Internal/private methods
    }
}