// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

//
// This file was autogenerated by a tool.
// Do not modify it.
//

namespace Microsoft.Azure.Batch
{
    using Models = Microsoft.Azure.Batch.Protocol.Models;
    using System;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// An environment variable to be set on a task process, such as a job task, start task, job manager task, or job preparation 
    /// or release task.
    /// </summary>
    public partial class EnvironmentSetting : ITransportObjectProvider<Models.EnvironmentSetting>, IPropertyMetadata
    {
        #region Constructors
        /// <summary>
        /// Initializes a new instance of the <see cref="EnvironmentSetting"/> class.
        /// </summary>
        /// <param name='name'>The name of the environment variable.</param>
        /// <param name='value'>The value of the environment variable.</param>
        public EnvironmentSetting(
            string name,
            string value)
        {
            this.Name = name;
            this.Value = value;
        }

        internal EnvironmentSetting(Models.EnvironmentSetting protocolObject)
        {
            this.Name = protocolObject.Name;
            this.Value = protocolObject.Value;
        }

        #endregion Constructors

        #region EnvironmentSetting

        /// <summary>
        /// Gets the name of the environment variable.
        /// </summary>
        public string Name { get; }

        /// <summary>
        /// Gets the value of the environment variable.
        /// </summary>
        public string Value { get; }

        #endregion // EnvironmentSetting

        #region IPropertyMetadata

        bool IModifiable.HasBeenModified
        {
            //This class is compile time readonly so it cannot have been modified
            get { return false; }
        }

        bool IReadOnly.IsReadOnly
        {
            get { return true; }
            set
            {
                // This class is compile time readonly already
            }
        }

        #endregion // IPropertyMetadata

        #region Internal/private methods

        /// <summary>
        /// Return a protocol object of the requested type.
        /// </summary>
        /// <returns>The protocol object of the requested type.</returns>
        Models.EnvironmentSetting ITransportObjectProvider<Models.EnvironmentSetting>.GetTransportObject()
        {
            Models.EnvironmentSetting result = new Models.EnvironmentSetting()
            {
                Name = this.Name,
                Value = this.Value,
            };

            return result;
        }

        /// <summary>
        /// Converts a collection of protocol layer objects to object layer collection objects.
        /// </summary>
        internal static IList<EnvironmentSetting> ConvertFromProtocolCollection(IEnumerable<Models.EnvironmentSetting> protoCollection)
        {
            ConcurrentChangeTrackedModifiableList<EnvironmentSetting> converted = UtilitiesInternal.CollectionToThreadSafeCollectionIModifiable(
                items: protoCollection,
                objectCreationFunc: o => new EnvironmentSetting(o));

            return converted;
        }

        /// <summary>
        /// Converts a collection of protocol layer objects to object layer collection objects, in a frozen state.
        /// </summary>
        internal static IList<EnvironmentSetting> ConvertFromProtocolCollectionAndFreeze(IEnumerable<Models.EnvironmentSetting> protoCollection)
        {
            ConcurrentChangeTrackedModifiableList<EnvironmentSetting> converted = UtilitiesInternal.CollectionToThreadSafeCollectionIModifiable(
                items: protoCollection,
                objectCreationFunc: o => new EnvironmentSetting(o).Freeze());

            converted = UtilitiesInternal.CreateObjectWithNullCheck(converted, o => o.Freeze());

            return converted;
        }

        /// <summary>
        /// Converts a collection of protocol layer objects to object layer collection objects, with each object marked readonly
        /// and returned as a readonly collection.
        /// </summary>
        internal static IReadOnlyList<EnvironmentSetting> ConvertFromProtocolCollectionReadOnly(IEnumerable<Models.EnvironmentSetting> protoCollection)
        {
            IReadOnlyList<EnvironmentSetting> converted =
                UtilitiesInternal.CreateObjectWithNullCheck(
                    UtilitiesInternal.CollectionToNonThreadSafeCollection(
                        items: protoCollection,
                        objectCreationFunc: o => new EnvironmentSetting(o).Freeze()), o => o.AsReadOnly());

            return converted;
        }

        #endregion // Internal/private methods
    }
}