// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

//
// This file was autogenerated by a tool.
// Do not modify it.
//

namespace Microsoft.Azure.Batch
{
    using Models = Microsoft.Azure.Batch.Protocol.Models;
    using System;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// The disk encryption configuration applied on compute nodes in the pool. Disk encryption configuration is not supported 
    /// on Linux pool created with Azure Compute Gallery Image.
    /// </summary>
    public partial class DiskEncryptionConfiguration : ITransportObjectProvider<Models.DiskEncryptionConfiguration>, IPropertyMetadata
    {
        #region Constructors
        /// <summary>
        /// Initializes a new instance of the <see cref="DiskEncryptionConfiguration"/> class.
        /// </summary>
        /// <param name='targets'>The list of disk targets Batch Service will encrypt on the compute node.</param>
        public DiskEncryptionConfiguration(
            IList<Common.DiskEncryptionTarget> targets)
        {
            this.Targets = targets;
        }

        internal DiskEncryptionConfiguration(Models.DiskEncryptionConfiguration protocolObject)
        {
            this.Targets = UtilitiesInternal.ConvertEnumCollection<Models.DiskEncryptionTarget, Common.DiskEncryptionTarget>(protocolObject.Targets);
        }

        #endregion Constructors

        #region DiskEncryptionConfiguration

        /// <summary>
        /// Gets the list of disk targets Batch Service will encrypt on the compute node.
        /// </summary>
        /// <remarks>
        /// If omitted, no disks on the compute nodes in the pool will be encrypted. On Linux pool, only <see cref="Common.DiskEncryptionTarget.TemporaryDisk"/> 
        /// is supported; on Windows pool, <see cref="Common.DiskEncryptionTarget.OsDisk"/> and <see cref="Common.DiskEncryptionTarget.TemporaryDisk"/> 
        /// must be specified.
        /// </remarks>
        public IList<Common.DiskEncryptionTarget> Targets { get; }

        #endregion // DiskEncryptionConfiguration

        #region IPropertyMetadata

        bool IModifiable.HasBeenModified
        {
            //This class is compile time readonly so it cannot have been modified
            get { return false; }
        }

        bool IReadOnly.IsReadOnly
        {
            get { return true; }
            set
            {
                // This class is compile time readonly already
            }
        }

        #endregion // IPropertyMetadata

        #region Internal/private methods

        /// <summary>
        /// Return a protocol object of the requested type.
        /// </summary>
        /// <returns>The protocol object of the requested type.</returns>
        Models.DiskEncryptionConfiguration ITransportObjectProvider<Models.DiskEncryptionConfiguration>.GetTransportObject()
        {
            Models.DiskEncryptionConfiguration result = new Models.DiskEncryptionConfiguration()
            {
                Targets = UtilitiesInternal.ConvertEnumCollection<Common.DiskEncryptionTarget, Models.DiskEncryptionTarget>(this.Targets),
            };

            return result;
        }


        #endregion // Internal/private methods
    }
}