// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

//
// This file was autogenerated by a tool.
// Do not modify it.
//

namespace Microsoft.Azure.Batch
{
    using Models = Microsoft.Azure.Batch.Protocol.Models;
    using System;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// Specifies the ephemeral Disk Settings for the operating system disk used by the compute node (VM).
    /// </summary>
    public partial class DiffDiskSettings : ITransportObjectProvider<Models.DiffDiskSettings>, IPropertyMetadata
    {
        private class PropertyContainer : PropertyCollection
        {
            public readonly PropertyAccessor<Common.DiffDiskPlacement?> PlacementProperty;

            public PropertyContainer() : base(BindingState.Unbound)
            {
                this.PlacementProperty = this.CreatePropertyAccessor<Common.DiffDiskPlacement?>(nameof(Placement), BindingAccess.Read | BindingAccess.Write);
            }

            public PropertyContainer(Models.DiffDiskSettings protocolObject) : base(BindingState.Bound)
            {
                this.PlacementProperty = this.CreatePropertyAccessor(
                    UtilitiesInternal.MapNullableEnum<Models.DiffDiskPlacement, Common.DiffDiskPlacement>(protocolObject.Placement),
                    nameof(Placement),
                    BindingAccess.Read | BindingAccess.Write);
            }
        }

        private readonly PropertyContainer propertyContainer;

        #region Constructors

        /// <summary>
        /// Initializes a new instance of the <see cref="DiffDiskSettings"/> class.
        /// </summary>
        public DiffDiskSettings()
        {
            this.propertyContainer = new PropertyContainer();
        }

        internal DiffDiskSettings(Models.DiffDiskSettings protocolObject)
        {
            this.propertyContainer = new PropertyContainer(protocolObject);
        }

        #endregion Constructors

        #region DiffDiskSettings

        /// <summary>
        /// Gets or sets this property can be used by user in the request to choose the location e.g., cache disk space for 
        /// Ephemeral OS disk provisioning. For more information on Ephemeral OS disk size requirements, please refer to 
        /// Ephemeral OS disk size requirements for Windows VMs at https://docs.microsoft.com/en-us/azure/virtual-machines/windows/ephemeral-os-disks#size-requirements 
        /// and Linux VMs at https://docs.microsoft.com/en-us/azure/virtual-machines/linux/ephemeral-os-disks#size-requirements.
        /// </summary>
        public Common.DiffDiskPlacement? Placement
        {
            get { return this.propertyContainer.PlacementProperty.Value; }
            set { this.propertyContainer.PlacementProperty.Value = value; }
        }

        #endregion // DiffDiskSettings

        #region IPropertyMetadata

        bool IModifiable.HasBeenModified
        {
            get { return this.propertyContainer.HasBeenModified; }
        }

        bool IReadOnly.IsReadOnly
        {
            get { return this.propertyContainer.IsReadOnly; }
            set { this.propertyContainer.IsReadOnly = value; }
        }

        #endregion //IPropertyMetadata

        #region Internal/private methods
        /// <summary>
        /// Return a protocol object of the requested type.
        /// </summary>
        /// <returns>The protocol object of the requested type.</returns>
        Models.DiffDiskSettings ITransportObjectProvider<Models.DiffDiskSettings>.GetTransportObject()
        {
            Models.DiffDiskSettings result = new Models.DiffDiskSettings()
            {
                Placement = UtilitiesInternal.MapNullableEnum<Common.DiffDiskPlacement, Models.DiffDiskPlacement>(this.Placement),
            };

            return result;
        }


        #endregion // Internal/private methods
    }
}