// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

//
// This file was autogenerated by a tool.
// Do not modify it.
//

namespace Microsoft.Azure.Batch
{
    using Models = Microsoft.Azure.Batch.Protocol.Models;
    using System;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// Settings which will be used by the data disks associated to compute nodes in the pool.
    /// </summary>
    public partial class DataDisk : ITransportObjectProvider<Models.DataDisk>, IPropertyMetadata
    {
        #region Constructors
        /// <summary>
        /// Initializes a new instance of the <see cref="DataDisk"/> class.
        /// </summary>
        /// <param name='lun'>The logical unit number.</param>
        /// <param name='diskSizeGB'>The initial disk size in gigabytes.</param>
        /// <param name='caching'>The type of caching to enable for the OS disk.</param>
        /// <param name='storageAccountType'>The storage account type to be used for the data disk.</param>
        public DataDisk(
            int lun,
            int diskSizeGB,
            Common.CachingType? caching = default(Common.CachingType?),
            Common.StorageAccountType? storageAccountType = default(Common.StorageAccountType?))
        {
            this.Lun = lun;
            this.DiskSizeGB = diskSizeGB;
            this.Caching = caching;
            this.StorageAccountType = storageAccountType;
        }

        internal DataDisk(Models.DataDisk protocolObject)
        {
            this.Caching = UtilitiesInternal.MapNullableEnum<Models.CachingType, Common.CachingType>(protocolObject.Caching);
            this.DiskSizeGB = protocolObject.DiskSizeGB;
            this.Lun = protocolObject.Lun;
            this.StorageAccountType = UtilitiesInternal.MapNullableEnum<Models.StorageAccountType, Common.StorageAccountType>(protocolObject.StorageAccountType);
        }

        #endregion Constructors

        #region DataDisk

        /// <summary>
        /// Gets the type of caching to enable for the OS disk.
        /// </summary>
        /// <remarks>
        /// If omitted, the default is <see cref="Common.CachingType.ReadWrite" />.
        /// </remarks>
        public Common.CachingType? Caching { get; }

        /// <summary>
        /// Gets the initial disk size in gigabytes.
        /// </summary>
        public int DiskSizeGB { get; }

        /// <summary>
        /// Gets the logical unit number.
        /// </summary>
        /// <remarks>
        /// The lun is used to uniquely identify each data disk. If attaching multiple disks, each should have a distinct 
        /// lun.
        /// </remarks>
        public int Lun { get; }

        /// <summary>
        /// Gets the storage account type to be used for the data disk.
        /// </summary>
        /// <remarks>
        /// If omitted, the default is <see cref="Common.StorageAccountType.StandardLrs" />.
        /// </remarks>
        public Common.StorageAccountType? StorageAccountType { get; }

        #endregion // DataDisk

        #region IPropertyMetadata

        bool IModifiable.HasBeenModified
        {
            //This class is compile time readonly so it cannot have been modified
            get { return false; }
        }

        bool IReadOnly.IsReadOnly
        {
            get { return true; }
            set
            {
                // This class is compile time readonly already
            }
        }

        #endregion // IPropertyMetadata

        #region Internal/private methods

        /// <summary>
        /// Return a protocol object of the requested type.
        /// </summary>
        /// <returns>The protocol object of the requested type.</returns>
        Models.DataDisk ITransportObjectProvider<Models.DataDisk>.GetTransportObject()
        {
            Models.DataDisk result = new Models.DataDisk()
            {
                Caching = UtilitiesInternal.MapNullableEnum<Common.CachingType, Models.CachingType>(this.Caching),
                DiskSizeGB = this.DiskSizeGB,
                Lun = this.Lun,
                StorageAccountType = UtilitiesInternal.MapNullableEnum<Common.StorageAccountType, Models.StorageAccountType>(this.StorageAccountType),
            };

            return result;
        }

        /// <summary>
        /// Converts a collection of protocol layer objects to object layer collection objects.
        /// </summary>
        internal static IList<DataDisk> ConvertFromProtocolCollection(IEnumerable<Models.DataDisk> protoCollection)
        {
            ConcurrentChangeTrackedModifiableList<DataDisk> converted = UtilitiesInternal.CollectionToThreadSafeCollectionIModifiable(
                items: protoCollection,
                objectCreationFunc: o => new DataDisk(o));

            return converted;
        }

        /// <summary>
        /// Converts a collection of protocol layer objects to object layer collection objects, in a frozen state.
        /// </summary>
        internal static IList<DataDisk> ConvertFromProtocolCollectionAndFreeze(IEnumerable<Models.DataDisk> protoCollection)
        {
            ConcurrentChangeTrackedModifiableList<DataDisk> converted = UtilitiesInternal.CollectionToThreadSafeCollectionIModifiable(
                items: protoCollection,
                objectCreationFunc: o => new DataDisk(o).Freeze());

            converted = UtilitiesInternal.CreateObjectWithNullCheck(converted, o => o.Freeze());

            return converted;
        }

        /// <summary>
        /// Converts a collection of protocol layer objects to object layer collection objects, with each object marked readonly
        /// and returned as a readonly collection.
        /// </summary>
        internal static IReadOnlyList<DataDisk> ConvertFromProtocolCollectionReadOnly(IEnumerable<Models.DataDisk> protoCollection)
        {
            IReadOnlyList<DataDisk> converted =
                UtilitiesInternal.CreateObjectWithNullCheck(
                    UtilitiesInternal.CollectionToNonThreadSafeCollection(
                        items: protoCollection,
                        objectCreationFunc: o => new DataDisk(o).Freeze()), o => o.AsReadOnly());

            return converted;
        }

        #endregion // Internal/private methods
    }
}