// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

//
// This file was autogenerated by a tool.
// Do not modify it.
//

namespace Microsoft.Azure.Batch
{
    using Models = Microsoft.Azure.Batch.Protocol.Models;
    using System;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// A private container registry.
    /// </summary>
    public partial class ContainerRegistry : ITransportObjectProvider<Models.ContainerRegistry>, IPropertyMetadata
    {
        #region Constructors
        /// <summary>
        /// Initializes a new instance of the <see cref="ContainerRegistry"/> class.
        /// </summary>
        /// <param name='userName'>The user name to log into the registry server.</param>
        /// <param name='password'>The password to log into the registry server.</param>
        /// <param name='registryServer'>The registry URL.</param>
        /// <param name='identityReference'>The reference to the user assigned identity to use to access an Azure Container Registry instead of username 
        /// and password.</param>
        public ContainerRegistry(
            string userName = default(string),
            string password = default(string),
            string registryServer = default(string),
            ComputeNodeIdentityReference identityReference = default(ComputeNodeIdentityReference))
        {
            this.UserName = userName;
            this.Password = password;
            this.RegistryServer = registryServer;
            this.IdentityReference = identityReference;
        }

        internal ContainerRegistry(Models.ContainerRegistry protocolObject)
        {
            this.IdentityReference = UtilitiesInternal.CreateObjectWithNullCheck(protocolObject.IdentityReference, o => new ComputeNodeIdentityReference(o).Freeze());
            this.Password = protocolObject.Password;
            this.RegistryServer = protocolObject.RegistryServer;
            this.UserName = protocolObject.UserName;
        }

        #endregion Constructors

        #region ContainerRegistry

        /// <summary>
        /// Gets the reference to the user assigned identity to use to access an Azure Container Registry instead of username 
        /// and password.
        /// </summary>
        public ComputeNodeIdentityReference IdentityReference { get; }

        /// <summary>
        /// Gets the password to log into the registry server.
        /// </summary>
        public string Password { get; }

        /// <summary>
        /// Gets the registry URL.
        /// </summary>
        /// <remarks>
        /// If omitted, the default is "docker.io".
        /// </remarks>
        public string RegistryServer { get; }

        /// <summary>
        /// Gets the user name to log into the registry server.
        /// </summary>
        public string UserName { get; }

        #endregion // ContainerRegistry

        #region IPropertyMetadata

        bool IModifiable.HasBeenModified
        {
            //This class is compile time readonly so it cannot have been modified
            get { return false; }
        }

        bool IReadOnly.IsReadOnly
        {
            get { return true; }
            set
            {
                // This class is compile time readonly already
            }
        }

        #endregion // IPropertyMetadata

        #region Internal/private methods

        /// <summary>
        /// Return a protocol object of the requested type.
        /// </summary>
        /// <returns>The protocol object of the requested type.</returns>
        Models.ContainerRegistry ITransportObjectProvider<Models.ContainerRegistry>.GetTransportObject()
        {
            Models.ContainerRegistry result = new Models.ContainerRegistry()
            {
                IdentityReference = UtilitiesInternal.CreateObjectWithNullCheck(this.IdentityReference, (o) => o.GetTransportObject()),
                Password = this.Password,
                RegistryServer = this.RegistryServer,
                UserName = this.UserName,
            };

            return result;
        }

        /// <summary>
        /// Converts a collection of protocol layer objects to object layer collection objects.
        /// </summary>
        internal static IList<ContainerRegistry> ConvertFromProtocolCollection(IEnumerable<Models.ContainerRegistry> protoCollection)
        {
            ConcurrentChangeTrackedModifiableList<ContainerRegistry> converted = UtilitiesInternal.CollectionToThreadSafeCollectionIModifiable(
                items: protoCollection,
                objectCreationFunc: o => new ContainerRegistry(o));

            return converted;
        }

        /// <summary>
        /// Converts a collection of protocol layer objects to object layer collection objects, in a frozen state.
        /// </summary>
        internal static IList<ContainerRegistry> ConvertFromProtocolCollectionAndFreeze(IEnumerable<Models.ContainerRegistry> protoCollection)
        {
            ConcurrentChangeTrackedModifiableList<ContainerRegistry> converted = UtilitiesInternal.CollectionToThreadSafeCollectionIModifiable(
                items: protoCollection,
                objectCreationFunc: o => new ContainerRegistry(o).Freeze());

            converted = UtilitiesInternal.CreateObjectWithNullCheck(converted, o => o.Freeze());

            return converted;
        }

        /// <summary>
        /// Converts a collection of protocol layer objects to object layer collection objects, with each object marked readonly
        /// and returned as a readonly collection.
        /// </summary>
        internal static IReadOnlyList<ContainerRegistry> ConvertFromProtocolCollectionReadOnly(IEnumerable<Models.ContainerRegistry> protoCollection)
        {
            IReadOnlyList<ContainerRegistry> converted =
                UtilitiesInternal.CreateObjectWithNullCheck(
                    UtilitiesInternal.CollectionToNonThreadSafeCollection(
                        items: protoCollection,
                        objectCreationFunc: o => new ContainerRegistry(o).Freeze()), o => o.AsReadOnly());

            return converted;
        }

        #endregion // Internal/private methods
    }
}