// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

//
// This file was autogenerated by a tool.
// Do not modify it.
//

namespace Microsoft.Azure.Batch
{
    using Models = Microsoft.Azure.Batch.Protocol.Models;
    using System;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// The entry of path and mount mode you want to mount into task container.
    /// </summary>
    public partial class ContainerHostBatchBindMountEntry : ITransportObjectProvider<Models.ContainerHostBatchBindMountEntry>, IPropertyMetadata
    {
        private class PropertyContainer : PropertyCollection
        {
            public readonly PropertyAccessor<bool?> IsReadOnlyProperty;
            public readonly PropertyAccessor<string> SourceProperty;

            public PropertyContainer() : base(BindingState.Unbound)
            {
                this.IsReadOnlyProperty = this.CreatePropertyAccessor<bool?>(nameof(IsReadOnly), BindingAccess.Read | BindingAccess.Write);
                this.SourceProperty = this.CreatePropertyAccessor<string>(nameof(Source), BindingAccess.Read | BindingAccess.Write);
            }

            public PropertyContainer(Models.ContainerHostBatchBindMountEntry protocolObject) : base(BindingState.Bound)
            {
                this.IsReadOnlyProperty = this.CreatePropertyAccessor(
                    protocolObject.IsReadOnly,
                    nameof(IsReadOnly),
                    BindingAccess.Read);
                this.SourceProperty = this.CreatePropertyAccessor(
                    protocolObject.Source,
                    nameof(Source),
                    BindingAccess.Read);
            }
        }

        private readonly PropertyContainer propertyContainer;

        #region Constructors

        /// <summary>
        /// Initializes a new instance of the <see cref="ContainerHostBatchBindMountEntry"/> class.
        /// </summary>
        public ContainerHostBatchBindMountEntry()
        {
            this.propertyContainer = new PropertyContainer();
        }

        internal ContainerHostBatchBindMountEntry(Models.ContainerHostBatchBindMountEntry protocolObject)
        {
            this.propertyContainer = new PropertyContainer(protocolObject);
        }

        #endregion Constructors

        #region ContainerHostBatchBindMountEntry

        /// <summary>
        /// Gets or sets gets or sets mount this source path as read-only mode or not. Default value is false (read/write 
        /// mode).
        /// </summary>
        /// <remarks>
        /// For Linux, if you mount this path as a read/write mode, this does not mean that all users in container have the 
        /// read/write access for the path, it depends on the access in host VM. If this path is mounted read-only, all users 
        /// within the container will not be able to modify the path.
        /// </remarks>
        public bool? IsReadOnly
        {
            get { return this.propertyContainer.IsReadOnlyProperty.Value; }
            set { this.propertyContainer.IsReadOnlyProperty.Value = value; }
        }

        /// <summary>
        /// Gets or sets gets or sets the path which be mounted to container customer can select.
        /// </summary>
        /// <remarks>
        /// Possible values include: 'Shared', 'Startup', 'VfsMounts', 'Task', 'JobPrep', 'Applications'
        /// </remarks>
        public string Source
        {
            get { return this.propertyContainer.SourceProperty.Value; }
            set { this.propertyContainer.SourceProperty.Value = value; }
        }

        #endregion // ContainerHostBatchBindMountEntry

        #region IPropertyMetadata

        bool IModifiable.HasBeenModified
        {
            get { return this.propertyContainer.HasBeenModified; }
        }

        bool IReadOnly.IsReadOnly
        {
            get { return this.propertyContainer.IsReadOnly; }
            set { this.propertyContainer.IsReadOnly = value; }
        }

        #endregion //IPropertyMetadata

        #region Internal/private methods
        /// <summary>
        /// Return a protocol object of the requested type.
        /// </summary>
        /// <returns>The protocol object of the requested type.</returns>
        Models.ContainerHostBatchBindMountEntry ITransportObjectProvider<Models.ContainerHostBatchBindMountEntry>.GetTransportObject()
        {
            Models.ContainerHostBatchBindMountEntry result = new Models.ContainerHostBatchBindMountEntry()
            {
                IsReadOnly = this.IsReadOnly,
                Source = this.Source,
            };

            return result;
        }

        /// <summary>
        /// Converts a collection of protocol layer objects to object layer collection objects.
        /// </summary>
        internal static IList<ContainerHostBatchBindMountEntry> ConvertFromProtocolCollection(IEnumerable<Models.ContainerHostBatchBindMountEntry> protoCollection)
        {
            ConcurrentChangeTrackedModifiableList<ContainerHostBatchBindMountEntry> converted = UtilitiesInternal.CollectionToThreadSafeCollectionIModifiable(
                items: protoCollection,
                objectCreationFunc: o => new ContainerHostBatchBindMountEntry(o));

            return converted;
        }

        /// <summary>
        /// Converts a collection of protocol layer objects to object layer collection objects, in a frozen state.
        /// </summary>
        internal static IList<ContainerHostBatchBindMountEntry> ConvertFromProtocolCollectionAndFreeze(IEnumerable<Models.ContainerHostBatchBindMountEntry> protoCollection)
        {
            ConcurrentChangeTrackedModifiableList<ContainerHostBatchBindMountEntry> converted = UtilitiesInternal.CollectionToThreadSafeCollectionIModifiable(
                items: protoCollection,
                objectCreationFunc: o => new ContainerHostBatchBindMountEntry(o).Freeze());

            converted = UtilitiesInternal.CreateObjectWithNullCheck(converted, o => o.Freeze());

            return converted;
        }

        /// <summary>
        /// Converts a collection of protocol layer objects to object layer collection objects, with each object marked readonly
        /// and returned as a readonly collection.
        /// </summary>
        internal static IReadOnlyList<ContainerHostBatchBindMountEntry> ConvertFromProtocolCollectionReadOnly(IEnumerable<Models.ContainerHostBatchBindMountEntry> protoCollection)
        {
            IReadOnlyList<ContainerHostBatchBindMountEntry> converted =
                UtilitiesInternal.CreateObjectWithNullCheck(
                    UtilitiesInternal.CollectionToNonThreadSafeCollection(
                        items: protoCollection,
                        objectCreationFunc: o => new ContainerHostBatchBindMountEntry(o).Freeze()), o => o.AsReadOnly());

            return converted;
        }

        #endregion // Internal/private methods
    }
}