// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

//
// This file was autogenerated by a tool.
// Do not modify it.
//

namespace Microsoft.Azure.Batch
{
    using Models = Microsoft.Azure.Batch.Protocol.Models;
    using System;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// The configuration for container-enabled pools.
    /// </summary>
    public partial class ContainerConfiguration : ITransportObjectProvider<Models.ContainerConfiguration>, IPropertyMetadata
    {
        private class PropertyContainer : PropertyCollection
        {
            public readonly PropertyAccessor<IList<string>> ContainerImageNamesProperty;
            public readonly PropertyAccessor<IList<ContainerRegistry>> ContainerRegistriesProperty;
            public readonly PropertyAccessor<string> TypeProperty;

            public PropertyContainer() : base(BindingState.Unbound)
            {
                this.ContainerImageNamesProperty = this.CreatePropertyAccessor<IList<string>>(nameof(ContainerImageNames), BindingAccess.Read | BindingAccess.Write);
                this.ContainerRegistriesProperty = this.CreatePropertyAccessor<IList<ContainerRegistry>>(nameof(ContainerRegistries), BindingAccess.Read | BindingAccess.Write);
                this.TypeProperty = this.CreatePropertyAccessor<string>(nameof(Type), BindingAccess.Read | BindingAccess.Write);
            }

            public PropertyContainer(Models.ContainerConfiguration protocolObject) : base(BindingState.Bound)
            {
                this.ContainerImageNamesProperty = this.CreatePropertyAccessor(
                    UtilitiesInternal.CollectionToThreadSafeCollection(protocolObject.ContainerImageNames, o => o),
                    nameof(ContainerImageNames),
                    BindingAccess.Read);
                this.ContainerRegistriesProperty = this.CreatePropertyAccessor(
                    ContainerRegistry.ConvertFromProtocolCollectionAndFreeze(protocolObject.ContainerRegistries),
                    nameof(ContainerRegistries),
                    BindingAccess.Read);
                this.TypeProperty = this.CreatePropertyAccessor(
                    protocolObject.Type,
                    nameof(Type),
                    BindingAccess.Read);
            }
        }

        private readonly PropertyContainer propertyContainer;

        #region Constructors

        /// <summary>
        /// Initializes a new instance of the <see cref="ContainerConfiguration"/> class.
        /// </summary>
        public ContainerConfiguration()
        {
            this.propertyContainer = new PropertyContainer();
        }

        internal ContainerConfiguration(Models.ContainerConfiguration protocolObject)
        {
            this.propertyContainer = new PropertyContainer(protocolObject);
        }

        #endregion Constructors

        #region ContainerConfiguration

        /// <summary>
        /// Gets or sets the collection of container images.
        /// </summary>
        /// <remarks>
        /// This is the full image reference, as would be specified to "docker pull". An image will be sourced from the default 
        /// Docker registry unless the image is fully qualified with an alternative registry.
        /// </remarks>
        public IList<string> ContainerImageNames
        {
            get { return this.propertyContainer.ContainerImageNamesProperty.Value; }
            set
            {
                this.propertyContainer.ContainerImageNamesProperty.Value = ConcurrentChangeTrackedList<string>.TransformEnumerableToConcurrentList(value);
            }
        }

        /// <summary>
        /// Gets or sets additional private registries which containers can be pulled from.
        /// </summary>
        /// <remarks>
        /// If any images must be downloaded from a private registry which requires credentials, then those credentials must 
        /// be provided here.
        /// </remarks>
        public IList<ContainerRegistry> ContainerRegistries
        {
            get { return this.propertyContainer.ContainerRegistriesProperty.Value; }
            set
            {
                this.propertyContainer.ContainerRegistriesProperty.Value = ConcurrentChangeTrackedModifiableList<ContainerRegistry>.TransformEnumerableToConcurrentModifiableList(value);
            }
        }

        /// <summary>
        /// Gets or sets the container technology to be used.
        /// </summary>
        public string Type
        {
            get { return this.propertyContainer.TypeProperty.Value; }
            set { this.propertyContainer.TypeProperty.Value = value; }
        }

        #endregion // ContainerConfiguration

        #region IPropertyMetadata

        bool IModifiable.HasBeenModified
        {
            get { return this.propertyContainer.HasBeenModified; }
        }

        bool IReadOnly.IsReadOnly
        {
            get { return this.propertyContainer.IsReadOnly; }
            set { this.propertyContainer.IsReadOnly = value; }
        }

        #endregion //IPropertyMetadata

        #region Internal/private methods
        /// <summary>
        /// Return a protocol object of the requested type.
        /// </summary>
        /// <returns>The protocol object of the requested type.</returns>
        Models.ContainerConfiguration ITransportObjectProvider<Models.ContainerConfiguration>.GetTransportObject()
        {
            Models.ContainerConfiguration result = new Models.ContainerConfiguration()
            {
                ContainerImageNames = this.ContainerImageNames,
                ContainerRegistries = UtilitiesInternal.ConvertToProtocolCollection(this.ContainerRegistries),
                Type = this.Type,
            };

            return result;
        }


        #endregion // Internal/private methods
    }
}