// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

//
// This file was autogenerated by a tool.
// Do not modify it.
//

namespace Microsoft.Azure.Batch
{
    using Models = Microsoft.Azure.Batch.Protocol.Models;
    using System;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// The reference to a user assigned identity associated with the Batch pool which a compute node will use.
    /// </summary>
    public partial class ComputeNodeIdentityReference : ITransportObjectProvider<Models.ComputeNodeIdentityReference>, IPropertyMetadata
    {
        private class PropertyContainer : PropertyCollection
        {
            public readonly PropertyAccessor<string> ResourceIdProperty;

            public PropertyContainer() : base(BindingState.Unbound)
            {
                this.ResourceIdProperty = this.CreatePropertyAccessor<string>(nameof(ResourceId), BindingAccess.Read | BindingAccess.Write);
            }

            public PropertyContainer(Models.ComputeNodeIdentityReference protocolObject) : base(BindingState.Bound)
            {
                this.ResourceIdProperty = this.CreatePropertyAccessor(
                    protocolObject.ResourceId,
                    nameof(ResourceId),
                    BindingAccess.Read);
            }
        }

        private readonly PropertyContainer propertyContainer;

        #region Constructors

        /// <summary>
        /// Initializes a new instance of the <see cref="ComputeNodeIdentityReference"/> class.
        /// </summary>
        public ComputeNodeIdentityReference()
        {
            this.propertyContainer = new PropertyContainer();
        }

        internal ComputeNodeIdentityReference(Models.ComputeNodeIdentityReference protocolObject)
        {
            this.propertyContainer = new PropertyContainer(protocolObject);
        }

        #endregion Constructors

        #region ComputeNodeIdentityReference

        /// <summary>
        /// Gets or sets the ARM resource id of the user assigned identity.
        /// </summary>
        public string ResourceId
        {
            get { return this.propertyContainer.ResourceIdProperty.Value; }
            set { this.propertyContainer.ResourceIdProperty.Value = value; }
        }

        #endregion // ComputeNodeIdentityReference

        #region IPropertyMetadata

        bool IModifiable.HasBeenModified
        {
            get { return this.propertyContainer.HasBeenModified; }
        }

        bool IReadOnly.IsReadOnly
        {
            get { return this.propertyContainer.IsReadOnly; }
            set { this.propertyContainer.IsReadOnly = value; }
        }

        #endregion //IPropertyMetadata

        #region Internal/private methods
        /// <summary>
        /// Return a protocol object of the requested type.
        /// </summary>
        /// <returns>The protocol object of the requested type.</returns>
        Models.ComputeNodeIdentityReference ITransportObjectProvider<Models.ComputeNodeIdentityReference>.GetTransportObject()
        {
            Models.ComputeNodeIdentityReference result = new Models.ComputeNodeIdentityReference()
            {
                ResourceId = this.ResourceId,
            };

            return result;
        }


        #endregion // Internal/private methods
    }
}