// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

//
// This file was autogenerated by a tool.
// Do not modify it.
//

namespace Microsoft.Azure.Batch
{
    using Models = Microsoft.Azure.Batch.Protocol.Models;
    using System;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// An error encountered by an Azure Batch compute node.
    /// </summary>
    public partial class ComputeNodeError : IPropertyMetadata
    {
        #region Constructors

        internal ComputeNodeError(Models.ComputeNodeError protocolObject)
        {
            this.Code = protocolObject.Code;
            this.ErrorDetails = NameValuePair.ConvertFromProtocolCollectionReadOnly(protocolObject.ErrorDetails);
            this.Message = protocolObject.Message;
        }

        #endregion Constructors

        #region ComputeNodeError

        /// <summary>
        /// Gets a code for the compute node error. See <see cref="Common.BatchErrorCodeStrings"/> for possible values.
        /// </summary>
        public string Code { get; }

        /// <summary>
        /// Gets a list of additional error details related to the compute node error.
        /// </summary>
        public IReadOnlyList<NameValuePair> ErrorDetails { get; }

        /// <summary>
        /// Gets a message describing the compute node error, intended to be suitable for display in a user interface.
        /// </summary>
        public string Message { get; }

        #endregion // ComputeNodeError

        #region IPropertyMetadata

        bool IModifiable.HasBeenModified
        {
            //This class is compile time readonly so it cannot have been modified
            get { return false; }
        }

        bool IReadOnly.IsReadOnly
        {
            get { return true; }
            set
            {
                // This class is compile time readonly already
            }
        }

        #endregion // IPropertyMetadata

        #region Internal/private methods


        /// <summary>
        /// Converts a collection of protocol layer objects to object layer collection objects.
        /// </summary>
        internal static IList<ComputeNodeError> ConvertFromProtocolCollection(IEnumerable<Models.ComputeNodeError> protoCollection)
        {
            ConcurrentChangeTrackedModifiableList<ComputeNodeError> converted = UtilitiesInternal.CollectionToThreadSafeCollectionIModifiable(
                items: protoCollection,
                objectCreationFunc: o => new ComputeNodeError(o));

            return converted;
        }

        /// <summary>
        /// Converts a collection of protocol layer objects to object layer collection objects, in a frozen state.
        /// </summary>
        internal static IList<ComputeNodeError> ConvertFromProtocolCollectionAndFreeze(IEnumerable<Models.ComputeNodeError> protoCollection)
        {
            ConcurrentChangeTrackedModifiableList<ComputeNodeError> converted = UtilitiesInternal.CollectionToThreadSafeCollectionIModifiable(
                items: protoCollection,
                objectCreationFunc: o => new ComputeNodeError(o).Freeze());

            converted = UtilitiesInternal.CreateObjectWithNullCheck(converted, o => o.Freeze());

            return converted;
        }

        /// <summary>
        /// Converts a collection of protocol layer objects to object layer collection objects, with each object marked readonly
        /// and returned as a readonly collection.
        /// </summary>
        internal static IReadOnlyList<ComputeNodeError> ConvertFromProtocolCollectionReadOnly(IEnumerable<Models.ComputeNodeError> protoCollection)
        {
            IReadOnlyList<ComputeNodeError> converted =
                UtilitiesInternal.CreateObjectWithNullCheck(
                    UtilitiesInternal.CollectionToNonThreadSafeCollection(
                        items: protoCollection,
                        objectCreationFunc: o => new ComputeNodeError(o).Freeze()), o => o.AsReadOnly());

            return converted;
        }

        #endregion // Internal/private methods
    }
}