// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

//
// This file was autogenerated by a tool.
// Do not modify it.
//

namespace Microsoft.Azure.Batch
{
    using Models = Microsoft.Azure.Batch.Protocol.Models;
    using System;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// A pool in the Azure Batch service.
    /// </summary>
    public partial class CloudPool : ITransportObjectProvider<Models.PoolAddParameter>, IInheritedBehaviors, IPropertyMetadata
    {
        private class PropertyContainer : PropertyCollection
        {
            public readonly PropertyAccessor<Common.AllocationState?> AllocationStateProperty;
            public readonly PropertyAccessor<DateTime?> AllocationStateTransitionTimeProperty;
            public readonly PropertyAccessor<IList<ApplicationPackageReference>> ApplicationPackageReferencesProperty;
            public readonly PropertyAccessor<bool?> AutoScaleEnabledProperty;
            public readonly PropertyAccessor<TimeSpan?> AutoScaleEvaluationIntervalProperty;
            public readonly PropertyAccessor<string> AutoScaleFormulaProperty;
            public readonly PropertyAccessor<AutoScaleRun> AutoScaleRunProperty;
            public readonly PropertyAccessor<IList<CertificateReference>> CertificateReferencesProperty;
            public readonly PropertyAccessor<DateTime?> CreationTimeProperty;
            public readonly PropertyAccessor<int?> CurrentDedicatedComputeNodesProperty;
            public readonly PropertyAccessor<int?> CurrentLowPriorityComputeNodesProperty;
            public readonly PropertyAccessor<Common.NodeCommunicationMode?> CurrentNodeCommunicationModeProperty;
            public readonly PropertyAccessor<string> DisplayNameProperty;
            public readonly PropertyAccessor<string> ETagProperty;
            public readonly PropertyAccessor<string> IdProperty;
            public readonly PropertyAccessor<BatchPoolIdentity> IdentityProperty;
            public readonly PropertyAccessor<bool?> InterComputeNodeCommunicationEnabledProperty;
            public readonly PropertyAccessor<DateTime?> LastModifiedProperty;
            public readonly PropertyAccessor<IList<MetadataItem>> MetadataProperty;
            public readonly PropertyAccessor<IList<MountConfiguration>> MountConfigurationProperty;
            public readonly PropertyAccessor<NetworkConfiguration> NetworkConfigurationProperty;
            public readonly PropertyAccessor<IReadOnlyList<ResizeError>> ResizeErrorsProperty;
            public readonly PropertyAccessor<TimeSpan?> ResizeTimeoutProperty;
            public readonly PropertyAccessor<IDictionary<string, string>> ResourceTagsProperty;
            public readonly PropertyAccessor<StartTask> StartTaskProperty;
            public readonly PropertyAccessor<Common.PoolState?> StateProperty;
            public readonly PropertyAccessor<DateTime?> StateTransitionTimeProperty;
            public readonly PropertyAccessor<PoolStatistics> StatisticsProperty;
            public readonly PropertyAccessor<int?> TargetDedicatedComputeNodesProperty;
            public readonly PropertyAccessor<int?> TargetLowPriorityComputeNodesProperty;
            public readonly PropertyAccessor<Common.NodeCommunicationMode?> TargetNodeCommunicationModeProperty;
            public readonly PropertyAccessor<TaskSchedulingPolicy> TaskSchedulingPolicyProperty;
            public readonly PropertyAccessor<int?> TaskSlotsPerNodeProperty;
            public readonly PropertyAccessor<UpgradePolicy> UpgradePolicyProperty;
            public readonly PropertyAccessor<string> UrlProperty;
            public readonly PropertyAccessor<IList<UserAccount>> UserAccountsProperty;
            public readonly PropertyAccessor<VirtualMachineConfiguration> VirtualMachineConfigurationProperty;
            public readonly PropertyAccessor<string> VirtualMachineSizeProperty;

            public PropertyContainer() : base(BindingState.Unbound)
            {
                this.AllocationStateProperty = this.CreatePropertyAccessor<Common.AllocationState?>(nameof(AllocationState), BindingAccess.None);
                this.AllocationStateTransitionTimeProperty = this.CreatePropertyAccessor<DateTime?>(nameof(AllocationStateTransitionTime), BindingAccess.None);
                this.ApplicationPackageReferencesProperty = this.CreatePropertyAccessor<IList<ApplicationPackageReference>>(nameof(ApplicationPackageReferences), BindingAccess.Read | BindingAccess.Write);
                this.AutoScaleEnabledProperty = this.CreatePropertyAccessor<bool?>(nameof(AutoScaleEnabled), BindingAccess.Read | BindingAccess.Write);
                this.AutoScaleEvaluationIntervalProperty = this.CreatePropertyAccessor<TimeSpan?>(nameof(AutoScaleEvaluationInterval), BindingAccess.Read | BindingAccess.Write);
                this.AutoScaleFormulaProperty = this.CreatePropertyAccessor<string>(nameof(AutoScaleFormula), BindingAccess.Read | BindingAccess.Write);
                this.AutoScaleRunProperty = this.CreatePropertyAccessor<AutoScaleRun>(nameof(AutoScaleRun), BindingAccess.None);
                this.CertificateReferencesProperty = this.CreatePropertyAccessor<IList<CertificateReference>>(nameof(CertificateReferences), BindingAccess.Read | BindingAccess.Write);
                this.CreationTimeProperty = this.CreatePropertyAccessor<DateTime?>(nameof(CreationTime), BindingAccess.None);
                this.CurrentDedicatedComputeNodesProperty = this.CreatePropertyAccessor<int?>(nameof(CurrentDedicatedComputeNodes), BindingAccess.None);
                this.CurrentLowPriorityComputeNodesProperty = this.CreatePropertyAccessor<int?>(nameof(CurrentLowPriorityComputeNodes), BindingAccess.None);
                this.CurrentNodeCommunicationModeProperty = this.CreatePropertyAccessor<Common.NodeCommunicationMode?>(nameof(CurrentNodeCommunicationMode), BindingAccess.None);
                this.DisplayNameProperty = this.CreatePropertyAccessor<string>(nameof(DisplayName), BindingAccess.Read | BindingAccess.Write);
                this.ETagProperty = this.CreatePropertyAccessor<string>(nameof(ETag), BindingAccess.None);
                this.IdProperty = this.CreatePropertyAccessor<string>(nameof(Id), BindingAccess.Read | BindingAccess.Write);
                this.IdentityProperty = this.CreatePropertyAccessor<BatchPoolIdentity>(nameof(Identity), BindingAccess.Read);
                this.InterComputeNodeCommunicationEnabledProperty = this.CreatePropertyAccessor<bool?>(nameof(InterComputeNodeCommunicationEnabled), BindingAccess.Read | BindingAccess.Write);
                this.LastModifiedProperty = this.CreatePropertyAccessor<DateTime?>(nameof(LastModified), BindingAccess.None);
                this.MetadataProperty = this.CreatePropertyAccessor<IList<MetadataItem>>(nameof(Metadata), BindingAccess.Read | BindingAccess.Write);
                this.MountConfigurationProperty = this.CreatePropertyAccessor<IList<MountConfiguration>>(nameof(MountConfiguration), BindingAccess.Read | BindingAccess.Write);
                this.NetworkConfigurationProperty = this.CreatePropertyAccessor<NetworkConfiguration>(nameof(NetworkConfiguration), BindingAccess.Read | BindingAccess.Write);
                this.ResizeErrorsProperty = this.CreatePropertyAccessor<IReadOnlyList<ResizeError>>(nameof(ResizeErrors), BindingAccess.None);
                this.ResizeTimeoutProperty = this.CreatePropertyAccessor<TimeSpan?>(nameof(ResizeTimeout), BindingAccess.Read | BindingAccess.Write);
                this.ResourceTagsProperty = this.CreatePropertyAccessor<IDictionary<string, string>>(nameof(ResourceTags), BindingAccess.Read | BindingAccess.Write);
                this.StartTaskProperty = this.CreatePropertyAccessor<StartTask>(nameof(StartTask), BindingAccess.Read | BindingAccess.Write);
                this.StateProperty = this.CreatePropertyAccessor<Common.PoolState?>(nameof(State), BindingAccess.None);
                this.StateTransitionTimeProperty = this.CreatePropertyAccessor<DateTime?>(nameof(StateTransitionTime), BindingAccess.None);
                this.StatisticsProperty = this.CreatePropertyAccessor<PoolStatistics>(nameof(Statistics), BindingAccess.None);
                this.TargetDedicatedComputeNodesProperty = this.CreatePropertyAccessor<int?>(nameof(TargetDedicatedComputeNodes), BindingAccess.Read | BindingAccess.Write);
                this.TargetLowPriorityComputeNodesProperty = this.CreatePropertyAccessor<int?>(nameof(TargetLowPriorityComputeNodes), BindingAccess.Read | BindingAccess.Write);
                this.TargetNodeCommunicationModeProperty = this.CreatePropertyAccessor<Common.NodeCommunicationMode?>(nameof(TargetNodeCommunicationMode), BindingAccess.Read | BindingAccess.Write);
                this.TaskSchedulingPolicyProperty = this.CreatePropertyAccessor<TaskSchedulingPolicy>(nameof(TaskSchedulingPolicy), BindingAccess.Read | BindingAccess.Write);
                this.TaskSlotsPerNodeProperty = this.CreatePropertyAccessor<int?>(nameof(TaskSlotsPerNode), BindingAccess.Read | BindingAccess.Write);
                this.UpgradePolicyProperty = this.CreatePropertyAccessor<UpgradePolicy>(nameof(UpgradePolicy), BindingAccess.Read | BindingAccess.Write);
                this.UrlProperty = this.CreatePropertyAccessor<string>(nameof(Url), BindingAccess.None);
                this.UserAccountsProperty = this.CreatePropertyAccessor<IList<UserAccount>>(nameof(UserAccounts), BindingAccess.Read | BindingAccess.Write);
                this.VirtualMachineConfigurationProperty = this.CreatePropertyAccessor<VirtualMachineConfiguration>(nameof(VirtualMachineConfiguration), BindingAccess.Read | BindingAccess.Write);
                this.VirtualMachineSizeProperty = this.CreatePropertyAccessor<string>(nameof(VirtualMachineSize), BindingAccess.Read | BindingAccess.Write);
            }

            public PropertyContainer(Models.CloudPool protocolObject) : base(BindingState.Bound)
            {
                this.AllocationStateProperty = this.CreatePropertyAccessor(
                    UtilitiesInternal.MapNullableEnum<Models.AllocationState, Common.AllocationState>(protocolObject.AllocationState),
                    nameof(AllocationState),
                    BindingAccess.Read);
                this.AllocationStateTransitionTimeProperty = this.CreatePropertyAccessor(
                    protocolObject.AllocationStateTransitionTime,
                    nameof(AllocationStateTransitionTime),
                    BindingAccess.Read);
                this.ApplicationPackageReferencesProperty = this.CreatePropertyAccessor(
                    ApplicationPackageReference.ConvertFromProtocolCollection(protocolObject.ApplicationPackageReferences),
                    nameof(ApplicationPackageReferences),
                    BindingAccess.Read | BindingAccess.Write);
                this.AutoScaleEnabledProperty = this.CreatePropertyAccessor(
                    protocolObject.EnableAutoScale,
                    nameof(AutoScaleEnabled),
                    BindingAccess.Read);
                this.AutoScaleEvaluationIntervalProperty = this.CreatePropertyAccessor(
                    protocolObject.AutoScaleEvaluationInterval,
                    nameof(AutoScaleEvaluationInterval),
                    BindingAccess.Read);
                this.AutoScaleFormulaProperty = this.CreatePropertyAccessor(
                    protocolObject.AutoScaleFormula,
                    nameof(AutoScaleFormula),
                    BindingAccess.Read);
                this.AutoScaleRunProperty = this.CreatePropertyAccessor(
                    UtilitiesInternal.CreateObjectWithNullCheck(protocolObject.AutoScaleRun, o => new AutoScaleRun(o).Freeze()),
                    nameof(AutoScaleRun),
                    BindingAccess.Read);
                this.CertificateReferencesProperty = this.CreatePropertyAccessor(
                    CertificateReference.ConvertFromProtocolCollection(protocolObject.CertificateReferences),
                    nameof(CertificateReferences),
                    BindingAccess.Read | BindingAccess.Write);
                this.CreationTimeProperty = this.CreatePropertyAccessor(
                    protocolObject.CreationTime,
                    nameof(CreationTime),
                    BindingAccess.Read);
                this.CurrentDedicatedComputeNodesProperty = this.CreatePropertyAccessor(
                    protocolObject.CurrentDedicatedNodes,
                    nameof(CurrentDedicatedComputeNodes),
                    BindingAccess.Read);
                this.CurrentLowPriorityComputeNodesProperty = this.CreatePropertyAccessor(
                    protocolObject.CurrentLowPriorityNodes,
                    nameof(CurrentLowPriorityComputeNodes),
                    BindingAccess.Read);
                this.CurrentNodeCommunicationModeProperty = this.CreatePropertyAccessor(
                    UtilitiesInternal.MapNullableEnum<Models.NodeCommunicationMode, Common.NodeCommunicationMode>(protocolObject.CurrentNodeCommunicationMode),
                    nameof(CurrentNodeCommunicationMode),
                    BindingAccess.Read);
                this.DisplayNameProperty = this.CreatePropertyAccessor(
                    protocolObject.DisplayName,
                    nameof(DisplayName),
                    BindingAccess.Read | BindingAccess.Write);
                this.ETagProperty = this.CreatePropertyAccessor(
                    protocolObject.ETag,
                    nameof(ETag),
                    BindingAccess.Read);
                this.IdProperty = this.CreatePropertyAccessor(
                    protocolObject.Id,
                    nameof(Id),
                    BindingAccess.Read);
                this.IdentityProperty = this.CreatePropertyAccessor(
                    UtilitiesInternal.CreateObjectWithNullCheck(protocolObject.Identity, o => new BatchPoolIdentity(o).Freeze()),
                    nameof(Identity),
                    BindingAccess.Read);
                this.InterComputeNodeCommunicationEnabledProperty = this.CreatePropertyAccessor(
                    protocolObject.EnableInterNodeCommunication,
                    nameof(InterComputeNodeCommunicationEnabled),
                    BindingAccess.Read | BindingAccess.Write);
                this.LastModifiedProperty = this.CreatePropertyAccessor(
                    protocolObject.LastModified,
                    nameof(LastModified),
                    BindingAccess.Read);
                this.MetadataProperty = this.CreatePropertyAccessor(
                    MetadataItem.ConvertFromProtocolCollection(protocolObject.Metadata),
                    nameof(Metadata),
                    BindingAccess.Read | BindingAccess.Write);
                this.MountConfigurationProperty = this.CreatePropertyAccessor(
                    Batch.MountConfiguration.ConvertFromProtocolCollectionAndFreeze(protocolObject.MountConfiguration),
                    nameof(MountConfiguration),
                    BindingAccess.Read | BindingAccess.Write);
                this.NetworkConfigurationProperty = this.CreatePropertyAccessor(
                    UtilitiesInternal.CreateObjectWithNullCheck(protocolObject.NetworkConfiguration, o => new NetworkConfiguration(o)),
                    nameof(NetworkConfiguration),
                    BindingAccess.Read | BindingAccess.Write);
                this.ResizeErrorsProperty = this.CreatePropertyAccessor(
                    ResizeError.ConvertFromProtocolCollectionReadOnly(protocolObject.ResizeErrors),
                    nameof(ResizeErrors),
                    BindingAccess.Read);
                this.ResizeTimeoutProperty = this.CreatePropertyAccessor(
                    protocolObject.ResizeTimeout,
                    nameof(ResizeTimeout),
                    BindingAccess.Read);
                this.ResourceTagsProperty = this.CreatePropertyAccessor(
                    protocolObject.ResourceTags,
                    nameof(ResourceTags),
                    BindingAccess.Read | BindingAccess.Write);
                this.StartTaskProperty = this.CreatePropertyAccessor(
                    UtilitiesInternal.CreateObjectWithNullCheck(protocolObject.StartTask, o => new StartTask(o)),
                    nameof(StartTask),
                    BindingAccess.Read | BindingAccess.Write);
                this.StateProperty = this.CreatePropertyAccessor(
                    UtilitiesInternal.MapNullableEnum<Models.PoolState, Common.PoolState>(protocolObject.State),
                    nameof(State),
                    BindingAccess.Read);
                this.StateTransitionTimeProperty = this.CreatePropertyAccessor(
                    protocolObject.StateTransitionTime,
                    nameof(StateTransitionTime),
                    BindingAccess.Read);
                this.StatisticsProperty = this.CreatePropertyAccessor(
                    UtilitiesInternal.CreateObjectWithNullCheck(protocolObject.Stats, o => new PoolStatistics(o).Freeze()),
                    nameof(Statistics),
                    BindingAccess.Read);
                this.TargetDedicatedComputeNodesProperty = this.CreatePropertyAccessor(
                    protocolObject.TargetDedicatedNodes,
                    nameof(TargetDedicatedComputeNodes),
                    BindingAccess.Read);
                this.TargetLowPriorityComputeNodesProperty = this.CreatePropertyAccessor(
                    protocolObject.TargetLowPriorityNodes,
                    nameof(TargetLowPriorityComputeNodes),
                    BindingAccess.Read);
                this.TargetNodeCommunicationModeProperty = this.CreatePropertyAccessor(
                    UtilitiesInternal.MapNullableEnum<Models.NodeCommunicationMode, Common.NodeCommunicationMode>(protocolObject.TargetNodeCommunicationMode),
                    nameof(TargetNodeCommunicationMode),
                    BindingAccess.Read | BindingAccess.Write);
                this.TaskSchedulingPolicyProperty = this.CreatePropertyAccessor(
                    UtilitiesInternal.CreateObjectWithNullCheck(protocolObject.TaskSchedulingPolicy, o => new TaskSchedulingPolicy(o)),
                    nameof(TaskSchedulingPolicy),
                    BindingAccess.Read | BindingAccess.Write);
                this.TaskSlotsPerNodeProperty = this.CreatePropertyAccessor(
                    protocolObject.TaskSlotsPerNode,
                    nameof(TaskSlotsPerNode),
                    BindingAccess.Read | BindingAccess.Write);
                this.UpgradePolicyProperty = this.CreatePropertyAccessor(
                    UtilitiesInternal.CreateObjectWithNullCheck(protocolObject.UpgradePolicy, o => new UpgradePolicy(o)),
                    nameof(UpgradePolicy),
                    BindingAccess.Read | BindingAccess.Write);
                this.UrlProperty = this.CreatePropertyAccessor(
                    protocolObject.Url,
                    nameof(Url),
                    BindingAccess.Read);
                this.UserAccountsProperty = this.CreatePropertyAccessor(
                    UserAccount.ConvertFromProtocolCollection(protocolObject.UserAccounts),
                    nameof(UserAccounts),
                    BindingAccess.Read | BindingAccess.Write);
                this.VirtualMachineConfigurationProperty = this.CreatePropertyAccessor(
                    UtilitiesInternal.CreateObjectWithNullCheck(protocolObject.VirtualMachineConfiguration, o => new VirtualMachineConfiguration(o)),
                    nameof(VirtualMachineConfiguration),
                    BindingAccess.Read | BindingAccess.Write);
                this.VirtualMachineSizeProperty = this.CreatePropertyAccessor(
                    protocolObject.VmSize,
                    nameof(VirtualMachineSize),
                    BindingAccess.Read | BindingAccess.Write);
            }
        }

        private PropertyContainer propertyContainer;

        private readonly BatchClient parentBatchClient;

        #region Constructors

        /// <summary>
        /// Initializes a new instance of the <see cref="CloudPool"/> class.
        /// </summary>
        /// <param name='parentBatchClient'>The parent <see cref="BatchClient"/> to use.</param>
        /// <param name='baseBehaviors'>The base behaviors to use.</param>
        internal CloudPool(
            BatchClient parentBatchClient,
            IEnumerable<BatchClientBehavior> baseBehaviors)
        {
            this.propertyContainer = new PropertyContainer();
            this.parentBatchClient = parentBatchClient;
            InheritUtil.InheritClientBehaviorsAndSetPublicProperty(this, baseBehaviors);
        }

        /// <summary>
        /// Default constructor to support mocking the <see cref="CloudPool"/> class.
        /// </summary>
        protected CloudPool()
        {
            this.propertyContainer = new PropertyContainer();
        }

        internal CloudPool(
            BatchClient parentBatchClient,
            Models.CloudPool protocolObject,
            IEnumerable<BatchClientBehavior> baseBehaviors)
        {
            this.parentBatchClient = parentBatchClient;
            InheritUtil.InheritClientBehaviorsAndSetPublicProperty(this, baseBehaviors);
            this.propertyContainer = new PropertyContainer(protocolObject);
        }

        #endregion Constructors

        #region IInheritedBehaviors

        /// <summary>
        /// Gets or sets a list of behaviors that modify or customize requests to the Batch service
        /// made via this <see cref="CloudPool"/>.
        /// </summary>
        /// <remarks>
        /// <para>These behaviors are inherited by child objects.</para>
        /// <para>Modifications are applied in the order of the collection. The last write wins.</para>
        /// </remarks>
        public IList<BatchClientBehavior> CustomBehaviors { get; set; }

        #endregion IInheritedBehaviors

        #region CloudPool

        /// <summary>
        /// Gets an <see cref="Common.AllocationState"/> which indicates what node allocation activity is occurring on the 
        /// pool.
        /// </summary>
        public Common.AllocationState? AllocationState
        {
            get { return this.propertyContainer.AllocationStateProperty.Value; }
        }

        /// <summary>
        /// Gets the time at which the pool entered its current <see cref="AllocationState"/>.
        /// </summary>
        public DateTime? AllocationStateTransitionTime
        {
            get { return this.propertyContainer.AllocationStateTransitionTimeProperty.Value; }
        }

        /// <summary>
        /// Gets or sets a list of application packages to be installed on each compute node in the pool.
        /// </summary>
        /// <remarks>
        /// Changes to application package references affect all new compute nodes joining the pool, but do not affect compute 
        /// nodes that are already in the pool until they are rebooted or reimaged. There is a maximum of 10 application 
        /// package references on any given pool.
        /// </remarks>
        public IList<ApplicationPackageReference> ApplicationPackageReferences
        {
            get { return this.propertyContainer.ApplicationPackageReferencesProperty.Value; }
            set
            {
                this.propertyContainer.ApplicationPackageReferencesProperty.Value = ConcurrentChangeTrackedModifiableList<ApplicationPackageReference>.TransformEnumerableToConcurrentModifiableList(value);
            }
        }

        /// <summary>
        /// Gets or sets whether the pool size should automatically adjust according to the <see cref="AutoScaleFormula"/>.
        /// </summary>
        /// <remarks>
        /// <para>If true, the <see cref="AutoScaleFormula"/> property is required, the pool automatically resizes according 
        /// to the formula, and <see cref="TargetDedicatedComputeNodes"/> and <see cref="TargetLowPriorityComputeNodes"/> 
        /// must be null.</para> <para>If false, one of the <see cref="TargetDedicatedComputeNodes"/> or <see cref="TargetLowPriorityComputeNodes"/> 
        /// properties is required.</para><para>The default value is false.</para>
        /// </remarks>
        public bool? AutoScaleEnabled
        {
            get { return this.propertyContainer.AutoScaleEnabledProperty.Value; }
            set { this.propertyContainer.AutoScaleEnabledProperty.Value = value; }
        }

        /// <summary>
        /// Gets or sets a time interval at which to automatically adjust the pool size according to the <see cref="AutoScaleFormula"/>.
        /// </summary>
        /// <remarks>
        /// The default value is 15 minutes. The minimum allowed value is 5 minutes.
        /// </remarks>
        public TimeSpan? AutoScaleEvaluationInterval
        {
            get { return this.propertyContainer.AutoScaleEvaluationIntervalProperty.Value; }
            set { this.propertyContainer.AutoScaleEvaluationIntervalProperty.Value = value; }
        }

        /// <summary>
        /// Gets or sets a formula for the desired number of compute nodes in the pool.
        /// </summary>
        /// <remarks>
        /// <para>For how to write autoscale formulas, see https://azure.microsoft.com/documentation/articles/batch-automatic-scaling/. 
        /// This property is required if <see cref="AutoScaleEnabled"/> is set to true. It must be null if AutoScaleEnabled 
        /// is false.</para><para>The formula is checked for validity before the pool is created. If the formula is not valid, 
        /// an exception is thrown when you try to commit the <see cref="CloudPool"/>.</para>
        /// </remarks>
        public string AutoScaleFormula
        {
            get { return this.propertyContainer.AutoScaleFormulaProperty.Value; }
            set { this.propertyContainer.AutoScaleFormulaProperty.Value = value; }
        }

        /// <summary>
        /// Gets the results and errors from the last execution of the <see cref="AutoScaleFormula"/>.
        /// </summary>
        public AutoScaleRun AutoScaleRun
        {
            get { return this.propertyContainer.AutoScaleRunProperty.Value; }
        }

        /// <summary>
        /// Gets or sets a list of certificates to be installed on each compute node in the pool.
        /// </summary>
        public IList<CertificateReference> CertificateReferences
        {
            get { return this.propertyContainer.CertificateReferencesProperty.Value; }
            set
            {
                this.propertyContainer.CertificateReferencesProperty.Value = ConcurrentChangeTrackedModifiableList<CertificateReference>.TransformEnumerableToConcurrentModifiableList(value);
            }
        }

        /// <summary>
        /// Gets the creation time for the pool.
        /// </summary>
        public DateTime? CreationTime
        {
            get { return this.propertyContainer.CreationTimeProperty.Value; }
        }

        /// <summary>
        /// Gets the number of dedicated compute nodes currently in the pool.
        /// </summary>
        public int? CurrentDedicatedComputeNodes
        {
            get { return this.propertyContainer.CurrentDedicatedComputeNodesProperty.Value; }
        }

        /// <summary>
        /// Gets the number of low-priority compute nodes currently in the pool.
        /// </summary>
        /// <remarks>
        /// Low-priority compute nodes which have been preempted are included in this count.
        /// </remarks>
        public int? CurrentLowPriorityComputeNodes
        {
            get { return this.propertyContainer.CurrentLowPriorityComputeNodesProperty.Value; }
        }

        /// <summary>
        /// Gets the current state of the pool communication mode.
        /// </summary>
        public Common.NodeCommunicationMode? CurrentNodeCommunicationMode
        {
            get { return this.propertyContainer.CurrentNodeCommunicationModeProperty.Value; }
        }

        /// <summary>
        /// Gets or sets the display name of the pool.
        /// </summary>
        public string DisplayName
        {
            get { return this.propertyContainer.DisplayNameProperty.Value; }
            set { this.propertyContainer.DisplayNameProperty.Value = value; }
        }

        /// <summary>
        /// Gets the ETag for the pool.
        /// </summary>
        public string ETag
        {
            get { return this.propertyContainer.ETagProperty.Value; }
        }

        /// <summary>
        /// Gets or sets the id of the pool.
        /// </summary>
        public string Id
        {
            get { return this.propertyContainer.IdProperty.Value; }
            set { this.propertyContainer.IdProperty.Value = value; }
        }

        /// <summary>
        /// Gets the identity of the Batch pool, if configured.
        /// </summary>
        /// <remarks>
        /// The list of user identities associated with the Batch pool. The user identity dictionary key references will 
        /// be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        /// </remarks>
        public BatchPoolIdentity Identity
        {
            get { return this.propertyContainer.IdentityProperty.Value; }
        }

        /// <summary>
        /// Gets or sets whether the pool permits direct communication between its compute nodes.
        /// </summary>
        /// <remarks>
        /// Enabling inter-node communication limits the maximum size of the pool due to deployment restrictions on the nodes 
        /// of the pool. This may result in the pool not reaching its desired size.
        /// </remarks>
        public bool? InterComputeNodeCommunicationEnabled
        {
            get { return this.propertyContainer.InterComputeNodeCommunicationEnabledProperty.Value; }
            set { this.propertyContainer.InterComputeNodeCommunicationEnabledProperty.Value = value; }
        }

        /// <summary>
        /// Gets the last modified time of the pool.
        /// </summary>
        public DateTime? LastModified
        {
            get { return this.propertyContainer.LastModifiedProperty.Value; }
        }

        /// <summary>
        /// Gets or sets a list of name-value pairs associated with the pool as metadata.
        /// </summary>
        public IList<MetadataItem> Metadata
        {
            get { return this.propertyContainer.MetadataProperty.Value; }
            set
            {
                this.propertyContainer.MetadataProperty.Value = ConcurrentChangeTrackedModifiableList<MetadataItem>.TransformEnumerableToConcurrentModifiableList(value);
            }
        }

        /// <summary>
        /// Gets or sets a list of file systems to mount on each node in the pool.
        /// </summary>
        /// <remarks>
        /// This supports Azure Files, NFS, CIFS/SMB, and Blobfuse.
        /// </remarks>
        public IList<MountConfiguration> MountConfiguration
        {
            get { return this.propertyContainer.MountConfigurationProperty.Value; }
            set
            {
                this.propertyContainer.MountConfigurationProperty.Value = ConcurrentChangeTrackedModifiableList<MountConfiguration>.TransformEnumerableToConcurrentModifiableList(value);
            }
        }

        /// <summary>
        /// Gets or sets the network configuration of the pool.
        /// </summary>
        public NetworkConfiguration NetworkConfiguration
        {
            get { return this.propertyContainer.NetworkConfigurationProperty.Value; }
            set { this.propertyContainer.NetworkConfigurationProperty.Value = value; }
        }

        /// <summary>
        /// Gets a list of errors encountered while performing the last resize on the <see cref="CloudPool"/>. Errors are 
        /// returned only when the Batch service encountered an error while resizing the pool, and when the pool's <see cref="CloudPool.AllocationState"/> 
        /// is <see cref="Common.AllocationState.Steady">Steady</see>.
        /// </summary>
        public IReadOnlyList<ResizeError> ResizeErrors
        {
            get { return this.propertyContainer.ResizeErrorsProperty.Value; }
        }

        /// <summary>
        /// Gets or sets the timeout for allocation of compute nodes to the pool.
        /// </summary>
        public TimeSpan? ResizeTimeout
        {
            get { return this.propertyContainer.ResizeTimeoutProperty.Value; }
            set { this.propertyContainer.ResizeTimeoutProperty.Value = value; }
        }

        /// <summary>
        /// Gets or sets the user-specified tags associated with the pool.
        /// </summary>
        /// <remarks>
        /// The user-defined tags to be associated with the Azure Batch Pool. When specified, these tags are propagated to 
        /// the backing Azure resources associated with the pool. This property can only be specified when the Batch account 
        /// was created with the poolAllocationMode property set to 'UserSubscription'.
        /// </remarks>
        public IDictionary<string, string> ResourceTags
        {
            get { return this.propertyContainer.ResourceTagsProperty.Value; }
            set { this.propertyContainer.ResourceTagsProperty.Value = value; }
        }

        /// <summary>
        /// Gets or sets a task to run on each compute node as it joins the pool. The task runs when the node is added to 
        /// the pool or when the node is restarted.
        /// </summary>
        public StartTask StartTask
        {
            get { return this.propertyContainer.StartTaskProperty.Value; }
            set { this.propertyContainer.StartTaskProperty.Value = value; }
        }

        /// <summary>
        /// Gets the current state of the pool.
        /// </summary>
        public Common.PoolState? State
        {
            get { return this.propertyContainer.StateProperty.Value; }
        }

        /// <summary>
        /// Gets the time at which the pool entered its current state.
        /// </summary>
        public DateTime? StateTransitionTime
        {
            get { return this.propertyContainer.StateTransitionTimeProperty.Value; }
        }

        /// <summary>
        /// Gets the resource usage statistics for the pool.
        /// </summary>
        /// <remarks>
        /// This property is populated only if the <see cref="CloudPool"/> was retrieved with an <see cref="ODATADetailLevel.ExpandClause"/> 
        /// including the 'stats' attribute; otherwise it is null. The statistics may not be immediately available. The Batch 
        /// service performs periodic roll-up of statistics. The typical delay is about 30 minutes.
        /// </remarks>
        public PoolStatistics Statistics
        {
            get { return this.propertyContainer.StatisticsProperty.Value; }
        }

        /// <summary>
        /// Gets or sets the desired number of dedicated compute nodes in the pool.
        /// </summary>
        /// <remarks>
        /// This setting cannot be specified if <see cref="AutoScaleEnabled"/> is set to true. At least one of this property 
        /// and <see cref="TargetLowPriorityComputeNodes"/> must be specified if <see cref="AutoScaleEnabled"/> is false. 
        /// If not specified, the default is 0.
        /// </remarks>
        public int? TargetDedicatedComputeNodes
        {
            get { return this.propertyContainer.TargetDedicatedComputeNodesProperty.Value; }
            set { this.propertyContainer.TargetDedicatedComputeNodesProperty.Value = value; }
        }

        /// <summary>
        /// Gets or sets the desired number of low-priority compute nodes in the pool.
        /// </summary>
        /// <remarks>
        /// This setting cannot be specified if <see cref="AutoScaleEnabled"/> is set to true. At least one of <see cref="TargetDedicatedComputeNodes"/> 
        /// and this property must be specified if <see cref="AutoScaleEnabled"/> is false. If not specified, the default 
        /// is 0.
        /// </remarks>
        public int? TargetLowPriorityComputeNodes
        {
            get { return this.propertyContainer.TargetLowPriorityComputeNodesProperty.Value; }
            set { this.propertyContainer.TargetLowPriorityComputeNodesProperty.Value = value; }
        }

        /// <summary>
        /// Gets or sets the desired node communication mode for the pool.
        /// </summary>
        /// <remarks>
        /// If omitted, the default value is default.
        /// </remarks>
        public Common.NodeCommunicationMode? TargetNodeCommunicationMode
        {
            get { return this.propertyContainer.TargetNodeCommunicationModeProperty.Value; }
            set { this.propertyContainer.TargetNodeCommunicationModeProperty.Value = value; }
        }

        /// <summary>
        /// Gets or sets how tasks are distributed among compute nodes in the pool.
        /// </summary>
        public TaskSchedulingPolicy TaskSchedulingPolicy
        {
            get { return this.propertyContainer.TaskSchedulingPolicyProperty.Value; }
            set { this.propertyContainer.TaskSchedulingPolicyProperty.Value = value; }
        }

        /// <summary>
        /// Gets or sets the number of task slots that can be used to run concurrent tasks on a single compute node in the 
        /// pool.
        /// </summary>
        /// <remarks>
        /// The default value is 1. The maximum value is the smaller of 4 times the number of cores of the <see cref="VirtualMachineSize"/> 
        /// of the pool or 256.
        /// </remarks>
        public int? TaskSlotsPerNode
        {
            get { return this.propertyContainer.TaskSlotsPerNodeProperty.Value; }
            set { this.propertyContainer.TaskSlotsPerNodeProperty.Value = value; }
        }

        /// <summary>
        /// Gets or sets the upgrade policy for the pool.
        /// </summary>
        public UpgradePolicy UpgradePolicy
        {
            get { return this.propertyContainer.UpgradePolicyProperty.Value; }
            set { this.propertyContainer.UpgradePolicyProperty.Value = value; }
        }

        /// <summary>
        /// Gets the URL of the pool.
        /// </summary>
        public string Url
        {
            get { return this.propertyContainer.UrlProperty.Value; }
        }

        /// <summary>
        /// Gets or sets the list of user accounts to be created on each node in the pool.
        /// </summary>
        public IList<UserAccount> UserAccounts
        {
            get { return this.propertyContainer.UserAccountsProperty.Value; }
            set
            {
                this.propertyContainer.UserAccountsProperty.Value = ConcurrentChangeTrackedModifiableList<UserAccount>.TransformEnumerableToConcurrentModifiableList(value);
            }
        }

        /// <summary>
        /// Gets or sets the <see cref="VirtualMachineConfiguration"/> of the pool.
        /// </summary>
        public VirtualMachineConfiguration VirtualMachineConfiguration
        {
            get { return this.propertyContainer.VirtualMachineConfigurationProperty.Value; }
            set { this.propertyContainer.VirtualMachineConfigurationProperty.Value = value; }
        }

        /// <summary>
        /// Gets or sets the size of the virtual machines in the pool.  All virtual machines in a pool are the same size.
        /// </summary>
        /// <remarks>
        /// <para>For information about available sizes of virtual machines in pools, see Choose a VM size for compute nodes 
        /// in an Azure Batch pool (https://docs.microsoft.com/azure/batch/batch-pool-vm-sizes).</para>
        /// </remarks>
        public string VirtualMachineSize
        {
            get { return this.propertyContainer.VirtualMachineSizeProperty.Value; }
            set { this.propertyContainer.VirtualMachineSizeProperty.Value = value; }
        }

        #endregion // CloudPool

        #region IPropertyMetadata

        bool IModifiable.HasBeenModified
        {
            get { return this.propertyContainer.HasBeenModified; }
        }

        bool IReadOnly.IsReadOnly
        {
            get { return this.propertyContainer.IsReadOnly; }
            set { this.propertyContainer.IsReadOnly = value; }
        }

        #endregion //IPropertyMetadata

        #region Internal/private methods
        /// <summary>
        /// Return a protocol object of the requested type.
        /// </summary>
        /// <returns>The protocol object of the requested type.</returns>
        Models.PoolAddParameter ITransportObjectProvider<Models.PoolAddParameter>.GetTransportObject()
        {
            Models.PoolAddParameter result = new Models.PoolAddParameter()
            {
                ApplicationPackageReferences = UtilitiesInternal.ConvertToProtocolCollection(this.ApplicationPackageReferences),
                EnableAutoScale = this.AutoScaleEnabled,
                AutoScaleEvaluationInterval = this.AutoScaleEvaluationInterval,
                AutoScaleFormula = this.AutoScaleFormula,
                CertificateReferences = UtilitiesInternal.ConvertToProtocolCollection(this.CertificateReferences),
                DisplayName = this.DisplayName,
                Id = this.Id,
                EnableInterNodeCommunication = this.InterComputeNodeCommunicationEnabled,
                Metadata = UtilitiesInternal.ConvertToProtocolCollection(this.Metadata),
                MountConfiguration = UtilitiesInternal.ConvertToProtocolCollection(this.MountConfiguration),
                NetworkConfiguration = UtilitiesInternal.CreateObjectWithNullCheck(this.NetworkConfiguration, (o) => o.GetTransportObject()),
                ResizeTimeout = this.ResizeTimeout,
                ResourceTags = this.ResourceTags,
                StartTask = UtilitiesInternal.CreateObjectWithNullCheck(this.StartTask, (o) => o.GetTransportObject()),
                TargetDedicatedNodes = this.TargetDedicatedComputeNodes,
                TargetLowPriorityNodes = this.TargetLowPriorityComputeNodes,
                TargetNodeCommunicationMode = UtilitiesInternal.MapNullableEnum<Common.NodeCommunicationMode, Models.NodeCommunicationMode>(this.TargetNodeCommunicationMode),
                TaskSchedulingPolicy = UtilitiesInternal.CreateObjectWithNullCheck(this.TaskSchedulingPolicy, (o) => o.GetTransportObject()),
                TaskSlotsPerNode = this.TaskSlotsPerNode,
                UpgradePolicy = UtilitiesInternal.CreateObjectWithNullCheck(this.UpgradePolicy, (o) => o.GetTransportObject()),
                UserAccounts = UtilitiesInternal.ConvertToProtocolCollection(this.UserAccounts),
                VirtualMachineConfiguration = UtilitiesInternal.CreateObjectWithNullCheck(this.VirtualMachineConfiguration, (o) => o.GetTransportObject()),
                VmSize = this.VirtualMachineSize,
            };

            return result;
        }


        #endregion // Internal/private methods
    }
}