// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

//
// This file was autogenerated by a tool.
// Do not modify it.
//

namespace Microsoft.Azure.Batch
{
    using Models = Microsoft.Azure.Batch.Protocol.Models;
    using System;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// The identity of the Batch pool, if configured.
    /// </summary>
    public partial class BatchPoolIdentity : ITransportObjectProvider<Models.BatchPoolIdentity>, IPropertyMetadata
    {
        private class PropertyContainer : PropertyCollection
        {
            public readonly PropertyAccessor<Common.PoolIdentityType> TypeProperty;
            public readonly PropertyAccessor<IList<UserAssignedIdentity>> UserAssignedIdentitiesProperty;

            public PropertyContainer() : base(BindingState.Unbound)
            {
                this.TypeProperty = this.CreatePropertyAccessor<Common.PoolIdentityType>(nameof(Type), BindingAccess.Read | BindingAccess.Write);
                this.UserAssignedIdentitiesProperty = this.CreatePropertyAccessor<IList<UserAssignedIdentity>>(nameof(UserAssignedIdentities), BindingAccess.Read | BindingAccess.Write);
            }

            public PropertyContainer(Models.BatchPoolIdentity protocolObject) : base(BindingState.Bound)
            {
                this.TypeProperty = this.CreatePropertyAccessor(
                    UtilitiesInternal.MapEnum<Models.PoolIdentityType, Common.PoolIdentityType>(protocolObject.Type),
                    nameof(Type),
                    BindingAccess.Read);
                this.UserAssignedIdentitiesProperty = this.CreatePropertyAccessor(
                    UserAssignedIdentity.ConvertFromProtocolCollectionAndFreeze(protocolObject.UserAssignedIdentities),
                    nameof(UserAssignedIdentities),
                    BindingAccess.Read);
            }
        }

        private readonly PropertyContainer propertyContainer;

        #region Constructors

        /// <summary>
        /// Initializes a new instance of the <see cref="BatchPoolIdentity"/> class.
        /// </summary>
        /// <param name='type'>The identity of the Batch pool, if configured.</param>
        internal BatchPoolIdentity(
            Common.PoolIdentityType type)
        {
            this.propertyContainer = new PropertyContainer();
            this.Type = type;
        }

        /// <summary>
        /// Default constructor to support mocking the <see cref="BatchPoolIdentity"/> class.
        /// </summary>
        protected BatchPoolIdentity()
        {
            this.propertyContainer = new PropertyContainer();
        }

        internal BatchPoolIdentity(Models.BatchPoolIdentity protocolObject)
        {
            this.propertyContainer = new PropertyContainer(protocolObject);
        }

        #endregion Constructors

        #region BatchPoolIdentity

        /// <summary>
        /// Gets or sets the identity of the Batch pool, if configured.
        /// </summary>
        /// <remarks>
        /// The list of user identities associated with the Batch pool. The user identity dictionary key references will 
        /// be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        /// </remarks>
        public Common.PoolIdentityType Type
        {
            get { return this.propertyContainer.TypeProperty.Value; }
            set { this.propertyContainer.TypeProperty.Value = value; }
        }

        /// <summary>
        /// Gets or sets the list of user identities associated with the Batch account.
        /// </summary>
        /// <remarks>
        /// The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        /// </remarks>
        public IList<UserAssignedIdentity> UserAssignedIdentities
        {
            get { return this.propertyContainer.UserAssignedIdentitiesProperty.Value; }
            set
            {
                this.propertyContainer.UserAssignedIdentitiesProperty.Value = ConcurrentChangeTrackedModifiableList<UserAssignedIdentity>.TransformEnumerableToConcurrentModifiableList(value);
            }
        }

        #endregion // BatchPoolIdentity

        #region IPropertyMetadata

        bool IModifiable.HasBeenModified
        {
            get { return this.propertyContainer.HasBeenModified; }
        }

        bool IReadOnly.IsReadOnly
        {
            get { return this.propertyContainer.IsReadOnly; }
            set { this.propertyContainer.IsReadOnly = value; }
        }

        #endregion //IPropertyMetadata

        #region Internal/private methods
        /// <summary>
        /// Return a protocol object of the requested type.
        /// </summary>
        /// <returns>The protocol object of the requested type.</returns>
        Models.BatchPoolIdentity ITransportObjectProvider<Models.BatchPoolIdentity>.GetTransportObject()
        {
            Models.BatchPoolIdentity result = new Models.BatchPoolIdentity()
            {
                Type = UtilitiesInternal.MapEnum<Common.PoolIdentityType, Models.PoolIdentityType>(this.Type),
                UserAssignedIdentities = UtilitiesInternal.ConvertToProtocolCollection(this.UserAssignedIdentities),
            };

            return result;
        }


        #endregion // Internal/private methods
    }
}