// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

//
// This file was autogenerated by a tool.
// Do not modify it.
//

namespace Microsoft.Azure.Batch
{
    using Models = Microsoft.Azure.Batch.Protocol.Models;
    using System;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// Information used to connect to an Azure Fileshare.
    /// </summary>
    public partial class AzureFileShareConfiguration : ITransportObjectProvider<Models.AzureFileShareConfiguration>, IPropertyMetadata
    {
        #region Constructors
        /// <summary>
        /// Initializes a new instance of the <see cref="AzureFileShareConfiguration"/> class.
        /// </summary>
        /// <param name='accountName'>The Azure Storage Account name.</param>
        /// <param name='azureFileUrl'>The Azure Files URL.</param>
        /// <param name='relativeMountPath'>The relative path on the compute node where the file system will be mounted.</param>
        /// <param name='accountKey'>The Azure Storage Account key.</param>
        /// <param name='mountOptions'>Additional command line options to pass to the mount command.</param>
        public AzureFileShareConfiguration(
            string accountName,
            string azureFileUrl,
            string relativeMountPath,
            string accountKey,
            string mountOptions = default(string))
        {
            this.AccountName = accountName;
            this.AzureFileUrl = azureFileUrl;
            this.RelativeMountPath = relativeMountPath;
            this.AccountKey = accountKey;
            this.MountOptions = mountOptions;
        }

        internal AzureFileShareConfiguration(Models.AzureFileShareConfiguration protocolObject)
        {
            this.AccountKey = protocolObject.AccountKey;
            this.AccountName = protocolObject.AccountName;
            this.AzureFileUrl = protocolObject.AzureFileUrl;
            this.MountOptions = protocolObject.MountOptions;
            this.RelativeMountPath = protocolObject.RelativeMountPath;
        }

        #endregion Constructors

        #region AzureFileShareConfiguration

        /// <summary>
        /// Gets the Azure Storage Account key.
        /// </summary>
        public string AccountKey { get; }

        /// <summary>
        /// Gets the Azure Storage Account name.
        /// </summary>
        public string AccountName { get; }

        /// <summary>
        /// Gets the Azure Files URL.
        /// </summary>
        /// <remarks>
        /// This is of the form 'https://myaccount.file.core.windows.net/'.
        /// </remarks>
        public string AzureFileUrl { get; }

        /// <summary>
        /// Gets additional command line options to pass to the mount command.
        /// </summary>
        /// <remarks>
        /// These are 'net use' options in Windows and 'mount' options in Linux.
        /// </remarks>
        public string MountOptions { get; }

        /// <summary>
        /// Gets the relative path on the compute node where the file system will be mounted.
        /// </summary>
        /// <remarks>
        /// All file systems are mounted relative to the Batch mounts directory, accessible via the AZ_BATCH_NODE_MOUNTS_DIR 
        /// environment variable.
        /// </remarks>
        public string RelativeMountPath { get; }

        #endregion // AzureFileShareConfiguration

        #region IPropertyMetadata

        bool IModifiable.HasBeenModified
        {
            //This class is compile time readonly so it cannot have been modified
            get { return false; }
        }

        bool IReadOnly.IsReadOnly
        {
            get { return true; }
            set
            {
                // This class is compile time readonly already
            }
        }

        #endregion // IPropertyMetadata

        #region Internal/private methods

        /// <summary>
        /// Return a protocol object of the requested type.
        /// </summary>
        /// <returns>The protocol object of the requested type.</returns>
        Models.AzureFileShareConfiguration ITransportObjectProvider<Models.AzureFileShareConfiguration>.GetTransportObject()
        {
            Models.AzureFileShareConfiguration result = new Models.AzureFileShareConfiguration()
            {
                AccountKey = this.AccountKey,
                AccountName = this.AccountName,
                AzureFileUrl = this.AzureFileUrl,
                MountOptions = this.MountOptions,
                RelativeMountPath = this.RelativeMountPath,
            };

            return result;
        }


        #endregion // Internal/private methods
    }
}