// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

//
// This file was autogenerated by a tool.
// Do not modify it.
//

namespace Microsoft.Azure.Batch
{
    using Models = Microsoft.Azure.Batch.Protocol.Models;
    using System;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// Information used to connect to an Azure Storage Container using Blobfuse.
    /// </summary>
    public partial class AzureBlobFileSystemConfiguration : ITransportObjectProvider<Models.AzureBlobFileSystemConfiguration>, IPropertyMetadata
    {
        private class PropertyContainer : PropertyCollection
        {
            public readonly PropertyAccessor<string> AccountKeyProperty;
            public readonly PropertyAccessor<string> AccountNameProperty;
            public readonly PropertyAccessor<string> BlobfuseOptionsProperty;
            public readonly PropertyAccessor<string> ContainerNameProperty;
            public readonly PropertyAccessor<ComputeNodeIdentityReference> IdentityReferenceProperty;
            public readonly PropertyAccessor<string> RelativeMountPathProperty;
            public readonly PropertyAccessor<string> SasKeyProperty;

            public PropertyContainer() : base(BindingState.Unbound)
            {
                this.AccountKeyProperty = this.CreatePropertyAccessor<string>(nameof(AccountKey), BindingAccess.Read | BindingAccess.Write);
                this.AccountNameProperty = this.CreatePropertyAccessor<string>(nameof(AccountName), BindingAccess.Read | BindingAccess.Write);
                this.BlobfuseOptionsProperty = this.CreatePropertyAccessor<string>(nameof(BlobfuseOptions), BindingAccess.Read | BindingAccess.Write);
                this.ContainerNameProperty = this.CreatePropertyAccessor<string>(nameof(ContainerName), BindingAccess.Read | BindingAccess.Write);
                this.IdentityReferenceProperty = this.CreatePropertyAccessor<ComputeNodeIdentityReference>(nameof(IdentityReference), BindingAccess.Read | BindingAccess.Write);
                this.RelativeMountPathProperty = this.CreatePropertyAccessor<string>(nameof(RelativeMountPath), BindingAccess.Read | BindingAccess.Write);
                this.SasKeyProperty = this.CreatePropertyAccessor<string>(nameof(SasKey), BindingAccess.Read | BindingAccess.Write);
            }

            public PropertyContainer(Models.AzureBlobFileSystemConfiguration protocolObject) : base(BindingState.Bound)
            {
                this.AccountKeyProperty = this.CreatePropertyAccessor(
                    protocolObject.AccountKey,
                    nameof(AccountKey),
                    BindingAccess.Read);
                this.AccountNameProperty = this.CreatePropertyAccessor(
                    protocolObject.AccountName,
                    nameof(AccountName),
                    BindingAccess.Read);
                this.BlobfuseOptionsProperty = this.CreatePropertyAccessor(
                    protocolObject.BlobfuseOptions,
                    nameof(BlobfuseOptions),
                    BindingAccess.Read);
                this.ContainerNameProperty = this.CreatePropertyAccessor(
                    protocolObject.ContainerName,
                    nameof(ContainerName),
                    BindingAccess.Read);
                this.IdentityReferenceProperty = this.CreatePropertyAccessor(
                    UtilitiesInternal.CreateObjectWithNullCheck(protocolObject.IdentityReference, o => new ComputeNodeIdentityReference(o).Freeze()),
                    nameof(IdentityReference),
                    BindingAccess.Read);
                this.RelativeMountPathProperty = this.CreatePropertyAccessor(
                    protocolObject.RelativeMountPath,
                    nameof(RelativeMountPath),
                    BindingAccess.Read);
                this.SasKeyProperty = this.CreatePropertyAccessor(
                    protocolObject.SasKey,
                    nameof(SasKey),
                    BindingAccess.Read);
            }
        }

        private readonly PropertyContainer propertyContainer;

        #region Constructors

        /// <summary>
        /// Initializes a new instance of the <see cref="AzureBlobFileSystemConfiguration"/> class.
        /// </summary>
        /// <param name='accountName'>The Azure Storage account name.</param>
        /// <param name='containerName'>The Azure Blob Storage Container name.</param>
        /// <param name='relativeMountPath'>The relative path on the compute node where the file system will be mounted.</param>
        /// <param name='accountKey'>The Azure Storage Account key. This property is mutually exclusive with <see cref="SasKey"/>.</param>
        /// <param name='sasKey'>The Azure Storage SAS token. This property is mutually exclusive with <see cref="AccountKey"/>.</param>
        /// <param name='blobfuseOptions'>Additional command line options to pass to the mount command.</param>
        /// <param name='identityReference'>The reference to the user assigned identity to use to access containerName</param>
        internal AzureBlobFileSystemConfiguration(
            string accountName,
            string containerName,
            string relativeMountPath,
            string accountKey = default(string),
            string sasKey = default(string),
            string blobfuseOptions = default(string),
            ComputeNodeIdentityReference identityReference = default(ComputeNodeIdentityReference))
        {
            this.propertyContainer = new PropertyContainer();
            this.AccountName = accountName;
            this.ContainerName = containerName;
            this.RelativeMountPath = relativeMountPath;
            this.AccountKey = accountKey;
            this.SasKey = sasKey;
            this.BlobfuseOptions = blobfuseOptions;
            this.IdentityReference = identityReference;
        }

        /// <summary>
        /// Default constructor to support mocking the <see cref="AzureBlobFileSystemConfiguration"/> class.
        /// </summary>
        protected AzureBlobFileSystemConfiguration()
        {
            this.propertyContainer = new PropertyContainer();
        }

        internal AzureBlobFileSystemConfiguration(Models.AzureBlobFileSystemConfiguration protocolObject)
        {
            this.propertyContainer = new PropertyContainer(protocolObject);
        }

        #endregion Constructors

        #region AzureBlobFileSystemConfiguration

        /// <summary>
        /// Gets the Azure Storage Account key. This property is mutually exclusive with <see cref="SasKey"/>.
        /// </summary>
        public string AccountKey
        {
            get { return this.propertyContainer.AccountKeyProperty.Value; }
            private set { this.propertyContainer.AccountKeyProperty.Value = value; }
        }

        /// <summary>
        /// Gets the Azure Storage account name.
        /// </summary>
        public string AccountName
        {
            get { return this.propertyContainer.AccountNameProperty.Value; }
            private set { this.propertyContainer.AccountNameProperty.Value = value; }
        }

        /// <summary>
        /// Gets additional command line options to pass to the mount command.
        /// </summary>
        /// <remarks>
        /// These are 'net use' options in Windows and 'mount' options in Linux.
        /// </remarks>
        public string BlobfuseOptions
        {
            get { return this.propertyContainer.BlobfuseOptionsProperty.Value; }
            private set { this.propertyContainer.BlobfuseOptionsProperty.Value = value; }
        }

        /// <summary>
        /// Gets the Azure Blob Storage Container name.
        /// </summary>
        public string ContainerName
        {
            get { return this.propertyContainer.ContainerNameProperty.Value; }
            private set { this.propertyContainer.ContainerNameProperty.Value = value; }
        }

        /// <summary>
        /// Gets or sets the reference to the user assigned identity to use to access containerName
        /// </summary>
        /// <remarks>
        /// This property is mutually exclusive with both accountKey and sasKey; exactly one must be specified.
        /// </remarks>
        public ComputeNodeIdentityReference IdentityReference
        {
            get { return this.propertyContainer.IdentityReferenceProperty.Value; }
            set { this.propertyContainer.IdentityReferenceProperty.Value = value; }
        }

        /// <summary>
        /// Gets the relative path on the compute node where the file system will be mounted.
        /// </summary>
        /// <remarks>
        /// All file systems are mounted relative to the Batch mounts directory, accessible via the AZ_BATCH_NODE_MOUNTS_DIR 
        /// environment variable.
        /// </remarks>
        public string RelativeMountPath
        {
            get { return this.propertyContainer.RelativeMountPathProperty.Value; }
            private set { this.propertyContainer.RelativeMountPathProperty.Value = value; }
        }

        /// <summary>
        /// Gets the Azure Storage SAS token. This property is mutually exclusive with <see cref="AccountKey"/>.
        /// </summary>
        public string SasKey
        {
            get { return this.propertyContainer.SasKeyProperty.Value; }
            private set { this.propertyContainer.SasKeyProperty.Value = value; }
        }

        #endregion // AzureBlobFileSystemConfiguration

        #region IPropertyMetadata

        bool IModifiable.HasBeenModified
        {
            get { return this.propertyContainer.HasBeenModified; }
        }

        bool IReadOnly.IsReadOnly
        {
            get { return this.propertyContainer.IsReadOnly; }
            set { this.propertyContainer.IsReadOnly = value; }
        }

        #endregion //IPropertyMetadata

        #region Internal/private methods
        /// <summary>
        /// Return a protocol object of the requested type.
        /// </summary>
        /// <returns>The protocol object of the requested type.</returns>
        Models.AzureBlobFileSystemConfiguration ITransportObjectProvider<Models.AzureBlobFileSystemConfiguration>.GetTransportObject()
        {
            Models.AzureBlobFileSystemConfiguration result = new Models.AzureBlobFileSystemConfiguration()
            {
                AccountKey = this.AccountKey,
                AccountName = this.AccountName,
                BlobfuseOptions = this.BlobfuseOptions,
                ContainerName = this.ContainerName,
                IdentityReference = UtilitiesInternal.CreateObjectWithNullCheck(this.IdentityReference, (o) => o.GetTransportObject()),
                RelativeMountPath = this.RelativeMountPath,
                SasKey = this.SasKey,
            };

            return result;
        }


        #endregion // Internal/private methods
    }
}