// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

//
// This file was autogenerated by a tool.
// Do not modify it.
//

namespace Microsoft.Azure.Batch
{
    using Models = Microsoft.Azure.Batch.Protocol.Models;
    using System;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// The configuration parameters used for performing automatic OS upgrade.
    /// </summary>
    public partial class AutomaticOSUpgradePolicy : ITransportObjectProvider<Models.AutomaticOSUpgradePolicy>, IPropertyMetadata
    {
        private class PropertyContainer : PropertyCollection
        {
            public readonly PropertyAccessor<bool?> DisableAutomaticRollbackProperty;
            public readonly PropertyAccessor<bool?> EnableAutomaticOSUpgradeProperty;
            public readonly PropertyAccessor<bool?> OsRollingUpgradeDeferralProperty;
            public readonly PropertyAccessor<bool?> UseRollingUpgradePolicyProperty;

            public PropertyContainer() : base(BindingState.Unbound)
            {
                this.DisableAutomaticRollbackProperty = this.CreatePropertyAccessor<bool?>(nameof(DisableAutomaticRollback), BindingAccess.Read | BindingAccess.Write);
                this.EnableAutomaticOSUpgradeProperty = this.CreatePropertyAccessor<bool?>(nameof(EnableAutomaticOSUpgrade), BindingAccess.Read | BindingAccess.Write);
                this.OsRollingUpgradeDeferralProperty = this.CreatePropertyAccessor<bool?>(nameof(OsRollingUpgradeDeferral), BindingAccess.Read | BindingAccess.Write);
                this.UseRollingUpgradePolicyProperty = this.CreatePropertyAccessor<bool?>(nameof(UseRollingUpgradePolicy), BindingAccess.Read | BindingAccess.Write);
            }

            public PropertyContainer(Models.AutomaticOSUpgradePolicy protocolObject) : base(BindingState.Bound)
            {
                this.DisableAutomaticRollbackProperty = this.CreatePropertyAccessor(
                    protocolObject.DisableAutomaticRollback,
                    nameof(DisableAutomaticRollback),
                    BindingAccess.Read | BindingAccess.Write);
                this.EnableAutomaticOSUpgradeProperty = this.CreatePropertyAccessor(
                    protocolObject.EnableAutomaticOSUpgrade,
                    nameof(EnableAutomaticOSUpgrade),
                    BindingAccess.Read | BindingAccess.Write);
                this.OsRollingUpgradeDeferralProperty = this.CreatePropertyAccessor(
                    protocolObject.OsRollingUpgradeDeferral,
                    nameof(OsRollingUpgradeDeferral),
                    BindingAccess.Read | BindingAccess.Write);
                this.UseRollingUpgradePolicyProperty = this.CreatePropertyAccessor(
                    protocolObject.UseRollingUpgradePolicy,
                    nameof(UseRollingUpgradePolicy),
                    BindingAccess.Read | BindingAccess.Write);
            }
        }

        private readonly PropertyContainer propertyContainer;

        #region Constructors

        /// <summary>
        /// Initializes a new instance of the <see cref="AutomaticOSUpgradePolicy"/> class.
        /// </summary>
        public AutomaticOSUpgradePolicy()
        {
            this.propertyContainer = new PropertyContainer();
        }

        internal AutomaticOSUpgradePolicy(Models.AutomaticOSUpgradePolicy protocolObject)
        {
            this.propertyContainer = new PropertyContainer(protocolObject);
        }

        #endregion Constructors

        #region AutomaticOSUpgradePolicy

        /// <summary>
        /// Gets or sets whether OS image rollback feature should be disabled
        /// </summary>
        public bool? DisableAutomaticRollback
        {
            get { return this.propertyContainer.DisableAutomaticRollbackProperty.Value; }
            set { this.propertyContainer.DisableAutomaticRollbackProperty.Value = value; }
        }

        /// <summary>
        /// Gets or sets indicates whether OS upgrades should automatically be applied to scale set instances in a rolling 
        /// fashion when a newer version of the OS image becomes available. <br /><br /> If this is set to true for Windows 
        /// based pools, [WindowsConfiguration.enableAutomaticUpdates](https://learn.microsoft.com/en-us/rest/api/batchservice/pool/add?tabs=HTTP#windowsconfiguration) 
        /// cannot be set to true.
        /// </summary>
        public bool? EnableAutomaticOSUpgrade
        {
            get { return this.propertyContainer.EnableAutomaticOSUpgradeProperty.Value; }
            set { this.propertyContainer.EnableAutomaticOSUpgradeProperty.Value = value; }
        }

        /// <summary>
        /// Gets or sets defer OS upgrades on the TVMs if they are running tasks.
        /// </summary>
        public bool? OsRollingUpgradeDeferral
        {
            get { return this.propertyContainer.OsRollingUpgradeDeferralProperty.Value; }
            set { this.propertyContainer.OsRollingUpgradeDeferralProperty.Value = value; }
        }

        /// <summary>
        /// Gets or sets indicates whether rolling upgrade policy should be used during Auto OS Upgrade. Auto OS Upgrade 
        /// will fallback to the default policy if no policy is defined on the VMSS.
        /// </summary>
        public bool? UseRollingUpgradePolicy
        {
            get { return this.propertyContainer.UseRollingUpgradePolicyProperty.Value; }
            set { this.propertyContainer.UseRollingUpgradePolicyProperty.Value = value; }
        }

        #endregion // AutomaticOSUpgradePolicy

        #region IPropertyMetadata

        bool IModifiable.HasBeenModified
        {
            get { return this.propertyContainer.HasBeenModified; }
        }

        bool IReadOnly.IsReadOnly
        {
            get { return this.propertyContainer.IsReadOnly; }
            set { this.propertyContainer.IsReadOnly = value; }
        }

        #endregion //IPropertyMetadata

        #region Internal/private methods
        /// <summary>
        /// Return a protocol object of the requested type.
        /// </summary>
        /// <returns>The protocol object of the requested type.</returns>
        Models.AutomaticOSUpgradePolicy ITransportObjectProvider<Models.AutomaticOSUpgradePolicy>.GetTransportObject()
        {
            Models.AutomaticOSUpgradePolicy result = new Models.AutomaticOSUpgradePolicy()
            {
                DisableAutomaticRollback = this.DisableAutomaticRollback,
                EnableAutomaticOSUpgrade = this.EnableAutomaticOSUpgrade,
                OsRollingUpgradeDeferral = this.OsRollingUpgradeDeferral,
                UseRollingUpgradePolicy = this.UseRollingUpgradePolicy,
            };

            return result;
        }


        #endregion // Internal/private methods
    }
}