// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

//
// This file was autogenerated by a tool.
// Do not modify it.
//

namespace Microsoft.Azure.Batch
{
    using Models = Microsoft.Azure.Batch.Protocol.Models;
    using System;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// Specifies the parameters for the auto user that runs a task on the Batch service
    /// </summary>
    public partial class AutoUserSpecification : ITransportObjectProvider<Models.AutoUserSpecification>, IPropertyMetadata
    {
        #region Constructors
        /// <summary>
        /// Initializes a new instance of the <see cref="AutoUserSpecification"/> class.
        /// </summary>
        /// <param name='scope'>The scope for the auto user. If omitted, the default is <see cref="Common.AutoUserScope.Pool"/>.</param>
        /// <param name='elevationLevel'>The elevation level of the auto user. If omitted, the default is <see cref="Common.ElevationLevel.NonAdmin"/>.</param>
        public AutoUserSpecification(
            Common.AutoUserScope? scope = default(Common.AutoUserScope?),
            Common.ElevationLevel? elevationLevel = default(Common.ElevationLevel?))
        {
            this.Scope = scope;
            this.ElevationLevel = elevationLevel;
        }

        internal AutoUserSpecification(Models.AutoUserSpecification protocolObject)
        {
            this.ElevationLevel = UtilitiesInternal.MapNullableEnum<Models.ElevationLevel, Common.ElevationLevel>(protocolObject.ElevationLevel);
            this.Scope = UtilitiesInternal.MapNullableEnum<Models.AutoUserScope, Common.AutoUserScope>(protocolObject.Scope);
        }

        #endregion Constructors

        #region AutoUserSpecification

        /// <summary>
        /// Gets the elevation level of the auto user. If omitted, the default is <see cref="Common.ElevationLevel.NonAdmin"/>.
        /// </summary>
        public Common.ElevationLevel? ElevationLevel { get; }

        /// <summary>
        /// Gets the scope for the auto user. If omitted, the default is <see cref="Common.AutoUserScope.Pool"/>.
        /// </summary>
        /// <remarks>
        /// If the pool is running Windows a value of <see cref="Common.AutoUserScope.Task"/> should be specified if stricter 
        /// isolation between tasks is required. For example, if the Task mutates the registry in a way which could impact 
        /// other Tasks, or if Certificates have been specified on the pool which should not be accessible by normal tasks 
        /// but should be accessible by StartTasks.
        /// </remarks>
        public Common.AutoUserScope? Scope { get; }

        #endregion // AutoUserSpecification

        #region IPropertyMetadata

        bool IModifiable.HasBeenModified
        {
            //This class is compile time readonly so it cannot have been modified
            get { return false; }
        }

        bool IReadOnly.IsReadOnly
        {
            get { return true; }
            set
            {
                // This class is compile time readonly already
            }
        }

        #endregion // IPropertyMetadata

        #region Internal/private methods

        /// <summary>
        /// Return a protocol object of the requested type.
        /// </summary>
        /// <returns>The protocol object of the requested type.</returns>
        Models.AutoUserSpecification ITransportObjectProvider<Models.AutoUserSpecification>.GetTransportObject()
        {
            Models.AutoUserSpecification result = new Models.AutoUserSpecification()
            {
                ElevationLevel = UtilitiesInternal.MapNullableEnum<Common.ElevationLevel, Models.ElevationLevel>(this.ElevationLevel),
                Scope = UtilitiesInternal.MapNullableEnum<Common.AutoUserScope, Models.AutoUserScope>(this.Scope),
            };

            return result;
        }


        #endregion // Internal/private methods
    }
}