// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

//
// This file was autogenerated by a tool.
// Do not modify it.
//

namespace Microsoft.Azure.Batch
{
    using Models = Microsoft.Azure.Batch.Protocol.Models;
    using System;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// The settings for an authentication token that the task can use to perform Batch service operations.
    /// </summary>
    public partial class AuthenticationTokenSettings : ITransportObjectProvider<Models.AuthenticationTokenSettings>, IPropertyMetadata
    {
        private class PropertyContainer : PropertyCollection
        {
            public readonly PropertyAccessor<Common.AccessScope> AccessProperty;

            public PropertyContainer() : base(BindingState.Unbound)
            {
                this.AccessProperty = this.CreatePropertyAccessor<Common.AccessScope>(nameof(Access), BindingAccess.Read | BindingAccess.Write);
            }

            public PropertyContainer(Models.AuthenticationTokenSettings protocolObject) : base(BindingState.Bound)
            {
                this.AccessProperty = this.CreatePropertyAccessor(
                    UtilitiesInternal.ParseAccessScope(protocolObject.Access),
                    nameof(Access),
                    BindingAccess.Read | BindingAccess.Write);
            }
        }

        private readonly PropertyContainer propertyContainer;

        #region Constructors

        /// <summary>
        /// Initializes a new instance of the <see cref="AuthenticationTokenSettings"/> class.
        /// </summary>
        public AuthenticationTokenSettings()
        {
            this.propertyContainer = new PropertyContainer();
        }

        internal AuthenticationTokenSettings(Models.AuthenticationTokenSettings protocolObject)
        {
            this.propertyContainer = new PropertyContainer(protocolObject);
        }

        #endregion Constructors

        #region AuthenticationTokenSettings

        /// <summary>
        /// Gets or sets the Batch resources to which the token grants access.
        /// </summary>
        /// <remarks>
        /// The authentication token grants access only to a limited set of Batch service operations. Currently the only 
        /// supported value for the Access property is <see cref="Common.AccessScope.Job"/>, which grants access to all operations 
        /// related to the job which contains the task.
        /// </remarks>
        public Common.AccessScope Access
        {
            get { return this.propertyContainer.AccessProperty.Value; }
            set { this.propertyContainer.AccessProperty.Value = value; }
        }

        #endregion // AuthenticationTokenSettings

        #region IPropertyMetadata

        bool IModifiable.HasBeenModified
        {
            get { return this.propertyContainer.HasBeenModified; }
        }

        bool IReadOnly.IsReadOnly
        {
            get { return this.propertyContainer.IsReadOnly; }
            set { this.propertyContainer.IsReadOnly = value; }
        }

        #endregion //IPropertyMetadata

        #region Internal/private methods
        /// <summary>
        /// Return a protocol object of the requested type.
        /// </summary>
        /// <returns>The protocol object of the requested type.</returns>
        Models.AuthenticationTokenSettings ITransportObjectProvider<Models.AuthenticationTokenSettings>.GetTransportObject()
        {
            Models.AuthenticationTokenSettings result = new Models.AuthenticationTokenSettings()
            {
                Access = UtilitiesInternal.AccessScopeToList(this.Access),
            };

            return result;
        }


        #endregion // Internal/private methods
    }
}