// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

//
// This file was autogenerated by a tool.
// Do not modify it.
//

namespace Microsoft.Azure.Batch
{
    using Models = Microsoft.Azure.Batch.Protocol.Models;
    using System;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// Contains information about an application in an Azure Batch account.
    /// </summary>
    public partial class ApplicationSummary : IPropertyMetadata
    {
        #region Constructors

        internal ApplicationSummary(Models.ApplicationSummary protocolObject)
        {
            this.DisplayName = protocolObject.DisplayName;
            this.Id = protocolObject.Id;
            this.Versions = UtilitiesInternal.CreateObjectWithNullCheck(protocolObject.Versions, o => o.ToList().AsReadOnly());
        }

        #endregion Constructors

        #region ApplicationSummary

        /// <summary>
        /// Gets the display name of the application.
        /// </summary>
        public string DisplayName { get; }

        /// <summary>
        /// Gets the id of the application.
        /// </summary>
        public string Id { get; }

        /// <summary>
        /// Gets a readonly list of available versions of the application.
        /// </summary>
        public IReadOnlyList<string> Versions { get; }

        #endregion // ApplicationSummary

        #region IPropertyMetadata

        bool IModifiable.HasBeenModified
        {
            //This class is compile time readonly so it cannot have been modified
            get { return false; }
        }

        bool IReadOnly.IsReadOnly
        {
            get { return true; }
            set
            {
                // This class is compile time readonly already
            }
        }

        #endregion // IPropertyMetadata
    }
}