# License notes

The Azure Batch C# client is now under the MIT license. Prior to March 10 2017 it was under the Apache 2.0 license.

## Azure Batch SDK developer guide

`Microsoft.Azure.Batch.sln` is your one stop shop for all things related to the Azure Batch C# client library. This solution file contains all of the projects affiliated with the Azure Batch client (including testing and tooling).

## Changing the Azure Batch client

Depending on the type of change you want to make, the work required varies. If you follow this process you shouldn't miss anything:

1. Update the Azure Batch Swagger specification, which resides in the [Azure/azure-rest-api-specs](https://github.com/Azure/azure-rest-api-specs) GitHub repository (specifically [here](https://github.com/Azure/azure-rest-api-specs/tree/master/specification/batch/data-plane))
    * Add new entity types into the Swagger specification.
    * Add new APIs as path-verb pairs in the Swagger specification.
    * Add/remove properties on existing entity types in the Swagger specification.
2. Regenerate the `src\GeneratedProtocol` folder using the steps [below](#generate-the-srcgeneratedprotocol-folder-using-autorest).
3. Update the corresponding convenience layer specification file(s) located in `Tools\ObjectModelCodeGenerator\Spec`.
    * Add new entities that match the Swagger defined entities.
    * Add/remove properties on existing entities as done in the Swagger specification.
    * Ensure that documentation is properly updated to reflect changes made in the Swagger specification (it usually helps to look at a diff of the Swagger for the API version in question).
4. Regenerate the `src\Generated` folder from the convenience layer specification file using the steps [below](#generate-the-srcgenerated-folder).
5. Add any custom code on the `Generated` objects into `partial` classes located in the `src` directory.
    * You might want to do this to add an `[Obsolete]` attribute or to add some helper factory methods.
6. If any APIs have changed, or if new APIs have been added, you must update the following places:
    * The `src\IProtocolLayer.cs` interface.
    * The `src\ProtocolLayer.cs` class.  
    * The corresponding operations class, for example `PoolOperations.cs`.
    * The corresponding entity which the operation is performed on, for example `CloudPool.cs`.
7. Add tests for your new models and APIs into the correct test projects.
    * `Azure.Batch.Unit.Tests` for unit tests. These tests do not have any external dependencies (they run entirely in-memory) and are used in the continuous integration job to validate checkins.
    * `BatchClientIntegrationTests` for integration tests. These tests run against a live Azure Batch endpoint and do not run during CI. See [running the end to end tests](#running-the-end-to-end-tests) for more details about how to run these tests.
    * **Note:** You should prefer to add unit tests over integration tests where possible -- integration tests should be reserved for ensuring that the Batch Service accepts the Swagger requests. Testing service behavior should occur in a service test, not the client.
8. Update the `CHANGELOG.md` file and the `Version` tag in `src/Microsoft.Azure.Batch.csproj`. Ensure that if you are making a breaking change, you update the major version of the version number.
9. Run the tests and ensure that they pass.
10. Open a PR to <https://github.com/Azure/azure-sdk-for-net>

### Generate the `src\GeneratedProtocol` folder using AutoRest

The GeneratedProtocol folder holds the code generated by the [AutoRest](https://github.com/Azure/autorest) tool from a Swagger specification. The AutoRest tool has a command line interface of its own which you can use directly, or you can run `powershell Start-AutoRestCodeGeneration -ResourceProvider "batch/data-plane" -SdkRepoRootPath "<path to root of this repo>" -AutoRestVersion "latest" -SdkGenerationDirectory "<path to root of this repo>\sdk\batch\Microsoft.Azure.Batch\src\GeneratedProtocol" -ConfigFileTag "package-2020-03.11.0"`

### Generate the `src\Generated` folder

This folder contains the convenience layer models for Azure Batch. It is generated from a custom tool. The custom tool reads all of the specification files located in `Tools\ObjectModelCodeGenerator\Spec`. The convenience layer models require more metadata than the Swagger specification provides, so this file is an extra mapping layer on top of Swagger which provides more detail. **Note:** These specification files are all about the models, they have nothing to do with the actual APIs.

1. New entities defined in the Swagger specification have to be added here as well. See an existing entity for an example.
2. If the type or name of a property has changed in the underlying Swagger specification, it should be updated here as well.

There are a number of special flags which have meaning in the specification files. The easiest way to see a list of what flags are supported and at what level is to look at the backing code generation code:

1. For properties: `Tools\ObjectModelCodeGeneration\CodeGenerationLibrary\PropertyData.cs`
2. For types: `Tools\ObjectModelCodeGeneration\CodeGenerationLibrary\ObjectModelTypeData.cs`

Once you have added and updated the required files in `Tools\ObjectModelCodeGenerator\Spec` mark the `ObjectModelCodeGenerator` as your startup project in Visual Studio and run it -- it will regenerate the contents of the `src\Generated` folder.

## Running the end to end tests

A full end to end test pass takes 20-40 minutes.
The following environment variables must be set for the the end to end tests to work - it is recommended to set up a script which sets these all so that it can easily be reused later:

1. `MABOM_BatchAccountEndpoint`: The endpoint for your Batch account, i.e. `https://<account>.<region>.batch.azure.com`
2. `MABOM_BatchAccountSubscriptionId`: The subscription id that your Batch and Storage accounts are in. Please note your storage account and your Batch account need to be in the same subscription.
3. `MABOM_BatchAccountResourceGroupName`: The resource group your Batch account is in.
4. `MABOM_BatchAccountName`: The name of your Batch account.
5. `​MABOM_BatchAccountKey`: The key of your Batch account.
6. `MABOM_StorageAccountResourceGroupName`: The name of the resource group of your storage account.
7. `MABOM_StorageAccount`: The name of your storage account.
8. `MABOM_StorageKey`: The key to your storage account.
9. `MABOM_BlobEndpoint`: The blob endpoint for the storage account, i.e. `https://<account>.blob.core.windows.net`
10. `MABOM_BatchManagementEndpoint`: The management endpoint for the tenant you are targeting. This will usually be `https://management.azure.com/`.
11. `MABOM_AzureAuthenticationClientId`: The client ID of an AAD App Registration with contributor access to the subscription you're using (#2).
12. `MABOM_AzureAuthenticationClientSecret`: The secret for the App Registration (#11).

If running the tests against a test tenant, you also must set:

13. `MABOM_BatchTRPExtraHeaders` to x-ms-version=2015-12-01;x-ms-client-tenant-id=microsoft.onmicrosoft.com
14. `MABOM_BatchTRPCertificateThumbprint`: The thumbprint used to authenticate with the Batch Resource Provider.

![Impressions](https://azure-sdk-impressions.azurewebsites.net/api/impressions/azure-sdk-for-net%2Fsdk%2Fbatch%2FMicrosoft.Azure.Batch%2FREADME.png)
