// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Batch.Models
{
    internal static partial class UpgradeModeExtensions
    {
        public static string ToSerialString(this UpgradeMode value) => value switch
        {
            UpgradeMode.Automatic => "automatic",
            UpgradeMode.Manual => "manual",
            UpgradeMode.Rolling => "rolling",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown UpgradeMode value.")
        };

        public static UpgradeMode ToUpgradeMode(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "automatic")) return UpgradeMode.Automatic;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "manual")) return UpgradeMode.Manual;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "rolling")) return UpgradeMode.Rolling;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown UpgradeMode value.");
        }
    }
}
