// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Batch.Models
{
    internal static partial class NodeCommunicationModeExtensions
    {
        public static string ToSerialString(this NodeCommunicationMode value) => value switch
        {
            NodeCommunicationMode.Default => "Default",
            NodeCommunicationMode.Classic => "Classic",
            NodeCommunicationMode.Simplified => "Simplified",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown NodeCommunicationMode value.")
        };

        public static NodeCommunicationMode ToNodeCommunicationMode(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Default")) return NodeCommunicationMode.Default;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Classic")) return NodeCommunicationMode.Classic;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Simplified")) return NodeCommunicationMode.Simplified;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown NodeCommunicationMode value.");
        }
    }
}
