// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Batch.Models
{
    /// <summary> Network security perimeter configuration profile. </summary>
    public partial class NetworkSecurityProfile
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="NetworkSecurityProfile"/>. </summary>
        internal NetworkSecurityProfile()
        {
            AccessRules = new ChangeTrackingList<BatchAccessRule>();
            EnabledLogCategories = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="NetworkSecurityProfile"/>. </summary>
        /// <param name="name"> Name of the profile. </param>
        /// <param name="accessRulesVersion"> Current access rules version. </param>
        /// <param name="accessRules"> List of Access Rules. </param>
        /// <param name="diagnosticSettingsVersion"> Current diagnostic settings version. </param>
        /// <param name="enabledLogCategories"> List of log categories that are enabled. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal NetworkSecurityProfile(string name, int? accessRulesVersion, IReadOnlyList<BatchAccessRule> accessRules, int? diagnosticSettingsVersion, IReadOnlyList<string> enabledLogCategories, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            AccessRulesVersion = accessRulesVersion;
            AccessRules = accessRules;
            DiagnosticSettingsVersion = diagnosticSettingsVersion;
            EnabledLogCategories = enabledLogCategories;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Name of the profile. </summary>
        public string Name { get; }
        /// <summary> Current access rules version. </summary>
        public int? AccessRulesVersion { get; }
        /// <summary> List of Access Rules. </summary>
        public IReadOnlyList<BatchAccessRule> AccessRules { get; }
        /// <summary> Current diagnostic settings version. </summary>
        public int? DiagnosticSettingsVersion { get; }
        /// <summary> List of log categories that are enabled. </summary>
        public IReadOnlyList<string> EnabledLogCategories { get; }
    }
}
