// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.Batch.Models
{
    /// <summary> Information about a network security perimeter (NSP). </summary>
    public partial class NetworkSecurityPerimeter
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="NetworkSecurityPerimeter"/>. </summary>
        internal NetworkSecurityPerimeter()
        {
        }

        /// <summary> Initializes a new instance of <see cref="NetworkSecurityPerimeter"/>. </summary>
        /// <param name="id"> Fully qualified Azure resource ID of the NSP resource. </param>
        /// <param name="perimeterGuid"> Universal unique ID (UUID) of the network security perimeter. </param>
        /// <param name="location"> Location of the network security perimeter. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal NetworkSecurityPerimeter(ResourceIdentifier id, Guid? perimeterGuid, AzureLocation? location, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Id = id;
            PerimeterGuid = perimeterGuid;
            Location = location;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Fully qualified Azure resource ID of the NSP resource. </summary>
        public ResourceIdentifier Id { get; }
        /// <summary> Universal unique ID (UUID) of the network security perimeter. </summary>
        public Guid? PerimeterGuid { get; }
        /// <summary> Location of the network security perimeter. </summary>
        public AzureLocation? Location { get; }
    }
}
