// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Batch.Models
{
    /// <summary> The paths which will be mounted to container task's container. </summary>
    public readonly partial struct ContainerHostDataPath : IEquatable<ContainerHostDataPath>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ContainerHostDataPath"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ContainerHostDataPath(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SharedValue = "Shared";
        private const string StartupValue = "Startup";
        private const string VfsMountsValue = "VfsMounts";
        private const string TaskValue = "Task";
        private const string JobPrepValue = "JobPrep";
        private const string ApplicationsValue = "Applications";

        /// <summary> The path for multi-instances task to shared their files. </summary>
        public static ContainerHostDataPath Shared { get; } = new ContainerHostDataPath(SharedValue);
        /// <summary> The path for start task. </summary>
        public static ContainerHostDataPath Startup { get; } = new ContainerHostDataPath(StartupValue);
        /// <summary> The path contains all virtual file systems are mounted on this node. </summary>
        public static ContainerHostDataPath VfsMounts { get; } = new ContainerHostDataPath(VfsMountsValue);
        /// <summary> The task path. </summary>
        public static ContainerHostDataPath Task { get; } = new ContainerHostDataPath(TaskValue);
        /// <summary> The job-prep task path. </summary>
        public static ContainerHostDataPath JobPrep { get; } = new ContainerHostDataPath(JobPrepValue);
        /// <summary> The applications path. </summary>
        public static ContainerHostDataPath Applications { get; } = new ContainerHostDataPath(ApplicationsValue);
        /// <summary> Determines if two <see cref="ContainerHostDataPath"/> values are the same. </summary>
        public static bool operator ==(ContainerHostDataPath left, ContainerHostDataPath right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ContainerHostDataPath"/> values are not the same. </summary>
        public static bool operator !=(ContainerHostDataPath left, ContainerHostDataPath right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ContainerHostDataPath"/>. </summary>
        public static implicit operator ContainerHostDataPath(string value) => new ContainerHostDataPath(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ContainerHostDataPath other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ContainerHostDataPath other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
