// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Batch.Models
{
    /// <summary> The container technology to be used. </summary>
    public readonly partial struct BatchVmContainerType : IEquatable<BatchVmContainerType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BatchVmContainerType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BatchVmContainerType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DockerCompatibleValue = "DockerCompatible";
        private const string CriCompatibleValue = "CriCompatible";

        /// <summary> A Docker compatible container technology will be used to launch the containers. </summary>
        public static BatchVmContainerType DockerCompatible { get; } = new BatchVmContainerType(DockerCompatibleValue);
        /// <summary> A CRI based technology will be used to launch the containers. </summary>
        public static BatchVmContainerType CriCompatible { get; } = new BatchVmContainerType(CriCompatibleValue);
        /// <summary> Determines if two <see cref="BatchVmContainerType"/> values are the same. </summary>
        public static bool operator ==(BatchVmContainerType left, BatchVmContainerType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BatchVmContainerType"/> values are not the same. </summary>
        public static bool operator !=(BatchVmContainerType left, BatchVmContainerType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BatchVmContainerType"/>. </summary>
        public static implicit operator BatchVmContainerType(string value) => new BatchVmContainerType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BatchVmContainerType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BatchVmContainerType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
