// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.Batch.Models
{
    /// <summary> A private container registry. </summary>
    public partial class BatchVmContainerRegistry
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BatchVmContainerRegistry"/>. </summary>
        public BatchVmContainerRegistry()
        {
        }

        /// <summary> Initializes a new instance of <see cref="BatchVmContainerRegistry"/>. </summary>
        /// <param name="userName"> The user name to log into the registry server. </param>
        /// <param name="password"> The password to log into the registry server. </param>
        /// <param name="registryServer"> If omitted, the default is "docker.io". </param>
        /// <param name="identity"> The reference to a user assigned identity associated with the Batch pool which a compute node will use. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BatchVmContainerRegistry(string userName, string password, string registryServer, ComputeNodeIdentityReference identity, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            UserName = userName;
            Password = password;
            RegistryServer = registryServer;
            Identity = identity;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The user name to log into the registry server. </summary>
        public string UserName { get; set; }
        /// <summary> The password to log into the registry server. </summary>
        public string Password { get; set; }
        /// <summary> If omitted, the default is "docker.io". </summary>
        public string RegistryServer { get; set; }
        /// <summary> The reference to a user assigned identity associated with the Batch pool which a compute node will use. </summary>
        internal ComputeNodeIdentityReference Identity { get; set; }
        /// <summary> The ARM resource id of the user assigned identity. </summary>
        public ResourceIdentifier IdentityResourceId
        {
            get => Identity is null ? default : Identity.ResourceId;
            set
            {
                if (Identity is null)
                    Identity = new ComputeNodeIdentityReference();
                Identity.ResourceId = value;
            }
        }
    }
}
